/*
 * File......: FIELD.PRG
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: $Date:   15 Aug 1991 23:04:50  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/field.prv  $
 * 
 * This is an original work by Steve Kolterman and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/field.prv  $
 * 
 *    Rev 1.3   15 Aug 1991 23:04:50   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.2   17 Jul 1991 22:24:14   GLENN
 * Steve sent in a lot of changes and a couple of extra functions.
 * Too many to mention.
 * 
 *    Rev 1.1   14 Jun 1991 19:51:50   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:01:20   GLENN
 * Nanforum Toolkit
 *
 */


#define VTV     Valtype( var )
#define FGV     FieldGet( var )
#define FGFPV   FieldGet(FieldPos(var))
#define VTFGV   Valtype(FGV)
#define VTFGFPV Valtype(FGFPV)
#define FVAL    IF( VTV=="N",FGV,FGFPV )
#define VTFVAL  IF( VTV=="N",VTFGV,VTFGFPV )
#define DBS_NAME  1


#ifdef FT_TEST

#translate Clear() => SCROLL(); SetPos(0,0)
#define NTOC(v) LTRIM(STR( v ))
#define K_ESC 27
#define DEMOCOLOR IF(iscolor(),"+gr/b","+w/n")

  FUNCTION Tester( dbff,numrecs )
     LOCAL oldcolor:= SETCOLOR( DEMOCOLOR ),xx,start,end,key:= 0,;
           fc,o_curs:=SetCursor(0)

     IF (dbff <> NIL) .AND. ( FILE( dbff ) .OR. FILE( dbff+".DBF" ) )
        Clear(); numrecs:= IF( numrecs==NIL,1,VAL(numrecs) )
        USE (dbff); fc:= fcount()

        WHILE numrecs > 0 .AND. key <> K_ESC
           FOR xx:= 1 to fc
              start:= Seconds()
*              ? "Testing SK Field Functions..."
              ? "  DATABASE: ",dbff
              ? "    FIELDS: ",NTOC(fcount())
              ? "    RECORD: ",NTOC(RECNO())
              ? "FIELD NAME: ",fieldname(xx)
              ?
              ? "RETURN values passing a name... "
              ? "  CONTENTS: ",FT_FVal( fieldname(xx) )
              ? "VALUE LENG: ",NTOC( FT_FValLen( fieldname(xx) ) )
              ? "FIELD NUMB: ",NTOC( FT_Fnum( fieldname(xx) ) )
              ? "FIELD TYPE: ",FT_Ftype( fieldname(xx) )
              ? "FIELD LENG: ",NTOC( FT_Flen( fieldname(xx) ) )
              ? "FIELD DECI: ",NTOC( FT_Fdec( fieldname(xx) ) )
              ? "FIELD EXIS: ",FT_Fexist( fieldname(xx) )
              ? "FIELD EMPT: ",FT_Fempty( fieldname(xx) )
              ?
              ? "and...RETURN values passing ordinals"
              ? "  CONTENTS: ",FT_Fval(xx)
              ? "VALUE LENG: ",NTOC( FT_FValLen( (xx) ) )
              ? "FIELD NUMB: ",NTOC( FT_Fnum( (xx) ) )
              ? "FIELD TYPE: ",FT_Ftype( xx )
              ? "FIELD LENG: ",NTOC(FT_Flen( xx ))
              ? "FIELD DECI: ",NTOC(FT_Fdec( xx ))
              ? "FIELD EXIS: ",FT_Fexist( (xx) )
              ? "FIELD EMPT: ",FT_Fempty( (xx) )
              ?
              end:= Seconds()
              ? "Executed In ",TRANSFORM((end -start),"9.999")," Secs."
              ? "Press Any Key; [Esc] To Get Out Now"
              ? key:= INKEY(0); Clear(); IF key==K_ESC; xx:= fc; END
           NEXT
           IF !EOF(); SKIP; ENDIF
           numrecs--
        ENDDO

        CLOSE ALL
        Clear()
     ELSE; Clear()
        Alert( "Bad or No .DBF Parameter",{"Quit"} )
     ENDIF
     SETCOLOR(oldcolor); SetCursor(o_curs)
     QUIT
  RETURN NIL

#endif


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FVAL()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return the value of a field.
 *  $SYNTAX$
 *      FT_FVAL( <xVar> ) -> xVal
 *  $ARGUMENTS$
 *     <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     value (contents) of the specified field.  NIL, if error.
 *  $DESCRIPTION$
 *     FT_FVAL() reports the value (contents) of any .DBF field.
 *  $EXAMPLES$
 *     xVal:= FT_FVAL( "unit_prc" )
 *     xVal:= FT_FVAL( 2 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     xVal:= FT_FVAL( nNum )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FVALLEN()  FT_FLEN()  FT_FDEC()  FT_FNUM()  FT_FTYPE()
 *  $END$
 */

FUNCTION FT_FVal( var )
RETURN (FVAL)


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FTYPE()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return a field's type, given field name or ordinal position
 *  $SYNTAX$
 *     FT_FTYPE( <xVar> ) -> cType
 *  $ARGUMENTS$
 *     <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     the type of field: character (C), numeric (N), date (D), logical (L),
 *     or memo (M).  "U", if NIL.
 *  $DESCRIPTION$
 *     FT_FTYPE() reports the type ("C","N","D","L","M") of any .DBF field.
 *  $EXAMPLES$
 *     cType:= FT_FTYPE( "unit_prc" )
 *     cType:= FT_FTYPE( 2 )
 *     - or -
 *     nNum:=  FT_FNUM( "unit_prc" )
 *     cType:= FT_FTYPE( nNum )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FVALLEN()  FT_FLEN()  FT_FDEC()  FT_FNUM()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FType( var )
RETURN (VTFVAL)


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FLEN()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return a field's length.
 *  $SYNTAX$
 *     FT_FLEN( <xVar> ) -> nLen
 *  $ARGUMENTS$
 *     <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     the length of the specified field.  -1 if error.
 *  $DESCRIPTION$
 *     FT_FLEN() reports the length of any .DBF field.
 *  $EXAMPLES$
 *     nLen:= FT_FLEN("unit_prc")
 *     nLen:= FT_FLEN( 2 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     nLen:= FT_FLEN( nNum )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FVALLEN()  FT_FDEC()  FT_FNUM()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FLen( var )
RETURN IF( !FT_FExist(var), -1 ,;
       IF( VTFVAL=="D",len(dtoc( FVAL )),;
       IF( VTFVAL=="L",1,;
       IF( VTFVAL=="M",10,;
       IF( VTFVAL=="C",len( FVAL ),;
       IF( VTFVAL=="N",len(str( FVAL )), -1 ))))))


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FVALLEN()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return the length of the value in a field.
 *  $SYNTAX$
 *     FT_FVALLEN( <xVar> ) -> nVlen
 *  $ARGUMENTS$
 *      <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *      the length of the value in a specified field.  -1 if error.
 *  $DESCRIPTION$
 *      FT_FVALLEN() reports the length of the value in any .DBF field.
 *  $EXAMPLES$
 *      nVallen:= FT_FVALLEN("unit_prc")
 *      nVallen:= FT_FVALLEN( 2 )
 *      - or -
 *      nNum:=    FT_FNUM( "unit_prc" )
 *      nVallen:= FT_FVALLEN( nNum )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FLEN()  FT_FDEC()  FT_FNUM()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FValLen( var )
RETURN IF( !FT_FExist(var), -1,;
       IF( VTFVAL=="D",len(dtoc( (FVAL) )),;
       IF( VTFVAL=="L",1,;
       IF( VTFVAL=="M",len( AllTrim( FVAL ) ),;
       IF( VTFVAL=="C",len( AllTrim( FVAL ) ),;
       IF( VTFVAL=="N",len( AllTrim( str(FVAL) ) ),-1 ))))))


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FDEC()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return the number of decimals in a numeric (type "N") field.
 *  $SYNTAX$
 *     FT_FDEC( <xVar> ) -> nDec
 *  $ARGUMENTS$
 *     <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     the number of decimal places in a numeric field.  -1 if field is
 *     not type "N", or if other error.
 *  $DESCRIPTION$
 *     FT_FDEC() reports the number of decimal places in a numeric field.
 *  $EXAMPLES$
 *     nDec:= FT_FDEC( "unit_prc" )
 *     nDec:= FT_FDEC( 2 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     nDec:= FT_FDEC( nNum )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FVALLEN()  FT_FLEN()  FT_FNUM()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FDec( var )
RETURN IF( VTFVAL <> "N" .or. !FT_Fexist(var), -1, ;
       IF( VTFVAL=="N" .and. "." $str( FVAL ), ;
       len(str( FVAL )) -at(".",str( FVAL )), 0))


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FNUM()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Return a field's ordinal position given the field name.
 *  $SYNTAX$
 *     FT_FNUM( <cVar> ) -> nNum
 *  $ARGUMENTS$
 *     <cVar> must be a valid field name.
 *  $RETURNS$
 *     the ordinal position of the field.  0, if a non-character value is
 *     passed or field <xVar> does not exist.
 *  $DESCRIPTION$
 *     In 5.01, FT_FNUM() was superseded by FieldPos().  Included here for
 *     those who already coded FT_FNUM() calls.
 *  $EXAMPLES$
 *     nNum:= FT_FNUM( "unit_prc" )
 *  $SEEALSO$
 *     FT_FPLACE()  FT_FVALLEN()  FT_FLEN()  FT_FDEC()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FNum( var )
RETURN IF( VTV=="C",FieldPos(var),0 )


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FPLACE()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Write a new value to a field.
 *  $SYNTAX$
 *     FT_FPLACE( <xVar>, <xVal> ) -> xVal
 *  $ARGUMENTS$
 *     <xVar> is either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     <xVal>, the FT_FPLACE()d value.  NIL if error.
 *  $DESCRIPTION$
 *     FT_FPLACE() writes a new value to a specified field of *ANY*
 *     Clipper-valid type.  In conjunction with the FIELDPLACE UDC
 *     (in FT_FIELD.CH), it constitutes a fully capable alternative to
 *     REPLACE.
 *  $EXAMPLES$
 *     xVal:= FT_FPLACE( "unit_prc", 15.73 )
 *     xVal:= FT_FPLACE( 2, 15.73 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     xVal:= FT_FPLACE( nNum,15.73 )
 *  $SEEALSO$
 *     FT_FVALLEN()  FT_FLEN()  FT_FDEC()  FT_FNUM()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_FPLACE( var,value )
RETURN FieldPut( IF( VTV=="N",var,FieldPos(var) ),value )


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FEXIST()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Check for the existence of a field.
 *  $SYNTAX$
 *     FT_FEXIST( <xVar>, <xVal> ) -> lVal
 *  $ARGUMENTS$
 *     <xVar> may be either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     <lVal>, a logical indicating a field's existence or lack thereof.
 *  $DESCRIPTION$
 *     FT_FEXIST() enables existence checking before proceeding with
 *     other operations.
 *  $EXAMPLES$
 *     lExi:= FT_FEXIST( "unit_prc" )
 *     lExi:= FT_FEXIST( 2 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     lExi:= FT_FEXIST( nNum )
 *  $SEEALSO$
 *     FT_FVALLEN()  FT_FLEN()  FT_FDEC()  FT_FNUM()  FT_FTYPE()  FT_FVAL()
 *  $END$
 */

FUNCTION FT_Fexist( var )
RETURN IF( (VTV) $ "NC",;
       IF( (VTV)=="N",!Empty(Fieldname(var)),(FieldPos(var) > 0) ), .F. )


/*  $DOC$
 *  $FUNCNAME$
 *     FT_FEMPTY()
 *  $CATEGORY$
 *     Database
 *  $ONELINER$
 *     Determine if a field is empty, i.e., contains no value.
 *  $SYNTAX$
 *     FT_FEMPTY( <xVar> ) -> lVal
 *  $ARGUMENTS$
 *     <xVar> may be either a field name or ordinal .DBF position.
 *  $RETURNS$
 *     <lVal>, a logical indicating if field <xVar> is empty.
 *  $DESCRIPTION$
 *     FT_FEMPTY() checks for the existence of a value in a field.
 *  $EXAMPLES$
 *     lEmp:= FT_FEMPTY( "unit_prc" )
 *     lEmp:= FT_FEMPTY( 2 )
 *     - or -
 *     nNum:= FT_FNUM( "unit_prc" )
 *     lEmp:= FT_FEMPTY( nNum )
 *  $END$
 */

FUNCTION FT_Fempty( var )
RETURN ( FT_FVallen(var) < 1 )


