/* Program: CURSIZE.C                 */
/* Author:  Gerry Braganza            */
/* Note(s): Sets cursor size.         */
/* Copyright (c) 1988 Nantucket Corp. */

#include "\fix\nandef.h"
#include "\fix\extend.h"
#include "\include\dos.h"
#define CURSIZE 1     /* Set cursor size service.     */
#define VIDEO 0x10    /* Video BIOS interrupt number. */

CLIPPER cursize()

{
    union REGS regs;

    /* Starting and ending cursor position. */
    int start;
    int end;

    /* Check for number of parameters passed. */
    if (_parinfo(0) != 2)
       {
       printf("Usage: cursize start(n) end(n)");
       
       }

    /* Check for parameters type. */
    if (_parinfo(1) != 2 || _parinfo(2) != 2)
       {
       printf("data type mismatch");
       
       }
    start = _parni(1);
    end   = _parni(2);

    regs.h.ch = (char)start;     /* Starting line number. */
    regs.h.cl = (char)end;       /* Ending line number.   */
    regs.h.ah = CURSIZE;         /* Service number.       */

    int86(VIDEO, &regs, &regs);  /* Call video interrupt. */
    
}
