Version 1.00
BEGIN Form frmCustom
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "Custom Element"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(15)
	Left         = Char(15)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(3)
	Visible      = -1
	Width        = Char(53)
	WindowState  = 0
	BEGIN Label Label1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&Abbreviation:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(7)
		MousePointer = 0
		TabIndex     = 0
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(13)
	END
	BEGIN TextBox txtCustom
		BackColor    = QBColor(14)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(22)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtCustom
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(22)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(15)
	END
	BEGIN Label Label2
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&Mass && uncertainty:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 2
		Tag          = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN Label lblDirections
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(6)
		Left         = Char(2)
		MousePointer = 0
		TabIndex     = 4
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(46)
	END
	BEGIN CommandButton cmdDone
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Done"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(38)
		MousePointer = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Top          = Char(0)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdCancel
		BackColor    = QBColor(7)
		Cancel       = -1
		Caption      = "&Cancel"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(38)
		MousePointer = 0
		TabIndex     = 6
		TabStop      = -1
		Tag          = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(12)
	END
END
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE SUB NumberFormat (BYVAL dNumber AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop%, srMsg AS STRING, rPrintX AS INTEGER)
OPTION EXPLICIT
DEFINT A-Z
DECLARE FUNCTION bAnalyzeInput (BYVAL sText AS STRING, dNumber AS DOUBLE, dError AS DOUBLE) AS INTEGER
'$INCLUDE: 'common.bi'
DIM SHARED tempAbbreviation AS STRING * 3
DIM SHARED dTempMass AS DOUBLE
DIM SHARED dTempUncertainty AS DOUBLE

CONST YELLOW = 14
CONST BRIGHT_CYAN = 11

CONST KEY_RETURN = 13           ' Enter key
CONST KEY_ESCAPE = 27
CONST KEY_UP = 38
CONST KEY_DOWN = 40
CONST KEY_BACK = 8
CONST KEY_DELETE = 127          ' Delete key returns 46 in Visual Basic for Windows.

SUB cmdCancel_Click ()
   UNLOAD frmCustom
END SUB

SUB cmdDone_Click ()
IF LTRIM$(tempAbbreviation) = "" THEN
   gsCustomName = "333"
END IF
gsCustomName = tempAbbreviation
glCustomMass = dTempMass
gfCustomUncertainty = dTempUncertainty
UNLOAD frmCustom
END SUB

SUB Form_Load ()
DIM sMsg AS STRING
DIM nPrintX

IF gsCustomName = "333" THEN
   ' No custom name yet defined; display blank
   txtCustom(0).Text = ""
ELSE
   ' Display previous custom name, mass and uncertainty.
   txtCustom(0).Text = gsCustomName
   NumberFormat glCustomMass, gfCustomUncertainty, 39, sMsg, nPrintX
   txtCustom(1).Text = sMsg
END IF

END SUB

SUB txtCustom_GotFocus (Index AS INTEGER)
   DIM sMsg AS STRING
   txtCustom(Index).BackColor = YELLOW
   txtCustom(Index).SelStart = 0
   txtCustom(Index).SelLength = 14
   SELECT CASE Index
      CASE 0
                sMsg = "Enter up to three letters.  If your abbreviation already "
         sMsg = sMsg + "exists, your new mass and uncertainty will replace the "
         sMsg = sMsg + "current values.  (But not until the next time the symbol "
         sMsg = sMsg + "is entered.)"
      CASE 1
         sMsg = "Enter a mass value with uncertainty.  For example:  123.76(3)"
   END SELECT
   lblDirections.Caption = sMsg
END SUB

SUB txtCustom_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
IF KeyAscii = KEY_RETURN THEN
   ' Go to next text field.
   KeyAscii = 0
   txtCustom((Index + 1) MOD 2).SETFOCUS
ELSEIF (KeyAscii > 47 AND KeyAscii < 58) OR KeyAscii = 46 OR KeyAscii = 40 OR KeyAscii = 41 THEN
   ' Numbers 0 - 9, ., (, and ).
   ' If index=0, go to index = 1.
   IF Index = 0 THEN
      txtCustom(1).Text = CHR$(KeyAscii)
      KeyAscii = 0
      txtCustom(1).SETFOCUS
   END IF
ELSEIF (KeyAscii > 64 AND KeyAscii < 91) OR (KeyAscii > 96 AND KeyAscii < 123) THEN
   ' A letter was entered.
   IF Index = 1 THEN
      txtCustom(0).Text = CHR$(KeyAscii)
      KeyAscii = 0
      txtCustom(0).SETFOCUS
   END IF
ELSEIF NOT (KeyAscii = KEY_ESCAPE OR KeyAscii = KEY_BACK OR KeyAscii = KEY_DELETE) THEN
   BEEP
   KeyAscii = 0
END IF

END SUB

' Makes text in box same as stored value.
SUB txtCustom_LostFocus (Index AS INTEGER)
DIM N, nPrintX
DIM sMsg AS STRING

SELECT CASE Index
   CASE 0
      tempAbbreviation = LCASE$(LEFT$(txtCustom(0).Text, 3))
      MID$(tempAbbreviation, 1) = UCASE$(LEFT$(tempAbbreviation, 1))
      txtCustom(0).Text = tempAbbreviation
   CASE 1
      N = bAnalyzeInput(txtCustom(1).Text, dTempMass, dTempUncertainty)
      NumberFormat dTempMass, dTempUncertainty, 39, sMsg, nPrintX
      txtCustom(1).Text = sMsg
END SELECT
txtCustom(Index).BackColor = BRIGHT_CYAN

END SUB

