/*****************************************************/
/*                                                   */
/*      Example program using CD Audio Library.      */
/*                                                   */
/*       Copyright (c) 1996 by Alister Perrott       */
/*                                                   */
/*              al@aperrott.demon.co.uk              */
/*                                                   */
/*****************************************************/

/* Last Edited: 11/5/96  16:29 */

/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "cdaudio.h"

/***************************************************************************/
/* This section contains a very basic CD player program as an example of how
most of the functions work. */



int DisplayStatus();


int main(char *argv, char **argc)
{
int ReturnCode=0;
unsigned char *Qp;
char ic=1;
char track;
char firsttrack;
char lasttrack;
char nexttrack;
char *ChannelPTR;

	
	ReturnCode=Find_CD_Drive();

	if (ReturnCode == No_CD_Drive )
		{
		printf("No CD-ROM drive detected\n");
		return (ReturnCode);
		}
	if (ReturnCode == No_Free_DOS_Mem )
		{
		printf("Insufficient real mode DOS memory\n");
		return (ReturnCode);
		}

	CloseCDtray();
	printf("Reading Disc information");
        
	/* Read the track info... */

	do
		{
		printf(".");
		ReturnCode = InitialiseCD();
		}
	while ( ReturnCode != CD_OK );


	printf("\nCD Initialised\n");

	printf("Controls:\n");
	printf("P - Play, S - Stop/Pause, R - Resume play, E - Eject disc\n");
	printf("F - Forwards, B - Back, T - Time, +/- - increase/decrease volume \n");
	printf("1,2,3,4,5,6,7,8,9 - Start play at specific track\n");
	printf("O - Open, C - Close, L - Lock, U - Unlock\n");
	printf("ESCAPE to Quit\n");

	do
		{
		ic=getch();

		if ( ic == 112 )
			{
			CloseCDtray();
			PlayFromCDtrack( 1 );
			}

		if ( ic > 48 && ic < 58 )
			{
			CloseCDtray();
			PlayFromCDtrack( (ic - 48) );
			}

		if ( ic == 48 )
			{
			CloseCDtray();
			PlayFromCDtrack( 10 );
			}

		if ( ic == 115 )
			{
			StopCDplay();
			}

		if ( ic == 101 || ic == 111 )
			{
			OpenCDtray();
			}

		if ( ic == 99 )
			{
			CloseCDtray();
			}

		if ( ic == 108 )
			{
			LockCDtray();
			}

		if ( ic == 117 )
			{
			UnlockCDtray();
			}

		if ( ic == 114 )
			{
			ResumeCDplay();
			}

		if ( ic == 45 )
			{
			ChannelPTR = GetAudioChannelInfo();

			if (*(ChannelPTR+1)>0)
				{
				*(ChannelPTR+1) = *(ChannelPTR+1) - 1;
				}
			if (*(ChannelPTR+3)>0)
				{
				*(ChannelPTR+3) = *(ChannelPTR+3) - 1;
				}
			if (*(ChannelPTR+5)>0)
				{
				*(ChannelPTR+5) = *(ChannelPTR+5) - 1;
				}
			if (*(ChannelPTR+7)>0)
				{
				*(ChannelPTR+7) = *(ChannelPTR+7) - 1;
				}

			printf("Current volume: %03d\n",*(ChannelPTR+1));

			SetAudioChannelInfo( ChannelPTR );
			}

		if ( ic == 61 )
			{
			ChannelPTR = GetAudioChannelInfo();

			if (*(ChannelPTR+1)<255)
				{
				*(ChannelPTR+1) = *(ChannelPTR+1) + 1;
				}
			if (*(ChannelPTR+3)<255)
				{
				*(ChannelPTR+3) = *(ChannelPTR+3) + 1;
				}
			if (*(ChannelPTR+5)<255)
				{
				*(ChannelPTR+5) = *(ChannelPTR+5) + 1;
				}
			if (*(ChannelPTR+7)<255)
				{
				*(ChannelPTR+7) = *(ChannelPTR+7) + 1;
				}

			printf("Current volume: %03d\n",*(ChannelPTR+1));

			SetAudioChannelInfo( ChannelPTR );
			}

		if ( ic == 102 )
			{
			lasttrack = GetLastAudioTrackNumber();
			firsttrack = GetFirstAudioTrackNumber();

			Qp = GetQ_ChannelInfo();
			track = *Qp;
			nexttrack = track + 1;

			if ( nexttrack > lasttrack )
				{
				nexttrack = firsttrack;
				}

			PlayFromCDtrack( nexttrack );

			}

		if ( ic == 98 )
			{
			lasttrack = GetLastAudioTrackNumber();
			firsttrack = GetFirstAudioTrackNumber();

			Qp = GetQ_ChannelInfo();
			track = *Qp;
			nexttrack = track - 1;

			if ( track == firsttrack )
				{
				nexttrack = lasttrack;
				}

			PlayFromCDtrack( nexttrack );

			}

		DisplayStatus();
		}
	while ( ic != 27 );



//      PlayCDtrack( 6 );


	ReturnCode = GetCDplayStatus();

	if (ReturnCode == CD_Playing )
		{
		printf("Playing\n");
		}
	if (ReturnCode == CD_Paused )
		{
		printf("Paused\n");
		}
	if (ReturnCode == CD_Stopped )
		{
		printf("Stopped\n");
		}

	return (ReturnCode);
}

/***************************************************************************/

int DisplayStatus()
{
int ReturnCode=0;
unsigned char *Qp;
unsigned char track=1;
unsigned char min;
unsigned char sec;
unsigned char frame;

        ReturnCode = GetCDplayStatus();

	if (ReturnCode == CD_Playing )
		{
		printf("Playing\n");
		}
	if (ReturnCode == CD_Paused )
		{
		printf("Paused\n");
		}
	if (ReturnCode == CD_Stopped )
		{
		printf("Stopped\n");
		}
	else
		{

		Qp = GetQ_ChannelInfo();
		track = *Qp;
		min = *(Qp+2);
		sec = *(Qp+3);
		frame = *(Qp+4);
		printf("Current track: %03d",track);
		printf(" - Time: %03d",min);
		printf(":%03d",sec);
		printf(".%03d\n",frame);
		}

	return(ReturnCode);
}

/***************************************************************************/

