/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void T(
pmatrix mA,
pmatrix mX,
pmatrix mTA)
{
 multmF(mA,mX,mTA);
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB(int n, int p, int q)
{
fraction mns = {-1,1};

double pbA    [MXR][MXC*TWOCOL];matrix mA    ={MXR,MXC*TWOCOL,&pbA    [0][0]};
double pbmnsA [MXR][MXC*TWOCOL];matrix mmnsA ={MXR,MXC*TWOCOL,&pbmnsA [0][0]};
double pbX    [MXR][MXC*TWOCOL];matrix mX    ={MXR,MXC*TWOCOL,&pbX    [0][0]};
double pbTA   [MXR][MXC*TWOCOL];matrix mTA   ={MXR,MXC*TWOCOL,&pbTA   [0][0]};
double pbTmnsA[MXR][MXC*TWOCOL];matrix mTmnsA={MXR,MXC*TWOCOL,&pbTmnsA[0][0]};

                     mA.rows=n;                   mA.cols=p*TWOCOL;
                  mmnsA.rows=n;                mmnsA.cols=p*TWOCOL;
                     mX.rows=p;                   mX.cols=q*TWOCOL;
                    mTA.rows=n;                  mTA.cols=q*TWOCOL;
                 mTmnsA.rows=n;               mTmnsA.cols=q*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
    rndmF(&mX,9,1);
    rndmF(&mA,9,1);
  smultmF(mns,&mA,&mmnsA);

  clrscrn();
  printf(" a)         T : M%dx%d -> M%dx%d, \n",n,p,n,q);
  printf("     T(A) = AX (where X%dx%d is a fixed matrix)\n",p,q);
  printf("              Is T(-A) = -T(A) ?\n");
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                       X :");
  printmI3(&mX);
  T(&mmnsA,&mX,&mTmnsA);
  printf("                                                   T(-A) :");
  printmI3(&mTmnsA);
  T(&mA,&mX,&mTA);
  printf("                                                   T(A)  :");
  printmI3(&mTA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("              T : Mnxp -> Mnxq,                 \n\n");
  printf("   T(A) = AX (where Xpxq is a fixed matrix)     \n\n");
  printf("             Is T(-A) = -T(A) ?                 \n\n");
  printf("             ****************                     \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
int    q;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1])&& atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 3){n=3;}
  p = atoi(argv[2]); if( p > 3){p=3;}
  q = atoi(argv[3]); if( q > 3){q=3;}}
else
 {    n=rndpI(3);       p=rndpI(3);     q=rndpI(3);}
   if(n<1){n=1;}     if(p<1){p=1;}     if(q<1){q=1;}


  AB(n,p,q);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}


