/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void T(
pmatrix mx,
pmatrix mTx)
{
fraction f_2 = {2,1};
fraction f_4 = {4,1};
fraction x1;
fraction x2;
fraction x3;
fraction Tx1;
fraction Tx2;

  x1.numer =  *(mx->pblock+0 *mx->cols+0*TWOCOL    );
  x1.denom =  *(mx->pblock+0 *mx->cols+0*TWOCOL + 1);
  x2.numer =  *(mx->pblock+0 *mx->cols+1*TWOCOL    );
  x2.denom =  *(mx->pblock+0 *mx->cols+1*TWOCOL + 1);

  x3.numer =  *(mx->pblock+0 *mx->cols+2*TWOCOL    );
  x3.denom =  *(mx->pblock+0 *mx->cols+2*TWOCOL + 1);
                                                 /* 2 x1 - x2 + x3 */
                                       Tx1 = addF(subF(multF(f_2,x1),x2),x3);
  *(mTx->pblock+0 *mTx->cols+0*TWOCOL    ) = Tx1.numer;
  *(mTx->pblock+0 *mTx->cols+0*TWOCOL + 1) = Tx1.denom;
                                                 /* x2-4 x3       */
                                       Tx2 = subF(x2,multF(f_4,x3));
  *(mTx->pblock+0 *mTx->cols+1*TWOCOL    ) = Tx2.numer;
  *(mTx->pblock+0 *mTx->cols+1*TWOCOL + 1) = Tx2.denom;
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB()
{
fraction c;

double pbu     [MXR][MXC*TWOCOL];matrix mu      ={MXR,MXC*TWOCOL,&pbu     [0][0]};
double pbv     [MXR][MXC*TWOCOL];matrix mv      ={MXR,MXC*TWOCOL,&pbv     [0][0]};
double pbcu    [MXR][MXC*TWOCOL];matrix mcu     ={MXR,MXC*TWOCOL,&pbcu    [0][0]};
double puplsv  [MXR][MXC*TWOCOL];matrix muplsv  ={MXR,MXC*TWOCOL,&puplsv  [0][0]};

double pbTu    [MXR][MXC*TWOCOL];matrix mTu     ={MXR,MXC*TWOCOL,&pbTu    [0][0]};
double pbTv    [MXR][MXC*TWOCOL];matrix mTv     ={MXR,MXC*TWOCOL,&pbTv    [0][0]};
double pbTcu   [MXR][MXC*TWOCOL];matrix mTcu    ={MXR,MXC*TWOCOL,&pbTcu   [0][0]};
double pbcTu   [MXR][MXC*TWOCOL];matrix mcTu    ={MXR,MXC*TWOCOL,&pbcTu   [0][0]};
double pTuplsv [MXR][MXC*TWOCOL];matrix mTuplsv ={MXR,MXC*TWOCOL,&pTuplsv [0][0]};
double pTuplsTv[MXR][MXC*TWOCOL];matrix mTuplsTv={MXR,MXC*TWOCOL,&pTuplsTv[0][0]};

                     mu.rows=1;                   mu.cols=3*TWOCOL;
                     mv.rows=1;                   mv.cols=3*TWOCOL;
                    mcu.rows=1;                 mcu.cols=3*TWOCOL;
                 muplsv.rows=1;               muplsv.cols=3*TWOCOL;

                    mTu.rows=1;                  mTu.cols=2*TWOCOL;
                    mTv.rows=1;                  mTv.cols=2*TWOCOL;
                   mTcu.rows=1;                 mTcu.cols=2*TWOCOL;
                   mcTu.rows=1;                 mcTu.cols=2*TWOCOL;
                mTuplsv.rows=1;              mTuplsv.cols=2*TWOCOL;
               mTuplsTv.rows=1;             mTuplsTv.cols=2*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
      rndmF(&mu,9,1);
      rndmF(&mv,9,1);
  c = rndF (    9,1);

  clrscrn();

  printf(" a) T : R**3 -> R**2, ");
  printf("    T(x1,x2,x3) =(2x1 - x2 + x3, x2 - 4x3)\n\n");
  printf("             Is T(u) + T(v) = T(u + v) ?\n\n");
  printf("                                                       u :");
  printmI3(&mu);
  printf("                                                       v :");
  printmI3(&mv);
  printf("\n\n");

  printf("                                                    T(u) :");
     T(&mu,&mTu);
  printmI3(&mTu);
  printf("                                                    T(v) :");
     T(&mv,&mTv);
  printmI3(&mTv);
  printf("                                             T(u) + T(v) :");
   addmF(&mTu,&mTv,&mTuplsTv);
  printmI3(       &mTuplsTv);
  printf("\n\n");

  printf("                                                   u + v :");
  addmF(&mu,&mv,&muplsv);
  printmI3(     &muplsv);
     T(&muplsv,&mTuplsv);
   printf("                                                  T(u+v):");
 printmI3(&mTuplsv);
  getchar();

  clrscrn();
  printf("  b)  T : R**3 -> R**2, ");
  printf("      T(x1,x2,x3) =(2x1 - x2 + x3, x2 - 4x3)\n\n");
  printf("             Is T(cu) =  cT(u) ? \n\n");
  printf("                                                       u :");
  printmI3(&mu);
  printf("                                                c = %4.0f :",c.numer);
  printf("\n\n");

  smultmF(c,&mu,&mcu);
  printf("                                                      cu :");
  printmI3(&mcu);
  T(&mcu,&mTcu);
  printf("                                                   T(cu) :");
  printmI3(&mTcu);
  printf("\n\n");

  printf("                                                    T(u) :");
  T(&mu,&mTu);
  printmI3(&mTu);
  printf("                                                   cT(u) :");
  smultmF(c,&mTu,&mcTu);
  printmI3(&mcTu);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("               T : R**3 -> R**2,                 \n\n");
  printf("     T(x1,x2,x3) = (2x1 - x2 + x3, x2 - 4x3)    \n\n");
  printf("          Is T a linear transformation?         \n\n");
  printf("               ****************                   \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












