/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
fraction det;

double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbb     [MXR][MXC*TWOCOL];matrix mb      ={MXR,MXC*TWOCOL,&pbb     [0][0]};
double pbx     [MXR][MXC*TWOCOL];matrix mx      ={MXR,MXC*TWOCOL,&pbx     [0][0]};
double pbAx    [MXR][MXC*TWOCOL];matrix mAx     ={MXR,MXC*TWOCOL,&pbAx    [0][0]};
double pbprojwb[MXR][MXC*TWOCOL];matrix mprojwb={MXR,MXC*TWOCOL,&pbprojwb [0][0]};
double pTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pTrpsA  [0][0]};
double pTrpsA_A[MXR][MXC*TWOCOL];matrix mTrpsA_A={MXR,MXC*TWOCOL,&pTrpsA_A[0][0]};


                     mA.rows= n;             mA.cols=(n-1)*TWOCOL;
                     mb.rows= n;             mb.cols=      TWOCOL;
                     mx.rows=(n-1);          mx.cols=      TWOCOL;
                    mAx.rows= n;            mAx.cols=      TWOCOL;
                mprojwb.rows= n;        mprojwb.cols=      TWOCOL;
                 mTrpsA.rows=(n-1);      mTrpsA.cols= n   *TWOCOL;
               mTrpsA_A.rows=(n-1);    mTrpsA_A.cols=(n-1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
         rndmF(&mA,3,1);
   transposemF(&mA,&mTrpsA);
        multmF(    &mTrpsA,&mA,&mTrpsA_A);

          det = detF(&mTrpsA_A);
  }while(!det.numer);

  rndmF(&mb,3,2);

  clrscrn();
  printf(" Find the orthogonal projection of b on the column space of A \n\n");
  printf("                                                            A :");
  printmF(&mA);
  printf("                                                            b :");
  printmF(&mb);
  getchar();

  clrscrn();
  printf("\n   The least squares solution of the linear system Ax = b is :\n");
  leastsqrs(&mA,&mb,&mx);
  printf("                                                           x :");
  printmF(          &mx);
  getchar();

  clrscrn();
  printf("The orthogonal projection of b on the column space of A is Ax :\n\n");
  printf("                                                           A  :");
  printmF(&mA);
  printf("                                                            x :");
  printmF(&mx);
  printf("                                                           Ax :");
  multmF(&mA,&mx,&mAx);
  printmF(       &mAx);
  getchar();

  printf("       Directly with the projwb(&mA,&mb,&mprojwb) functions :\n");
  orthprojwb(&mA,&mb,&mprojwb);
  printmF(       &mprojwb);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n            Ax = b                          \n\n");
  printf("          A is an mxn matrix,                     \n");
  printf("  with linearly independent column vectors,     \n\n");
  printf("   Find the orthogonal projection of b            \n");
  printf("       on the column space of A                   \n");
  printf("       ************************                   \n");
  printf("\n\n\n\n\n\n\n                                      ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 3){n=3;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

