;Data compression rountines v1.01
; NEW v1.01 - massive optimization/changes

include src\qlib.inc
include compress.inc

include lz.inc

include lzc.asm       ;LZ Compression algo
include lzd.asm

;include lzwc.asm      ;LZW Compression algo
;include lzwd.asm

.data?
  lvl dd ?

.code

CompressSetLevel proc,_lvl:dword
  ;Currently no compression algos have different levels
  mov eax,_lvl
  mov lvl,eax
  xor eax,eax
  ret
CompressSetLevel endp

CompressBuffer proc,dest:dword,_dlen:dword,src:dword,_slen:dword,_flg:dword,typ:dword
  ;flgs =
  ; COMP_NOSTORE - Force compress (do not store, unless dest too small)
  ; COMP_BLOCKSTART - start multi-block compression
  ; COMP_BLOCKCONT - continue next block in multi-block compression
  ; COMP_BLOCKEND - finish last block in multi-block compression
  ;type =
  ; COMP_STORE - Store compression (just copy)
  ; COMP_LZ - LZ compression v1.01

  mov eax,_flg
  .if eax & (COMP_BLOCKSTART or COMP_BLOCKCONT or COMP_BLOCKEND)
    cmp typ,COMP_STORE
    je @f
    ;force no store to prevent storage changing between blocks
    or eax,COMP_NOSTORE
  .endif
@@:
  mov flg,eax

restart:
  mov eax,_dlen      ;make global accessable
  mov dlen,eax
  mov eax,_slen
  mov slen,eax

  cmp typ,COMP_STORE
  jne _lz

  callp _store,dest,src
  mov eax,slen   ;may be changed for first buffer (if BLOCK mode used)
  ret

_lz:
  cmp typ,COMP_LZ
  jne _lzw
  callp _lz_comp,dest,src
  test flg,COMP_NOSTORE
  jnz @f
  cmp eax,_slen
  ja do_store
@@:
  cmp eax,ERROR
  jne done
  cmp flg,COMP_NOSTORE
  je bad
do_store:
  mov typ,COMP_STORE
  jmp restart
done:
  ret

_lzw:

comment ~
  cmp typ,COMP_LZW
  jne bad
  callp _lzw_comp,dest,src
  test flg,COMP_NOSTORE
  jnz @f
  cmp eax,_slen
  ja do_store
@@:
  cmp eax,ERROR
  jne done
  cmp flg,COMP_NOSTORE
  je bad
  jmp do_store~

bad:
  mov eax,ERROR
  ret
CompressBuffer endp

DecompressBuffer proc uses ebx ecx,dest:dword,_dlen:dword,src:dword
  mov eax,_dlen      ;make global accessable
  mov dlen,eax
  mov eax,src
  mov ecx,[eax+1]  ;size of source
  cmp ecx,dlen
  ja bad
  mov bl,[eax]   ;get type
  add eax,5      ;skip over compression type/source size!
  mov src,eax    ;replace source

  cmp bl,COMP_STORE
  jne _lz

  callp _unstore,dest,src,ecx
  jmp done

_lz:
  cmp bl,COMP_LZ
  jne _lzw
  callp _lz_decomp,dest,src
  jmp done

_lzw:

comment ~
  cmp bl,COMP_LZ
  jne bad
  callp _lzw_decomp,dest,src
  jmp done~

bad:
  mov eax,ERROR
  ret

done:
  cmp eax,ecx
  jne bad
  ret
DecompressBuffer endp

CompressBufferSize proc,buf:dword
  mov eax,buf
  mov eax,[eax+1]
  ret
CompressBufferSize endp

_store proc,dest:dword,src:dword
  pushad
  mov edi,dest
  mov esi,src
  mov eax,flg
  .if ! ((eax & COMP_BLOCKCONT) || (eax & COMP_BLOCKEND))
    mov al,COMP_STORE
    stosb    ;store compression type
    mov eax,slen
    stosd    ;store uncompressed size
    add slen,5
    mov ecx,eax
  .else
    mov ecx,slen
  .endif
  copyECX
  popad
  ret
_store endp

_unstore proc,dest:dword,src:dword,siz:dword
  pushad
  mov ecx,siz
  mov edi,dest
  mov esi,src
  copyECX
  popad
  ret
_unstore endp

_endseg

end
