/*  stdarg.h

    Definitions for accessing parameters in functions that accept
    a variable number of arguments.

*/

#ifndef __STDARG_H__
#define __STDARG_H__

#ifdef __VARARGS_H__
#error "Can't include both STDARG.H and VARARGS.H"
#endif

typedef void *va_list;

#define __size__(x) ((sizeof(x)+sizeof(int)-1) & ~(sizeof(int)-1))

#define va_start(ap, parmN) \
  ((void)((ap) = (va_list)((byte *)(&parmN)+__size__(parmN))))
// NOTE : You can not use char or unsigned char or float or long double with
//        va_arg() since it will not work!
#define va_arg(ap, type) \
  (*( type *)(((*(byte **)&(ap))+=__size__(type)) \
  -(__size__(type)) ))
#define va_end(ap) ((void)0)

#endif  /* __STDARG_H__ */
