/*
File:
                prfifl.h        -Header file
		Defines PRF types and structures for use in C programs.
                Should be #included into any C program using PRF routines.
                File 'prfifl.obj' should be linked into target application
                object code.
							
*/

/*
   PRF_IsInstalled():
   Purpose: 	check that an PRF is installed on the system using the specified
	    	software interrupt.  If the PRF is present, then the interface
		library is initialised to use the specified interrupt,
		otherwise an error is returned.
   Parameter:   a byte value which specifies the software interrupt to check.
   Return Val:	zero if a PRF is not present on the specified interrupt.
		non-zero if a PRF is present on the specified interrupt.
*/	

int		far PRF_IsInstalled( unsigned char );
	     
/*
   PRF_Fn():
   Purpose: 	pass control and parameters (variable number) to PRF.
   Parameters:	variable, first parameter is always function code.
   Return Val:  function specific, always unsigned long. 
*/

/* Function Codes: */
#define PRF_START 0
#define PRF_STOP  2

unsigned long far PRF_Fn( int, ...);
/*
 * Utility routines that start and stop the profiling and
 * dump the profiling data to a file....
 */
/* extern int PRFstart(),PRFstop(); */
