/*
**  simple16.c (9/11/98)
**
**  Protected Mode SIMPLE
**
**  NOTES:
**    1) Borland: Compile with Borland 4.0/4.5 [not 5.0] & DOS Power Pack.
**    2) Microsoft: Must use Pharlaps' 16-bit extender.
**    3) Must be executed from DOS command line (boot to DOS in Win95).
**    4) If using PharLaps' RUN286, use "RUN286 -NOVCPI SIMPLE16 port baudrate"
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "windows.h"
#include "pcl4c.h"
#include "dpmi.h"
#include "dpmi16if.h"

#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif

int StdUartAdr[4] = {0x3f8,0x2f8,0x3e8,0x2e8};
int StdUartIRQ[4] = {4,3,4,3};

/*** Global Variables ***/

int Port = COM1;          /* Port COM1 */
int BaudCode;             /* baud rate code ( index into BaudRate[] ) */
char *BaudRate[10] =  {"0","300","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};
char *UartString[4] = {"8250/16450", "16550", "16650", "16750"};

long hRxMem;
long hTxMem;
int  RxSelector = 0;
int  TxSelector = 0;

/*** private functions */

static int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {printf("ERROR %d:",Code);
      SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
} /* end ErrorCheck */

static int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}

static int AllocMem(int Size)
{long hMem;
 hMem = (long) DPMI_AllocDosMemory( Size / 16 );
 if(hMem)
   {/* get selector */
    return HIWORD(hMem);
   }
 return 0;
}

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, rc;
 if(argc!=3)
   {printf("Usage: SIMPLE16 <port> <baud>\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
     {printf("Port must be COM1 to COM20\n");
      exit(1);
     }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
     {printf("Cannot recognize baud rate = %s\n",argv[2]);
      exit(1);
     }

 printf("Simple16\n");

 /* setup 256 byte RX buffer */
 RxSelector = AllocMem(256);
 if(RxSelector==0)
   {printf("DPMI_AllocDosMemory failed\n");
    exit(1);
   }
 SioRxBuf(Port,RxSelector,Size256);
 printf("RX buffer allocated: %lx\n",MAKELONG(0,RxSelector));

 /* setup 256 byte TX buffer */
 TxSelector = AllocMem(256);
 if(TxSelector==0)
   {printf("DPMI_AllocDosMemory failed\n");
    exit(1);
   }

 SioTxBuf(Port,TxSelector,Size256);
 printf("TX buffer allocated: %lx\n",MAKELONG(0,TxSelector));

#if 0
 printf("<%x>", SioDebug(0) );
#endif

 /* reset the port */

 printf("Resetting port COM%d\n",1+Port);
 ErrorCheck( SioReset(Port,BaudCode) );

#if 1
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
#endif

#if 0
 /* set RTS/CTS flow control */
 ErrorCheck( SioFlow(Port,18) );
 puts("Flow control on");
#endif

 /* Set FIFO level */
 i = SioFIFO(Port,LEVEL_4TH);
 printf("[%s]\n", UartString[i]);

 printf("\nEnter terminal loop ( Type ^Z to exit )\n");
 /* enter terminal loop */
 while(TRUE)
     {
#if 0
      if(SioBrkKey())
        {/* restore COM port status & exit */
         printf("BREAK\n");
         SioDone(Port);
         exit(2);
        }
#endif

      /* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==0x1a)
              {/* restore COM port status & exit */
               SioDone(Port);
               if(RxSelector) DPMI_FreeDosMemory(RxSelector);
               if(TxSelector) DPMI_FreeDosMemory(TxSelector);
               puts("DONE.");
               exit(1);
              }
           else SioPutc(Port,(char)i);
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) putch((char)i);
     } /* end while */
} /* end main */

