/* yd_dot.h                     freeware                   xhunga@tiscali.fr  */


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectab.zip vectak.zip vectal.zip vectan.zip                      */
/* -------------------------------------------------------------------------- */
fraction innerprod(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct;

  if (mu->rows == 1                 &&
      mu->cols == mv->rows * TWOCOL &&
      mv->cols == TWOCOL
     )
     {
      InnerProduct = innerprod_uDotv_uv(mu,mv);
     }
    else if
     (mu->rows == 1        &&
      mv->rows == 1        &&
      mu->cols == mv->cols
     )
     {
      InnerProduct = innerprod_uDotv_uvT(mu,mv);
     }
    else if
     (mu->rows == mv->rows &&
      mu->cols == mv->cols &&
      mu->cols == TWOCOL
     )
     {
      InnerProduct = innerprod_uDotv_vTu(mu,mv);
     }
    else if
     (mu->rows * TWOCOL == mv->cols &&
      mu->cols          == TWOCOL   &&
      mv->rows          == 1
     )
     {
      InnerProduct = innerprod_uDotv_vu(mu,mv);
     }
     else
     {
      printf(" innerprod() error.\n\n");

      printf("\nPress Return to continue\n");
      getchar();
      exit(1);
     }


  return(InnerProduct);
}



/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectab.zip vectal.zip                                            */
/* -------------------------------------------------------------------------- */
fraction normP2(
pmatrix mu
)
{
fraction NormP2;

         NormP2 = innerprod(mu,mu);

  return(NormP2);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectab.zip                                                       */
/* -------------------------------------------------------------------------- */
fraction distanceP2(
pmatrix mu,
pmatrix mv
)
{
fraction DistanceP2;

double pu_mns_v [MXR][MXC*TWOCOL];
matrix mu_mns_v={MXR, MXC*TWOCOL,&pu_mns_v[0][0]};

       mu_mns_v.rows = mu->rows;
       mu_mns_v.cols = mu->cols;

      submF(mu,mv,&mu_mns_v);

  DistanceP2 = normP2(&mu_mns_v);

  return(DistanceP2);
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectak.zip                                                       */
/* -------------------------------------------------------------------------- */
void projwn(
pmatrix mu,
pmatrix mv,
pmatrix mvn
)
{
fraction InnerProduv;
fraction     NormvP2;
fraction   InvNormP2;
fraction InnerProduv_InvNormP2;
/*-------------------------------- PROGRAM ---------------------------------- */
             InnerProduv = innerprod(mu,mv);
                 NormvP2 =    normP2(   mv);
               InvNormP2 =      invF(NormvP2);

   InnerProduv_InvNormP2 =  multF(InnerProduv,InvNormP2);

        smultmF(InnerProduv_InvNormP2,mv,mvn);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectak.zip                                                       */
/* -------------------------------------------------------------------------- */
void printmX(
pmatrix mX,
char c
)
{
fraction f;
int i;
int j;

double pbvT[MXR][MXC*TWOCOL];matrix mvT ={MXR,MXC*TWOCOL,&pbvT[0][0]};
double pvnT[MXR][MXC*TWOCOL];matrix mvnT={MXR,MXC*TWOCOL,&pvnT[0][0]};

   mvT.rows = 1;          mvT.cols = mX->cols;
  mvnT.rows = 1;         mvnT.cols = mX->cols;

for(i = 0; i < ((mX->cols/2) - 1) ; i++)
   {
   for(j = 1; j < (mX->cols/2) ; j++)
     {
      copyrowF(mX,i,&mvT, 0);
      copyrowF(mX,j,&mvnT,0);

      f = innerprod(&mvT,&mvnT);
      if(!(i==j || i>j))
        {
         printf("  %c%d.%c%d = %4.0lf/%.0lf;",
                   c,i+1,c,j+1,f.numer,f.denom);
        }
     }
   printf("\n");
   }
}



/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectal.zip                                                       */
/* -------------------------------------------------------------------------- */
void leastsqrs(
pmatrix mA,
pmatrix mb,
pmatrix mx
)
{
int  n = mA->rows;

double pbAx    [MXR][MXC*TWOCOL];matrix mAx     ={MXR,MXC*TWOCOL,&pbAx    [0][0]};
double pTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pTrpsA  [0][0]};
double pTrpsA_A[MXR][MXC*TWOCOL];matrix mTrpsA_A={MXR,MXC*TWOCOL,&pTrpsA_A[0][0]};
double pTrpsA_b[MXR][MXC*TWOCOL];matrix mTrpsA_b={MXR,MXC*TWOCOL,&pTrpsA_b[0][0]};

double pAssNorSys[MXR][MXC*TWOCOL];
matrix mAssNorSys ={MXR,MXC*TWOCOL,&pAssNorSys [0][0]};

                    mAx.rows= n;            mAx.cols=      TWOCOL;
                 mTrpsA.rows=(n-1);      mTrpsA.cols= n   *TWOCOL;
               mTrpsA_A.rows=(n-1);    mTrpsA_A.cols=(n-1)*TWOCOL;
               mTrpsA_b.rows=(n-1);    mTrpsA_b.cols=      TWOCOL;
             mAssNorSys.rows=(n-1);  mAssNorSys.cols= n   *TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  transposemF( mA,&mTrpsA);
       multmF(&mTrpsA,mA,&mTrpsA_A);
       multmF(&mTrpsA,mb,&mTrpsA_b);
       copymF(&mTrpsA_A,&mAssNorSys);
     copycolF(&mTrpsA_b,0,&mAssNorSys,n-1);
 gaussjordanF(&mAssNorSys);
     copycolF(&mAssNorSys,n-1,mx,0);
}



/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectal.zip                                                       */
/* -------------------------------------------------------------------------- */
void orthprojwb(
pmatrix mA,
pmatrix mb,
pmatrix mprojwb
)
{
int  n = mA->rows;

double pbx[MXR][MXC*TWOCOL];matrix mx = {MXR,MXC*TWOCOL,&pbx[0][0]};

            mx.rows=(n-1);          mx.cols= TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
       leastsqrs(mA, mb,&mx);
          multmF(mA,&mx, mprojwb);
}
