/* xcelrop.h               freeware                   xhunga@tiscali.fr  */


/* ------------------------------ FUNCTION ------------------------ swaprow() */
/*      swap two rows in a matrix                                             */
/* -------------------------------------------------------------------------- */
void swaprowF(
pmatrix m,
int     row1,
int     row2)
{
  int    j;
  double t;

    for ( j = 0 ; j < m->cols ; j++)
    {
                                t       = *(m->pblock + row1 *m->cols + j);
      *(m->pblock + row1 *m->cols + j ) = *(m->pblock + row2 *m->cols + j);
      *(m->pblock + row2 *m->cols + j ) =       t;
    }
}


/* ------------------------------ FUNCTION ------------------------- mulrow() */
/* returns a copy of the matrix m in which row is multiply by scalaire        */
/* -------------------------------------------------------------------------- */
void mulrowF(
pmatrix m,
int rown,
fraction f
)
{
 int j;

 for( j = 0 ; j < m->cols ; j++,j++)
 {
                 (*(m->pblock + rown *m->cols + j)) = \
       f.numer * (*(m->pblock + rown *m->cols + j )) ;

                 (*(m->pblock + rown *m->cols + j + 1)) = \
       f.denom * (*(m->pblock + rown *m->cols + j + 1)) ;
 }
}



/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void addrowF(
pmatrix  m,
int      row1,
int      row2,
fraction f
)
{
  int j;
  double t;

 for ( j = 0 ; j < m->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
      *(m->pblock + row2 *m->cols + j) =\
                       (
                    (f.numer) * (*(m->pblock + row1 *m->cols + j    ))\
                               * \
                               (*(m->pblock + row2 *m->cols + j + 1))\
                        )
                        + \
                        (
                             (*(m->pblock + row2 *m->cols + j    ))\
                             * \
                     f.denom * (*(m->pblock + row1 *m->cols + j + 1 ))
                         );
/* -------------------------------------------------------------- denominator */
      *(m->pblock + row2 *m->cols + j + 1) = \
              f.denom * (*(m->pblock + row1 *m->cols + j + 1)) * \
                        (*(m->pblock + row2 *m->cols + j + 1));
/* -------------- denominator = 1 if numerator = 0. This is my choice 0 = 0/1 */
                t = *(m->pblock + row2 *m->cols + j);
            if(!t){ *(m->pblock + row2 *m->cols + j + 1) = 1; }
    }
}


/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void addrowautoF(
pmatrix m,
int     row1,
int     row2)
{
     int j;
  double t;
fraction f;

 f.numer = -(*(m->pblock + row2 *m->cols + row1    ));
 f.denom =   *(m->pblock + row2 *m->cols + row1 + 1);

 for ( j = 0 ; j < m->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
      *(m->pblock + row2 *m->cols + j) =\
                       (
                     (f.numer) * *(m->pblock + row1 *m->cols + j    )\
                               * \
                               (*(m->pblock + row2 *m->cols + j + 1))\
                        )
                        + \
                        (
                             *(m->pblock + row2 *m->cols + j    )\
                             * \
                      (f.denom) * (*(m->pblock + row1 *m->cols + j + 1 ))
                         );
/* -------------------------------------------------------------- denominator */
      *(m->pblock + row2 *m->cols + j + 1) = \
              f.denom * (*(m->pblock + row1 *m->cols + j + 1)) * \
                        (*(m->pblock + row2 *m->cols + j + 1));
/* -------------- denominator = 1 if numerator = 0. This is my choice 0 = 0/1 */
                t = *(m->pblock + row2 *m->cols + j);
            if(!t){ *(m->pblock + row2 *m->cols + j + 1) = 1; }
    }
}

