/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
double pbA   [MXR][MXC*TWOCOL];matrix mA   ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbA_b1[MXR][MXC*TWOCOL];matrix mA_b1={MXR,MXC*TWOCOL,&pbA_b1[0][0]};
double pbA_b2[MXR][MXC*TWOCOL];matrix mA_b2={MXR,MXC*TWOCOL,&pbA_b2[0][0]};
double pbA_b3[MXR][MXC*TWOCOL];matrix mA_b3={MXR,MXC*TWOCOL,&pbA_b3[0][0]};
double pbA_b4[MXR][MXC*TWOCOL];matrix mA_b4={MXR,MXC*TWOCOL,&pbA_b4[0][0]};
double pbA_bn[MXR][MXC*TWOCOL];matrix mA_bn={MXR,MXC*TWOCOL,&pbA_bn[0][0]};
double pbb1  [MXR][    TWOCOL];matrix mb1  ={MXR,    TWOCOL,&pbb1  [0][0]};
double pbb2  [MXR][    TWOCOL];matrix mb2  ={MXR,    TWOCOL,&pbb2  [0][0]};
double pbb3  [MXR][    TWOCOL];matrix mb3  ={MXR,    TWOCOL,&pbb3  [0][0]};
double pbb4  [MXR][    TWOCOL];matrix mb4  ={MXR,    TWOCOL,&pbb4  [0][0]};

                     mA.rows=n;                   mA.cols= n   *TWOCOL;
                  mA_b1.rows=n;                mA_b1.cols=(n+1)*TWOCOL;
                  mA_b2.rows=n;                mA_b2.cols=(n+1)*TWOCOL;
                  mA_b3.rows=n;                mA_b3.cols=(n+1)*TWOCOL;
                  mA_b4.rows=n;                mA_b4.cols=(n+1)*TWOCOL;
                  mA_bn.rows=n;                mA_bn.cols=(n+4)*TWOCOL;
                    mb1.rows=n;                  mb1.cols=      TWOCOL;
                    mb2.rows=n;                  mb2.cols=      TWOCOL;
                    mb3.rows=n;                  mb3.cols=      TWOCOL;
                    mb4.rows=n;                  mb4.cols=      TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 10;}

rndmF(&mA, x,2);rndmF(&mb1,x,2);rndmF(&mb2,x,2);rndmF(&mb3,x,2);rndmF(&mb4,x,2);

  copymF(&mA, &mA_b1 );  copycolF(&mb1,0,&mA_b1,n  );
  copymF(&mA, &mA_b2 );  copycolF(&mb2,0,&mA_b2,n  );
  copymF(&mA, &mA_b3 );  copycolF(&mb3,0,&mA_b3,n  );
  copymF(&mA, &mA_b4 );  copycolF(&mb4,0,&mA_b4,n  );
  copymF(&mA, &mA_bn );  copycolF(&mb1,0,&mA_bn,n  );
                         copycolF(&mb2,0,&mA_bn,n+1);
                         copycolF(&mb3,0,&mA_bn,n+2);
                         copycolF(&mb4,0,&mA_bn,n+3);
  clrscrn();
  printf("\n Linear systems with a common coefficient matrix :");
  printf(" Ax = A|b1|b2|b3|b4 \n");
  printf("\n                                              A  :\n");
  printmF3(&mA);
  printf("\n                                              b1 :\n");
  printmF3(&mb1);
  getchar();

  clrscrn();
  printf("\n                                              b2 :\n");
  printmF3(&mb2);
  printf("\n                                              b3 :\n");
  printmF3(&mb3);
  printf("\n                                              b4 :\n");
  printmF3(&mb4);
  getchar();

  clrscrn();
  printf("\n                                   A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  gaussjordanF(&mA_bn);
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  printf("\n                                            A|b1 :\n");
  printmF3(    &mA_b1);
  printf("\n         Gauss Jordan elimination of matrix A|b1 :\n");
  gaussjordanF(&mA_b1);
  printmF3(    &mA_b1);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  printf("\n                                            A|b2 :\n");
  printmF3(    &mA_b2);
  printf("\n         Gauss Jordan elimination of matrix A|b2 :\n");
  gaussjordanF(&mA_b2);
  printmF3(    &mA_b2);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  printf("\n                                            A|b3 :\n");
  printmF3(    &mA_b3);
  printf("\n         Gauss Jordan elimination of matrix A|b3 :\n");
  gaussjordanF(&mA_b3);
  printmF3(    &mA_b3);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printmF3(    &mA_bn);
  printf("\n                                            A|b4 :\n");
  printmF3(    &mA_b4);
  printf("\n         Gauss Jordan elimination of matrix A|b4 :\n");
  gaussjordanF(&mA_b4);
  printmF3(    &mA_b4);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            GaussJordan : A|b1|b2|b3|b4           ");
  printf("\n            ***************************         \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gausx4f.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"gausx4f.exe 2\" -> mA 2x2       ");
  printf("\n                \"gausx4f.exe 3\" -> mA 3x3       ");
  printf("\n                \"gausx4f.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;} }
else
 {    n=rndpI(4);  }
   if(n<2){n=2;}


  invb(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

