/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int p = n + 1;
int m = n - 1;

double pbA   [n][n*TWOCOL]; matrix mA    ={n,n*TWOCOL,&pbA   [0][0]};
double pbInvA[n][n*TWOCOL]; matrix mInvA ={n,n*TWOCOL,&pbInvA[0][0]};
double pbb   [n][  TWOCOL]; matrix mb    ={n,  TWOCOL,&pbb   [0][0]};
double pbTb  [n][  TWOCOL]; matrix mTb   ={n,  TWOCOL,&pbTb  [0][0]};
double pbA_b [n][p*TWOCOL]; matrix mA_b  ={n,p*TWOCOL,&pbA_b [0][0]};

double pbT1  [m][m*TWOCOL]; matrix mT1   ={m,m*TWOCOL,&pbT1  [0][0]};
double pbT2  [n][n*TWOCOL]; matrix mT2   ={n,n*TWOCOL,&pbT2  [0][0]};




/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 25;}

  randmF(&mA,x,5);
  randmF(&mb,x,5);

  copymF(  &mA,  &mA_b  );  copycolF(&mb,0,&mA_b,n);

  clrscrn();
  printf("\n Solving linear systems by matrix inversion : Ax = b \n");
  printf("\n A :\n");
  printmF(&mA);
  printf("\n b :\n");
  printmF(&mb);
  getchar();

  clrscrn();
  printf("\n                                 Inv(A) :\n");
  inverseF(&mA,&mT1,&mT2,&mInvA);
  printmF (              &mInvA);
  printf("\n                                      b :\n");
  printmF(&mb);
  printf("\n               Ax = b  =>  x = Inv(A)*b :\n");
  multmF(&mInvA,&mb,&mTb);
  printmF(          &mTb);
  getchar();

  clrscrn();
  printf("\n                           x = Inv(A)*b :\n");
  printmF(&mTb);
  printf("\n                                    A|b :\n");
  printmF(&mA_b);
  gaussjordanF(&mA_b);
  printf("\n         Verify with GaussJordan on A|b :\n");
  printmF(&mA_b);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            Ax = b => x = Inv(A)*b                ");
  printf("\n            **********************              \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"invx1f.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invx1f.exe 2\" -> mA 2x2        ");
  printf("\n                \"invx1f.exe 3\" -> mA 3x3        ");
  printf("\n                \"invx1f.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

