/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
AplsB_BplsA(int n)
{
fraction two;

double pbA       [n][n*TWOCOL];matrix mA        ={n,n*TWOCOL,&pbA       [0][0]};
double pbB       [n][n*TWOCOL];matrix mB        ={n,n*TWOCOL,&pbB       [0][0]};
double pbAplsB   [n][n*TWOCOL];matrix mAplsB    ={n,n*TWOCOL,&pbAplsB   [0][0]};
double pbAplsB_p2[n][n*TWOCOL];matrix mAplsB_p2 ={n,n*TWOCOL,&pbAplsB_p2[0][0]};
double pbA_p2    [n][n*TWOCOL];matrix mA_p2     ={n,n*TWOCOL,&pbA_p2    [0][0]};
double pbB_p2    [n][n*TWOCOL];matrix mB_p2     ={n,n*TWOCOL,&pbB_p2    [0][0]};
double pbAB      [n][n*TWOCOL];matrix mAB       ={n,n*TWOCOL,&pbAB      [0][0]};
double pb2AB     [n][n*TWOCOL];matrix m2AB      ={n,n*TWOCOL,&pb2AB     [0][0]};

double pbT1      [n][n*TWOCOL];matrix mT1       ={n,n*TWOCOL,&pbT1      [0][0]};
double pbT2      [n][n*TWOCOL];matrix mT2       ={n,n*TWOCOL,&pbT2      [0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */

  two.numer = 2;
  two.denom = 1;

  randmF(&mA,9,9);
  randmF(&mB,9,9);

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                     A+B :\n");
  addmF(&mA, &mB,&mAplsB);
  printmF(       &mAplsB);
  getchar();

  clrscrn();
  printf("                                                 A+B     :\n");
  printmF(       &mAplsB);
  printf("                                                (A+B)**2 :\n");
  multmF(&mAplsB,&mAplsB,&mAplsB_p2);
  printmF(               &mAplsB_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                    A**2 :\n");
  multmF(&mA,&mA,&mA_p2);
  printmF(       &mA_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                      AB :\n");
  multmF(&mA,&mB,&mAB);
  printmF(       &mAB);
  getchar();

  clrscrn();
  printf("                                                      AB :\n");
  printmF(&mAB);
  printf("                                                     2AB :\n");
  smultmF(two,&mAB,&m2AB);
  printmF(&m2AB);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmF(&mB);
  printf("                                                    B**2 :\n");
  multmF(&mB,&mB,&mB_p2);
  printmF(       &mB_p2);
  getchar();

  clrscrn();
  printf("                                       A**2 + 2AB + B**2 :\n");
  addmF(&mA_p2,&m2AB,&mT1);
  addmF(&mB_p2,&mT1,&mT2);
  printmF(          &mT2);
  printf("\n                                                (A+B)**2 :\n");
  printmF(               &mAplsB_p2);
  printf("\n     (A+B)**2 !=  A**2+ 2AB +B**2.          \n");
  printf("     (A+B)**2  =  A**2+ 2AB +B**2. (Only when A and B commute)\n\n");
  printf("     (A+B)**2  =  A**2+AB+BA+B**2. (See :           idmaf.exe)\n");
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          (A+B)**2 != A**2+ 2AB +B**2            ");
  printf("\n          ***************************          \n");
  printf("\n          (A+B)**2  = A**2+AB+BA+B**2           ");
  printf("\n          ***************************          \n");
  printf("\n The size of mA, mB      : 1x1 ... 4x4.         \n");
  printf("\n     ex : \"idmaf.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"idmaf.exe 2\" -> 2x2                  ");
  printf("\n          \"idmaf.exe 1\" -> 1x1                  ");
  printf("\n          \"idmaf.exe 4\" -> 4x4                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

  srand(time(&t));
  hello();

do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]);

  if( n < 1){n=1;}
  if( n > 4){n=4;}
 }
else
 {
  n = (int) fabs(randF(4)+1);
 }

  AplsB_BplsA(n);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












