/*
 *    File objman.cpp
 *      Demonstrates the Object hierarchy manipulation
 *      and Object mapping/unmapping
 */

#include <stdio.h>

#include "mguipp.h"
#include "mguitest.hpp"

class CaObjManage : public CmCallback {
	CmShell *shell;
	CmForm *form;
	CmForm *sform;
	CmPushButton *delete_pb;
	CmPushButton *reparent_pb;
	CmPushButton *reparent_p_pb;
public:
	CaObjManage();
	void mapForm(void) { form->map(); };
	void unmapForm(void) { form->unmap(); };
	void addChildSForm(void);
	void addChildShell(void);
	void reparentChild(void);
	void reparentParent(void);
	void deletePB(void) { delete delete_pb;};
	void closeDialog(void) { delete shell; delete this; };
};

/*****************************************************
 *	This function creates a LABEL Object as child
 *	of the form pointed to by the callback application data.
 *****************************************************/
void CaObjManage::addChildSForm(void)
{
    char str[32];
    static int nc;

    sprintf(str, "Label # %d", ++nc);
    new CmLabel(sform, str, FIXED_MEDIUM);
}

/*****************************************************
 *	This function creates a LABEL Object as child
 *	of the form pointed to by the callback application data.
 *****************************************************/
void CaObjManage::addChildShell(void)
{
    char str[32];
    static int nc;

    sprintf(str, "Label # %d", ++nc);
    new CmLabel(shell, str, FIXED_MEDIUM);
}

/*****************************************************
 *	This function causes the Object caller 'p' to
 *	change parent.
 *****************************************************/
void CaObjManage::reparentChild(void)
{
    reparent_pb->reparent(sform, 0);
}

/*****************************************************
 *	This function causes the parent of the Object
 *	caller 'p' to change parent.
 *****************************************************/
void CaObjManage::reparentParent(void)
{
    CmObject *parent = reparent_p_pb->getParent();
    parent->reparent(sform, 0);
}

CaObjManage::CaObjManage(void)
{
    CmForm *form1;
    CmPushButton *pbutton;
    CmSFile *sfile;

    shell = new CmShell("Test Object Management", 0);

    form = new CmColForm(shell);

    sform = new CmScrolledRowForm(form, 180, 150);

    sfile = new CmSFile(form, __FILE__, FIXED_MEDIUM, 10, 54);
    sfile->setColor(darkblue, white);

    form = new CmColForm(shell);

    pbutton = new CmPushButton(form, "&Add Child SForm", TIMES_MEDIUM);
    pbutton->setCallback(this, (VOID_CB)&CaObjManage::addChildSForm);
    pbutton = new CmPushButton(form, "Add Child &Shell", TIMES_MEDIUM);
    pbutton->setCallback(this, (VOID_CB)&CaObjManage::addChildShell);
    delete_pb = new CmPushButton(form, "Delete Me (Alt+D)", TIMES_MEDIUM);
    delete_pb->setCallback(this, (VOID_CB)&CaObjManage::deletePB);
    delete_pb->setAccelerator(A_D);
    reparent_pb = new CmPushButton(form, "Reparent\nMe (Ctrl+R)", TIMES_MEDIUM);
    reparent_pb->setCallback(this, (VOID_CB)&CaObjManage::reparentChild);
    reparent_pb->setAccelerator(C_R);
    reparent_p_pb = new CmPushButton(form, "Reparent\n&My Parent", TIMES_MEDIUM);
    reparent_p_pb->setCallback(this, (VOID_CB)&CaObjManage::reparentParent);

    pbutton = new CmPushButton(form, "Close (C)", TIMES_MEDIUM);
    pbutton->setCallback(this, (VOID_CB)&CaObjManage::closeDialog);
    pbutton->setAccelerator('c');

    form1 = new CmColForm(shell);

    pbutton = new CmPushButton(form1, "Map Button Form", TIMES_MEDIUM);
    pbutton->setCallback(this, (VOID_CB)&CaObjManage::mapForm);
    pbutton = new CmPushButton(form1, "Unmap Button Form", TIMES_MEDIUM);
    pbutton->setCallback(this, (VOID_CB)&CaObjManage::unmapForm);

    shell->realize();
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
ObjManageDemo(void)
{
	new CaObjManage;
}
