/* multm1.c                           freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblockA[5][3*TWOCOL]=
{
   0, 1,   1, 9,  1, 9,
  -9,-5,  -2, 5, -2, 5,
   1, 1,  -7,-8, -2, 5,
   1, 1,  -7,-7, -4, 4,
   1, 2,  -3,-4, -5, 6,
};
matrix mA={5,3*TWOCOL,&pblockA[0][0]};


double pblockB[3][6*TWOCOL]=
{
  0,2,  -1,-1, -1,-1,  1,2,  -1,-5, -8,-2,
  8,2,   8, 9, -3,-2,  2,1,  -5,-4, -9,-1,
  8,1,   8, 9, -2,-2,  3,1,  -7,-3,  0, 1,
};
matrix mB={3,6*TWOCOL,&pblockB[0][0]};


double pblockC[5][6*TWOCOL];
matrix  mC={5,6*TWOCOL,&pblockC[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\nMatrix A\n");
  printmF(&mA);

  printf("\nMatrix B\n");
  printmF(&mB);

  printf("\n\n Matrix A * B\n");

   multmF(&mA, &mB, &mC);
  printmF(          &mC);

 printf("\n Press a key to continue");
 getchar();
}


