/* inverse1.c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{
     int row;
     int col;
fraction f;

double pblockA[4][4*TWOCOL]=
{
0,9, 3,2, 3,9, 4,4,
9,1, 0,4, 3,6, 1,2,
2,3, 8,5, 4,4, 6,9,
3,1, 4,8, 1,2, 9,8
};
matrix mA={4,4*TWOCOL,&pblockA[0][0]};

double pblockT[3][3*TWOCOL];
matrix mT = {  3, 3*TWOCOL,&pblockT[0][0]};

double   pbT2[4][4*TWOCOL];
matrix mT2 = {4, 4*TWOCOL,&pbT2[0][0]};

double   pbInverse[4][4*TWOCOL];
matrix mInverse = {4, 4*TWOCOL,&pbInverse[0][0]};

double   pbB[4][4*TWOCOL];
matrix mB = {4, 4*TWOCOL,&pbB[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n\nMatrix mA follow by mAInverse \n");
  printmF(&mA);

  copymF(&mA,&mB);     /* save mA */

  inverseF(&mB, &mT, &mT2, &mInverse);
   printmF(                &mInverse);

  printf("\n\n mA * mAInverse (0 = 0/1) (1 = 1/1) \n");
  multmF(&mA, &mInverse, &mT2);
  printmF(               &mT2);

 printf("\n Press a key to continue");
 getchar();
}








