/* Copyright 1994-95 by Kai Hofmann
******* TextEngine/--history-- **********************************************
*
*   NAME
*	history -- TextEngine is a module to help with text features
*
*   VERSION
*	$VER: TextEngine 33.071 (28.07.95)
*
*   HISTORY
*	22.02.1994 -	DateString() initiated.
*	23.02.1994 -	Continuation of DateString(), making FormatStr() and
*			copying max from old Datum.mod
*			TimeString() Initiated.
*	24.02.1994 -	Inserting %w command in DateString()
*	04.03.1994 -	Starting translation into C
*	21.01.1995 -	Continuation of translation to C,
*			using new date library functions.
*			Internal procedures: FormatStr(), strdel(),
*			strinspos()
*			TimeString() completly rewritten.
*	04.02.1995 -	TimeString() completly rewritten.
*			Bug fixes in strinspos().
*	05.02.1995 -	DateString() completly rewritten.
*			Eliminating FormatStr(), because there is no need for
*			it, at the moment.
*			TextEngine(), TextEngineJD() initiated.
*	06.02.1995 -	Small changes in the autodocs
*	16.02.1995 -	Fixing bugs found with C++
*			Adding C++ overloading to TextEngine() &
*			TextEngineJD()
*	24.02.1995 -	Rita Reichl corrects my bad English - again.
*	16.03.1995 -	Corrections and changes in the autodocs.
*	22.03.1995 -	Introducing DiffDateString().
*			Changing interface!!!
*	02.04.1995 -	More C++ Support! Adding To-Do list.
*			Adding NOTES to autodocs. Fixing some things.
*			Introducing DiffTimeString(),StringString().
*	07.04.1995 -	Fixing two bugs.
*	17.04.1995 -	Integrating StringString()
*	22.04.1995 -	Rita Reichl corrects my bad English - again.
*	14.05.1995 -	New copyright notice!
*	16.05.1995 -	Fixing two small bugs.
*	19.05.1995 -	Rita corrects my English.
*	24.05.1995 -	Changing interface of TextEngine(), TextEngineJD(),
*			StringString()
*			Rewriting StringString() to support additional insert
*			strings.
*	25.05.1995 -	Writing test program
*	08.06.1995 -	Writing --compiling-- autodoc and some other small
*			fixes in the autodocs.
*	18.06.1995 -	Fixing C++ warnings/errors in textenginetest.c
*	18.07.1995 -	Replacing abs() with labs() to avoid problems!
*			Changing header from *strarr[] to **stararr
*	28.07.1995 -	Shortening the year of the version-string to 95,
*			because the Amiga 'version' command is buggy!
*
*****************************************************************************
*
*
*/

/*
******* TextEngine/--todo-- *************************************************
*
*   NAME
*	todo -- This is the 'To-Do' list of the TextEngine module
*
*   TODO
*	Find out about the Borland C++ 4.5 report about lines 140/150 in
*	textenginetest.c 'suspicious pointer conversion' / 'could not match
*	TextEngine()' :
*	void TextEngine(char *const string, double jd, const Languages lang,
*	double jd2, const char *const *const strarr);
*	            ----- (That's what the compiler does not like!)
*
*****************************************************************************
*
*
*/

/*
******* TextEngine/--compiling-- ********************************************
*
*   NAME
*	compiling -- Specials for compiling the textengine.
*
*   COMPILING
*	- You could compile this code as normal C or as C++
*
*****************************************************************************
*
*
*/

/*
******* TextEngine/--background-- *******************************************
*
*   NAME
*	TextEngine -- This module helps you with text features (V33)
*
*   FUNCTION
*	This module handles strings with different % commands
*
*   NOTES
*	None.
*
*   COPYRIGHT
*	This software is copyrighted 1994-95 by Kai Hofmann.
*	All rights reserved!
*
*	- Permission for COMMERCIAL USE is only given by an extra available
*	  commercial license that must be validated!
*	  Contact me directly for this license, because it will be
*	  individually handed out per your needs!
*
*	- Permission is hereby granted, without written agreement and without
*	  license, to USE this software and its documentation for any
*	  NON-COMMERCIAL purpose, provided that the above copyright notice
*	  and the following paragraph appear in all copies of this software
*	  (Non-commercial includes Giftware and Shareware!).
*
*	  You *must* include the following notice in your product and in your
*	  documentation:
*	  "This software uses the textengine that is copyrighted 1994-95 by
*	   Kai Hofmann"
*
*	  You "must" send me a full version of your product at no cost
*	  including free updates!
*	  Extra money is welcome (For Bank Account see below - but *ONLY*
*	  send in DM to this Bank Account!).
*
*	- THERE IS *NO PERMISSION* GIVEN TO MODIFY THIS SOFTWARE!
*
*	  If you need only parts of this software, you should not worry,
*	  because it's the job of the optimizer from your C compiler to
*	  include only the needed parts in your executable!
*
*   DISCLAIMER
*	THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
*	APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
*	HOLDER AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
*	WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*	A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND
*	PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE
*	DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
*	CORRECTION.
*
*	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
*	WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY REDISTRIBUTE
*	THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
*	INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
*	ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING
*	BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR
*	LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM
*	TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER
*	PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
*	THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
*	UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
*   DISTRIBUTION
*	Permission is hereby granted, without written agreement and without
*	license or royalty fees, to copy and distribute this software and its
*	documentation for any purpose, provided that the above copyright
*	notice and the following paragraphs appear in all copies of this
*	software, to:
*	- All who will distribute this software for free!
*	- All free accessible INTERNET servers and PHONE boxes!
*	- All Aminet sites
*	- All SimTel sites
*	- Fred Fish for his great Amiga-Software-Library
*	- The German SAAR AG PD-Library
*	- All others who do NOT take more than $5.- for one disk that
*	  includes this software!
*	- ALL others who do NOT take more than $40.- for one CD that includes
*	  this software!
*
*   ADDITIONAL INFORMATIONS
*	I have tried to make portable/useful and I hope bugfree software
*	for eternity!
*	So I hope very much that to some extend I will be compensated for my
*	hard work - monetarily or otherwise:-)
*
*	Kindly send US - dollars to a friend of mine in the USA who will
*	forward it to me in a timely manner.  Please send checks or money
*	orders only.
*	Contact me via email for more!
*
*   AUTHOR
*	Kai Hofmann
*	Arberger Heerstrae 92
*	28307 Bremen
*	Germany
*
*	Phone: (+49)-(0)421/480780
*	       (Remember that my parents don't speak english!)
*	EMail: i07m@zfn.uni-bremen.de
*	       i07m@informatik.uni-bremen.de
*	IRC  : PowerStat@#AmigaGer
*	WWW  : http://www.informatik.uni-bremen.de/~i07m
*
*	Bank account : 1203 7503
*	Account owner: Kai Hofmann
*	Bank code    : 290 501 01
*	Bank name    : Sparkasse in Bremen/Germany
*
*    THANKS
*	Thank you's are going to the following people:
*	Rita Reichl		- For correcting my bad english (very often)
*	Christian Schaefer	- For spending time on this code with his
*				  Borland C++ 4.5 compiler
*	Jacco van Weert &
*	Frans Slothouber	- For the 'Robodoc' utility
*
*****************************************************************************
*
*
*/


 #include "txteng.h"
 #include "date.h"   /* bool, Languages, ... */
 #include <string.h> /* strlen(), strchr() */
 #include <stdio.h>  /* sprintf() */
 #include <stdlib.h> /* abs() */
 #include <math.h>   /* floor() */

 /* ------------------------------------------------------------------------- */
/*
 static void FormatStr(char *const string, const unsigned int formatlength, const char orientation, const char leftfill, const char rightfill)

/ *
*****i* TextEngine/FormatStr ************************************************
*
*   NAME
*	FormatStr -- Formats a string (V33)
*
*   SYNOPSIS
*	FormatStr(string,formatlength,orientation);
*
*	void FormatStr(char *string, unsigned int formatlength,
*	    char orientation, const char leftfill, const char rightfill);
*
*   FUNCTION
*	Formats the string to left, right or center.
*
*   INPUTS
*	string       - String to format.
*	formatlength - The length in which the string should be formatted.
*	orientation  - The orientation to format the string:
*	               'l' for left, 'r' for right and 'c' for center
*	leftfill     - Character to use for leftside fill
*	rightfill    - Character to use for rightside fill
*
*   RESULT
*	string - The formatted string.
*
*   EXAMPLE
*	...
*	string = "test";
*	FormatStr(string,10,'l');
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	FormatStr will not test if the string is long enough for
*	formatlength - so if this is not true, system crashes could happen!
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
* /

  {
   unsigned int strlength;
   bool         leftright;

   strlength = strlen(string);
   switch (orientation)
    {
     case 'l' : while (strlength < formatlength)
                 {
                  string[strlength++] = rightfill;
                  string[strlength] = '\x0';
                 }
                break;
     case 'r' : while (strlength < formatlength)
                 {
                  unsigned int i;

                  for(i=strlength+1;i>0;i--)
                    string[i] = string[i-1];
                  string[0] = leftfill;
                  strlength++;
                 }
                break;
     case 'c' : leftright = false; / * start right * /
	        while (strlength < formatlength)
                 {
	          if (leftright)
                   {
                    unsigned int i;

                    for(i=strlength+1;i>0;i--)
                      string[i] = string[i-1];
                    string[0] = leftfill;
                    strlength++;
	           }
                  else
                   {
                    string[strlength++] = rightfill;
                    string[strlength] = '\x0';
    	           }
    	          leftright = !leftright;
                 }
                break;
     default  : ;
    }
  }
*/
 static void strdel(char *const string, const unsigned int pos, unsigned int count)

/*
*****i* TextEngine/strdel ***************************************************
*
*   NAME
*	strdel -- Deletes characters from a string (V33)
*
*   SYNOPSIS
*	strdel(string,pos,count);
*
*	void strdel(char *string, const unsigned int pos,
*	    unsigned int count);
*
*   FUNCTION
*	Deletes count characters from position pos in string or until
*	the end of the string.
*
*   INPUTS
*	string - String from which characters should be deleted.
*	pos    - Position from which characters should be deleted.
*	count  - Characters to delete.
*
*   RESULT
*	string - The string without the characters.
*
*   EXAMPLE
*	...
*	string = "test bla";
*	strdel(string,4,4);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	Unknown.
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
*/

  {
   unsigned short i;

   while (count > 0)
    {
     for (i=0;string[pos+i] != '\x0';i++)
      {
       string[pos+i] = string[pos+i+1];
      }
     count--;
    }
  }

 static void strinspos(char *const string, const unsigned int pos, const char *const istr)

/*
*****i* TextEngine/strinspos ************************************************
*
*   NAME
*	strinspos -- Inserts a string into another at a position (V33)
*
*   SYNOPSIS
*	strinspos(string,pos,istr);
*
*	void strinspos(char *string, const unsigned int pos, char *istr);
*
*   FUNCTION
*	Inserts istr in string at position pos.
*
*   INPUTS
*	string - String into istr should be inserted
*	pos    - Position into istr should be inserted
*	istr   - String to insert into string
*
*   RESULT
*	string - The string including istr
*
*   EXAMPLE
*	...
*	char string1[16] = "test bla";
*	char string2 = " bluber";
*	strinspos(string1,4,string2);
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	There is no test if there is enough space for istr in string!
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
*/

  {
   unsigned int lenistr,lenstr;
   int i;

   lenstr = strlen(string);
   lenistr = strlen(istr);
   for (i=(int)(lenstr-1);i>=(int)pos;i--)
     string[i+lenistr] = string[i];
   for (i=0;i<lenistr;i++)
     string[pos+i] = istr[i];
   string[lenstr+lenistr] = '\x0';
  }

 /* ------------------------------------------------------------------------- */

 #ifndef __cplusplus
   static void DateString(char *const string, const unsigned short day, const unsigned short month, const int year, const Languages lang)
 #else
   static void DateString(char *const string, const unsigned short day, const unsigned short month, const int year = 0, const Languages lang = English)
 #endif

/*
*****i* TextEngine/DateString ***********************************************
*
*   NAME
*	DateString -- Fills up %-commands for dates. (V33)
*
*   SYNOPSIS
*	DateString(string,day,month,year,lang);
*
*	void DateString(char *const string, const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Languages lang);
*
*	void DateString(char *const string, const unsigned short day,
*	    const unsigned short month, const int year = 0,
*	    const Languages lang = English);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string - String with % commands
*	day    - The day to fill in for % command
*	month  - The month to fill in for % command
*	year   - The year to fill in for % command, but only if it is != 0.
*	lang   - The language to use for weekday and month texts
*
*   RESULT
*	string - String without % commands, but with real values
*
*   EXAMPLE
*	...
*	string = "Today is %Dwl the %Ddf.%DMl.%Dyf4";
*	DateString(string,22,2,1994,English);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %D1[2][3]
*	  1 : d : day
*	      m : month
*	      M : month text
*	      y : year
*	      w : weekday
*	      W : week
*	      s : scaliger year
*	      j : JD
*	      J : MJD
*	  2 : v : variable length
*	      f : fixed length
*	      s : short text
*	      l : long text
*	  3 : 2 : short year
*	      4 : full year
*
*	  %Ddv  - supported: d[d]
*	  %Ddf  - supported: dd
*	  %Dmv  - supported: m[m]
*	  %Dmf  - supported: mm
*	  %DMs  - supported: MMM
*	  %DMl  - supported: M..M
*	  %Dyv2 - supported: y[y]
*	  %Dyv4 - supported: y[y[y[y]]]
*	  %Dyf2 - supported: yy
*	  %Dyf4 - supported: yyyy
*	  %Dws  - supported: ww[w]
*	  %Dwl  - supported: w..w
*	  %DWv  - supported: W[W]
*	  %DWf  - supported: WW
*	  %Dsv  - supported: s[s[s[s]]]
*	  %Dsf  - supported: ssss
*	  %Dj   - supported: j..
*	  %DJ   - supported: J..
*
*   NOTES
*	None.
*
*   BUGS
*	Unknown.
*
*   SEE ALSO
*	TimeString()
*
*****************************************************************************
*
*
*/

  {
   char *pos;
   unsigned short delcounter;
   char insertstr[21];

   pos = strchr(string,'%');
   while (pos != NULL)
    {
     delcounter = 0;
     insertstr[0] = '\x0';
     if (pos[1] == 'D')
      {
       delcounter = 4;
       switch (pos[2])
        {
         case 'd' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",day);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",day);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'm' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",month);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",month);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'M' : switch (pos[3])
                     {
                      case 's' : MonthShortText(month,insertstr,lang);
                                 break;
                      case 'l' : MonthText(month,insertstr,lang);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'y' : switch (pos[3])
                     {
                      case 'v' : delcounter = 5;
                                 switch (pos[4])
                                  {
                                   case '2' : sprintf(insertstr,"%2d",year-(year/100)*100);
                                              break;
                                   case '4' : sprintf(insertstr,"%4d",year);
                                              break;
                                   default  : delcounter = 0;
                                  }
                                 break;
                      case 'f' : delcounter = 5;
                                 switch (pos[4])
                                  {
                                   case '2' : sprintf(insertstr,"%02d",year-(year/100)*100);
                                              break;
                                   case '4' : sprintf(insertstr,"%04d",year);
                                              break;
                                   default  : delcounter = 0;
                                  }
                                 break;
                      default  : delcounter = 0;
                     }
                    if (year == 0)
                      insertstr[0] = '\x0';
                    break;
         case 'w' : switch (pos[3])
                     {
                      case 's' : WeekdayShortText(HeisWeekday(day,month,year),insertstr,lang);
                                 break;
                      case 'l' : WeekdayText(HeisWeekday(day,month,year),insertstr,lang);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'W' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",HeisWeek(day,month,year));
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",HeisWeek(day,month,year));
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 's' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%u",HYearToScaliger(year));
                                 break;
                      case 'f' : sprintf(insertstr,"%04u",HYearToScaliger(year));
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'j' : delcounter = 3;
                    sprintf(insertstr,"%lu",HeisToJD(day,month,year));
                    break;
         case 'J' : delcounter = 3;
                    sprintf(insertstr,"%lu",JDtoMJD(HeisToJD(day,month,year)));
                    break;
         default  : delcounter = 0;
        }
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     pos = strchr(pos+(delcounter == 0 ? 2 : strlen(insertstr)),'%');
    }
  }

 /* ------------------------------------------------------------------------- */

 #ifndef __cplusplus
   static void TimeString(char *const string, const unsigned short hour, const unsigned short min, const unsigned short sec)
 #else
   static void TimeString(char *const string, const unsigned short hour, const unsigned short min = 0, const unsigned short sec = 0)
 #endif

/*
*****i* TextEngine/TimeString ***********************************************
*
*   NAME
*	TimeeString -- Fills up %-commands for times. (V33)
*
*   SYNOPSIS
*	TimeString(string,hour,min,sec);
*
*	void TimeString(char *const string, const unsigned short hour,
*	    const unsigned short min, const unsigned short sec);
*
*	void TimeString(char *const string, const unsigned short hour,
*	    const unsigned short min = 0, const unsigned short sec = 0);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string - String with % commands
*	hour   - The hour to use
*	min    - The minute to use
*	sec    - The sec to use
*
*   RESULT
*	string - String with real values.
*
*   EXAMPLE
*	...
*	string = "Time %Thf:%Tmf.%Tsf";
*	TimeString(string,22,23,0);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %T1[2]
*	  T : time identifier
*	  1 : h : hour 24h format
*	      H : hour 12h format without "am/pm" text
*	      M : "am/pm" text
*	      m : minute
*	      s : second
*	      j : jd time
*	  2 : v : variable length
*	      f : fixed length
*
*	  %Thv - supported: h[h]
*	  %Thf - supported: hh
*	  %THv - supported: h[h]
*	  %THf - supported: hh
*	  %TM  - supported: am|pm
*	  %Tmv - supported: m[m]
*	  %Tmf - supported: mm
*	  %Tsv - supported: s[s]
*	  %Tsf - supported: ss
*	  %Tj  - supported: j
*
*   NOTES
*	None.
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	DateString()
*
*****************************************************************************
*
*
*/

  {
   char *pos;
   unsigned short delcounter;
   char insertstr[9];
   unsigned short hour12;

   pos = strchr(string,'%');
   while (pos != NULL)
    {
     delcounter = 0;
     insertstr[0] = '\x0';
     if (pos[1] == 'T')
      {
       delcounter = 4;
       switch (pos[2])
        {
         case 'h' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",hour);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",hour);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'H' : hour12 = (unsigned short)(hour > 12 ? hour-12 : hour);
                    switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",hour12);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",hour12);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'm' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",min);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",min);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 's' : switch (pos[3])
                     {
                      case 'v' : sprintf(insertstr,"%hu",sec);
                                 break;
                      case 'f' : sprintf(insertstr,"%02hu",sec);
                                 break;
                      default  : delcounter = 0;
                     }
                    break;
         case 'M' : delcounter = 3;
                    if (hour >= 12)
                     {
                      strcpy(insertstr,"pm");
                     }
                    else
                     {
                      strcpy(insertstr,"am");
                     }
                    break;
         case 'j' : delcounter = 3;
                    sprintf(insertstr,"%#f",TimeToJD(hour,min,sec));
                    break;
         default  : delcounter = 0;
        }
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     pos = strchr(pos+(delcounter == 0 ? 2 : strlen(insertstr)),'%');
    }
  }

 /* ------------------------------------------------------------------------- */

 #ifndef __cplusplus
   static void DiffDateString(char *const string, const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, int year2)
 #else
   static void DiffDateString(char *const string, const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, int year2 = 0)
 #endif

/*
*****i* TextEngine/DiffDateString *******************************************
*
*   NAME
*	DiffDateString -- Fills up %-commands for dates. (V33)
*
*   SYNOPSIS
*	DiffDateString(string,day1,month1,year1,day2,month2,year2);
*
*	void DiffDateString(char *const string, const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    int year2);
*
*	void DiffDateString(char *const string, const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    int year2 = 0);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string - String with % commands
*	day1   - The day of the lower date for % command
*	month1 - The month of the lower date for % command
*	year1  - The year of the lower date for % command
*	day2   - The day of the higher date for % command
*	month2 - The month of the higher date for % command
*	year2  - The year of the higher date for % command, if this is 0, it
*		 means the same year as year1!
*
*   RESULT
*	string - String without % commands, but with real values
*
*   EXAMPLE
*	...
*	string = "Kai is %Ay years old.";
*	DiffDateString(string,18,9,1970,22,3,1995);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %AD1
*	  1 : d : days
*	      y : years
*
*	  %ADd - supported: d[d..]
*	  %ADy - supported: y[y..]
*
*   NOTES
*	If day2 and month2 are both 0 only year2-year1 will be calculated
*	for %ADy, don't use %ADd in this situation!
*
*   BUGS
*	There is no check if date1 is really < than date2!
*
*   SEE ALSO
*	DiffTimeString()
*
*****************************************************************************
*
*
*/
  {
   char *pos;
   unsigned short delcounter;
   char insertstr[11];
   unsigned long age;

   if (year2 == 0)
     year2 = year1;
   pos = strchr(string,'%');
   while (pos != NULL)
    {
     delcounter = 0;
     insertstr[0] = '\x0';
     if ((pos[1] == 'A') && (pos[2] == 'D'))
      {
       delcounter = 4;
       switch (pos[3])
        {
         case 'd' : sprintf(insertstr,"%ld",HeisDayDiff(day1,month1,year1,day2,month2,year2));
                    break;
         case 'y' : age = year2-year1;
                    if ((Compare2Dates(day1,month1,0,day2,month2,0) == 1) && (month2 != 0) && (day2 != 0))
                      age--;
                    sprintf(insertstr,"%lu",age);
                    break;
         default  : delcounter = 0;
        }
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     pos = strchr(pos+(delcounter == 0 ? 2 : strlen(insertstr)),'%');
    }
  }

 /* ------------------------------------------------------------------------- */

 #ifndef __cplusplus
   static void DiffTimeString(char *const string, const unsigned short hour1, const unsigned short hour2, const unsigned short min1, const unsigned short min2, const unsigned short sec1, const unsigned short sec2)
 #else
   static void DiffTimeString(char *const string, const unsigned short hour1, const unsigned short hour2, const unsigned short min1 = 0, const unsigned short min2 = 0, const unsigned short sec1 = 0, const unsigned short sec2 = 0)
 #endif

/*
*****i* TextEngine/DiffTimeString *******************************************
*
*   NAME
*	DiffTimeString -- Fills up %-commands for dates. (V33)
*
*   SYNOPSIS
*	DiffTimeString(string,hour1,min1,sec1,hour2,min2,sec2);
*
*	void DiffTimeString(char *const string, const unsigned short hour1,
*	    const unsigned short hour2, const unsigned short min1,
*	    const unsigned short min2, const unsigned short sec1,
*	    const unsigned short sec2);
*
*	void DiffTimeString(char *const string, const unsigned short hour1,
*	    const unsigned short hour2, const unsigned short min1 = 0,
*	    const unsigned short min2 = 0, const unsigned short sec1 = 0,
*	    const unsigned short sec2 = 0);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string - String with % commands
*	hour1  - The hour of the lower time for % command
*	hour2  - The hour of the higher time for % command
*	min1   - The minute of the lower time for % command
*	min2   - The minute of the higher time for % command
*	sec1   - The second of the lower time for % command
*	sec2   - The second of the higher time for % command
*
*   RESULT
*	string - String without % commands, but with real values
*
*   EXAMPLE
*	...
*	string1 = "%ATh hours & %ATm minutes & %ATs seconds to go!";
*	DiffTimeString(string,18,20,30,15,0,0);
*	string2 = "%ATH hours = %ATM minutes = %ATS seconds to go! ";
*	DiffTimeString(string,18,20,30,15,0,0);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %AT1
*	  1 : h : full hours
*	      m : full minutes
*	      s : full seconds
*	      H : all in hours
*	      M : all in minutes
*	      S : all in seconds
*	      j : as JD time difference
*
*	  %ATh - supported: h[h..]
*	  %ATm - supported: m[m]
*	  %ATs - supported: s[s]
*	  %ATH - supported: h[h..][.h[h..]]
*	  %ATM - supported: m[m..][.m[m..]]
*	  %ATS - supported: s[s..]
*	  %ATj - supported: j
*
*   NOTES
*	None.
*
*   BUGS
*	There is no check if time1 is really < than time2!
*
*   SEE ALSO
*	DiffDateString()
*
*****************************************************************************
*
*
*/
  {
   char *pos;
   unsigned short delcounter,h3,m3,s3;
   char insertstr[21];
   long seconds;

   seconds = (long)(TimeToSec(hour2,min2,sec2)-TimeToSec(hour1,min1,sec1));
   #ifndef __cplusplus
     seconds = labs(seconds);
     SecToTime(seconds,&h3,&m3,&s3);
   #else
     if (seconds < 0)
       seconds = -seconds;
     SecToTime(seconds,h3,m3,s3);
   #endif
   pos = strchr(string,'%');
   while (pos != NULL)
    {
     delcounter = 0;
     insertstr[0] = '\x0';
     if ((pos[1] == 'A') && (pos[2] == 'T'))
      {
       delcounter = 4;
       switch (pos[3])
        {
         case 'h' : sprintf(insertstr,"%hu",h3);
                    break;
         case 'm' : sprintf(insertstr,"%hu",m3);
                    break;
         case 's' : sprintf(insertstr,"%hu",s3);
                    break;
         case 'H' : sprintf(insertstr,"%#.2f",(float)(seconds/3600.0));
                    break;
         case 'M' : sprintf(insertstr,"%#.2f",(float)(seconds/60.0));
                    break;
         case 'S' : sprintf(insertstr,"%ld",seconds);
                    break;
         case 'j' : sprintf(insertstr,"%#f",TimeToJD(h3,m3,s3));
                    break;
         default  : delcounter = 0;
        }
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     pos = strchr(pos+(delcounter == 0 ? 2 : strlen(insertstr)),'%');
    }
  }

 /* ------------------------------------------------------------------------- */

 static void StringString(char *const string, const char *const strarr[])

/*
*****i* TextEngine/StringString *********************************************
*
*   NAME
*	StringString -- Fills up %-commands for strings. (V33)
*
*   SYNOPSIS
*	StringString(string,string2);
*
*	void StringString(char *const string, const char *const strarr[]);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string  - String with % commands
*	strarr  - Stringarray with the strings to insert, terminated by NULL
*
*   RESULT
*	string - String with real value.
*
*   EXAMPLE
*	...
*	string = "This is a %S0";
*	StringString(string,{"test",NULL});
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %S1
*	  1 : Stringarray index
*
*	  %Sx - supported: s[x]
*
*   NOTES
*	None.
*
*   BUGS
*	It is not possible to write a number directly behind a %S command,
*	because this will be identified as array index, so another character
*	as a digit is needed!
*
*   SEE ALSO
*	DateString(), TimeString()
*
*****************************************************************************
*
*
*/

  {
   char *pos;
   unsigned short delcounter;
   unsigned int idx,maxidx=0;

   if (strarr != NULL)
    {
     while (strarr[maxidx] != NULL)
      {
       maxidx++;
      }
     pos = strchr(string,'%');
     while (pos != NULL)
      {
       delcounter = 0;
       idx = 0;
       if (pos[1] == 'S')
        {
         while ((pos[2+delcounter] >= '0') && (pos[2+delcounter] <= '9'))
          {
           idx *= 10;
           idx += (unsigned int)pos[2+delcounter] - (unsigned int)'0';
           delcounter++;
          }
         if (delcounter != 0)
          {
           delcounter += 2;
           strdel(pos,0,delcounter);
           if (idx < maxidx)
            {
             strinspos(pos,0,strarr[idx]);
            }
          }
        }
       pos = strchr(pos+(delcounter == 0 ? 2 : strlen(strarr[idx])),'%');
      }
    }
  }

 /* ------------------------------------------------------------------------- */

 #ifndef __cplusplus
   void TextEngine(char *const string, const unsigned short day, const unsigned short month, const int year, const unsigned short hour, const unsigned short min, const unsigned short sec, const Languages lang, const unsigned short day2, const unsigned short month2, const int year2, const unsigned short hour2, const unsigned short min2, const unsigned short sec2, const char *const *const strarr)
 #else
   void TextEngine(char *const string, const unsigned short day, const unsigned short month, const int year, const unsigned short hour, const unsigned short min, const unsigned short sec, const Languages lang, const unsigned short day2, const unsigned short month2, const int year2, const unsigned short hour2, const unsigned short min2, const unsigned short sec2, const char *const *const strarr)
 #endif

/*
******* TextEngine/TextEngine ***********************************************
*
*   NAME
*	TextEngine -- Fills up %-commands (V33)
*
*   SYNOPSIS
*	TextEngine(string,day,month,year,hour,min,sec,lang,day2,month2,
*	    year2,hour2,min2,sec2,strarr);
*	TextEngine(string,jd,lang,jd2,strarr)
*
*	void TextEngine(char *const string, const unsigned short day,
*	    const unsigned short month, const int year = 0,
*	    const unsigned short hour = 0, const unsigned short min = 0,
*	    const unsigned short sec = 0, const Languages lang = English,
*	    const unsigned short day2 = 0, const unsigned short month2 = 0,
*	    const int year2 = 0, const unsigned short hour2 = 0,
*	    const unsigned short min2 = 0, const unsigned short sec2 = 0,
*	    const char *const *const strarr = NULL);
*
*	void TextEngine(char *const string, double jd,
*	    const Languages lang = English, double jd2 = 0.0.
*	    const char *const *const strarr = NULL);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string  - String with % commands
*	day     - The day to fill in for % command
*	month   - The month to fill in for % command
*	year    - The year to fill in for % command, if this is 0 it will not
*		  filled in!
*	hour    - The hour to use
*	min     - The minute to use
*	sec     - The sec to use
*	lang    - The language to use for texts
*	day2    - The diff. day
*	month2  - The diff. month
*	year2   - The diff. year, if you use 0, this will mean: use the same
*		  as year!
*	hour2   - The diff. hour
*	min2    - The diff. minute
*	sec2    - The diff. second
*	strarr  - Stringarray with the strings to insert, terminated by NULL
*
*   RESULT
*	string - String without % commands, but with real values
*
*   EXAMPLE
*	...
*	string = "Only a test!";
*	TextEngine(string,18,9,1970,14,44,0,English,22,3,1995,15,14,0,NULL);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  %%    : %
*	  %+DTj : JD.JD  date+time
*	  %+DTJ : MJD.JD date+time
*
*	  %D1[2][3]
*	  1 : d : day
*	      m : month
*	      M : month text
*	      y : year
*	      w : weekday
*	      W : week
*	      s : scaliger year
*	      j : JD
*	      J : MJD
*	  2 : v : variable length
*	      f : fixed length
*	      s : short text
*	      l : long text
*	  3 : 2 : short year
*	      4 : full year
*
*	  %Ddv  - supported: d[d]
*	  %Ddf  - supported: dd
*	  %Dmv  - supported: m[m]
*	  %Dmf  - supported: mm
*	  %DMs  - supported: MMM
*	  %DMl  - supported: M..M
*	  %Dyv2 - supported: y[y]
*	  %Dyv4 - supported: y[y[y[y]]]
*	  %Dyf2 - supported: yy
*	  %Dyf4 - supported: yyyy
*	  %Dws  - supported: ww[w]
*	  %Dwl  - supported: w..w
*	  %DWv  - supported: W[W]
*	  %DWf  - supported: WW
*	  %Dsv  - supported: s[s[s[s]]]
*	  %Dsf  - supported: ssss
*	  %Dj   - supported: j..
*	  %DJ   - supported: J..
*
*	  %T1[2]
*	  T : time identifier
*	  1 : h : hour 24h format
*	      H : hour 12h format without "am/pm" text
*	      M : "am/pm" text
*	      m : minute
*	      s : second
*	      j : jd time
*	  2 : v : variable length
*	      f : fixed length
*
*	  %Thv - supported: h[h]
*	  %Thf - supported: hh
*	  %THv - supported: h[h]
*	  %THf - supported: hh
*	  %TM  - supported: am|pm
*	  %Tmv - supported: m[m]
*	  %Tmf - supported: mm
*	  %Tsv - supported: s[s]
*	  %Tsf - supported: ss
*	  %Tj  - supported: j
*
*	  %AD1
*	  1 : d : Difference from the given date to the actual date in days.
*	      y : Difference from the given date to the actual date in years.
*
*	  %ADd - supported: d[d..]
*	  %ADy - supported: y[y..]
*
*	  %AT1
*	  1 : h : full hours
*	      m : full minutes
*	      s : full seconds
*	      H : all in hours
*	      M : all in minutes
*	      S : all in seconds
*	      j : as JD time difference
*
*	  %ATh - supported: h[h..]
*	  %ATm - supported: m[m]
*	  %ATs - supported: s[s]
*	  %ATH - supported: h[h..][.h[h..]]
*	  %ATM - supported: m[m..][.m[m..]]
*	  %ATS - supported: s[s..]
*	  %ATj - supported: j
*
*	  %S
*	  S : string identifier
*
*	  %S - supported: s
*
*   NOTES
*	If day2 and month2 are both 0 only year2-year will be calculated
*	for %ADy, don't use %ADd in this situation!
*	Think before using:
*	  TextEngine(str,18,9,1970,0,0,0,English,18,9,1995,0,0,0) or
*	  TextEngine(str,18,9,1995,0,0,0,English,18,9,1970,0,0,0)
*
*   BUGS
*	Keep care that in string is enought space to expand it - if not
*	unknown effects may occur!
*
*   SEE ALSO
*	DateString(), TimeString()
*
*****************************************************************************
*
*
*/

  {
   char *pos;
   unsigned short delcounter;
   char insertstr[21];

   StringString(string,strarr);
   DateString(string,day,month,year,lang);
   TimeString(string,hour,min,sec);
   if (Compare2Dates(day,month,year,day2,month2,year2) == -1)
     DiffDateString(string,day,month,year,day2,month2,year2);
   else
     DiffDateString(string,day2,month2,year2,day,month,year);
   DiffTimeString(string,hour,hour2,min,min2,sec,sec2);
   pos = strchr(string,'%');
   while (pos != NULL)
    {
     delcounter = 0;
     insertstr[0] = '\x0';
     if ((pos[1] == '+') && (pos[2] == 'D') && (pos[3] == 'T'))
      {
       delcounter = 5;
       switch (pos[4])
        {
         case 'j' : sprintf(insertstr,"%#f",HeisToJD(day,month,year)+TimeToJD(hour,min,sec));
                    break;
         case 'J' : sprintf(insertstr,"%#f",JDtoMJD(HeisToJD(day,month,year))+TimeToJD(hour,min,sec));
                    break;
         default  : delcounter = 0;
        }
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     else if (pos[1] == '%')
      {
       delcounter = 2;
       strcpy(insertstr,"%");
       strdel(pos,0,delcounter);
       strinspos(pos,0,insertstr);
      }
     pos = strchr(pos+(delcounter == 0 ? 2 : strlen(insertstr)),'%');
    }
  }


 #ifndef __cplusplus
   void TextEngineJD(char *const string, double jd, const Languages lang, double jd2, const char *const *const strarr)
/*
******* TextEngine/TextEngineJD *********************************************
*
*   NAME
*	TextEngineJD -- Fills up %-commands (V33)
*
*   SYNOPSIS
*	TextEngineJD(string,jd,lang,jd2,strarr);
*
*	void TextEngineJD(char *const string, double jd,
*	    const Languages lang = English, double jd2 = 0.0,
*	    const char *const *const strarr);
*
*   FUNCTION
*	Finds and replaces % commands with real values.
*
*   INPUTS
*	string  - String with % commands.
*	jd      - The JD including time information.
*	lang    - The language to use for texts.
*	jd2     - The diff. JD.
*	strarr  - Stringarray with the strings to insert, terminated by NULL
*
*   RESULT
*	string - String without % commands, but with real values.
*
*   EXAMPLE
*	...
*	string = "Only a test!";
*	TextEngineJD(string,2449754.630556,English,2449700,NULL);
*	...
*
*   SYNTAX
*	Syntax of % commands:
*	  See TextEngine()
*
*   NOTES
*	See TextEngine().
*
*   BUGS
*	Unknown.
*
*   SEE ALSO
*	TextEngine()
*
*****************************************************************************
*
*
*/
 #else
   void TextEngine(char *const string, double jd, const Languages lang, double jd2, const char *const *const strarr)
 #endif

  {
   unsigned short day,month,hour,min,sec,day2,month2,hour2,min2,sec2;
   int year,year2;

   #ifndef __cplusplus
     JDToHeis((unsigned long)jd,&day,&month,&year);
     JDToHeis((unsigned long)jd2,&day2,&month2,&year2);
   #else
     JDToHeis((unsigned long)jd,day,month,year);
     JDToHeis((unsigned long)jd2,day2,month2,year2);
   #endif
   jd -= floor(jd);
   jd2 -= floor(jd2);
   #ifndef __cplusplus
     JDToTime((float)jd,&hour,&min,&sec);
     JDToTime((float)jd2,&hour2,&min2,&sec2);
   #else
     JDToTime((float)jd,hour,min,sec);
     JDToTime((float)jd2,hour2,min2,sec2);
   #endif
   TextEngine(string,day,month,year,hour,min,sec,lang,day2,month2,year2,hour2,min2,sec2,strarr);
  }

 /* ------------------------------------------------------------------------- */
