#include <jlib.h>
#include <jx_font.h>

/* shows textured fonts with a rotating background texture */
#define ITERATIONS 10000
#define SPEED   (UCLOCK_TICKS_PER_SECOND/8)     /* 1/8 of a second */

int main(int argc ,char **argv)
{
 font *f;
 buffer_rec *offscreen,*texture,*t2;
 int i,j;
 image *tex;
 unsigned int st,et;

 JLIB_DEBUG_ON;

 if (argc != 4) {
    puts("fonttst3 <font> <texture> <text> : draws some <text> in <font> with a moving <texture>\n<texure> should be a 64x64 (or bigger) PCX file.");
    exit(0);
 }

 screen_set_video_mode();
 uclock_init();

 /* load and check font */
 f=font_load(argv[1]);
 if(f==NULL){
    jlib_exit("font load failed");
 }

 /* load texture */
 if((tex=image_load_pcx(argv[2])) == NULL) {
    jlib_exit("image load failed");
 }

 screen_block_set_pal(IMG_PALETTE(tex));

 offscreen=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 texture=buff_init(IMG_WIDTH(tex),IMG_HEIGHT(tex));
 t2=buff_init(IMG_WIDTH(tex),IMG_HEIGHT(tex));

 /* copy texture pcx into a buffer */
 buff_blit_img_to(texture,0,0,tex,0,0,IMG_MAX_X(tex),IMG_MAX_Y(tex));

 for(i=0;i<ITERATIONS;i++){
     st=uclock_read();
     font_string(f,offscreen,0,0,argv[3],15,texture,FONT_TEXTURE);
     screen_blit_fs_buffer(offscreen);
     /* rotate texture upwards */
     buff_blit_buff_to(t2,0,0,texture,0,1,IMG_MAX_X(tex),IMG_MAX_Y(tex));
     buff_blit_buff_to(t2,0,IMG_MAX_Y(tex),texture,0,0,IMG_MAX_X(tex),1);
     buff_blit_buff_to(texture,0,0,t2,0,0,IMG_MAX_X(tex),IMG_MAX_Y(tex));
     do{
        et=uclock_read();
     }while((et-st) < SPEED);   /* delay for SPEED time */
 }

 screen_restore_video_mode();
 return 1;
}
