/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <grx20.h>

/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
JINLINE void screen_blit_fs_buffer(buffer_rec *buff)
{
 JLIB_ENTER("screen_blit_fs_buffer");

  /* 'fake' the blit as a context to context blit */
  __jlib_fake_context->gc_baseaddr[0] = B_BUFF_PTR(buff);

 GrBitBltNC(NULL,0,0,__jlib_fake_context,0,0,SCREEN_MAX_X,SCREEN_MAX_Y,GrWRITE);

 JLIB_LEAVE;
}

/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen without clipping.                   |*/
/*+------------------------------------------------------------------------+*/
void screen_blit_buff_toNC(int x,int y,buffer_rec *sbuff,
			  int sbx1, int sby1,int sbx2, int sby2)
{
 char *ourmem[4];

 JLIB_ENTER("screen_blit_buff_toNC");

 ourmem[0] = B_BUFF_PTR(sbuff);

 /* fill in the correct details for the blit */
 GrCreateFrameContext(GR_frameRAM8,B_X_SIZE(sbuff),B_Y_SIZE(sbuff),ourmem,__jlib_fake_partial_context);

 __jlib_fake_partial_context->gc_lineoffset = GrLineOffset(B_X_SIZE(sbuff));

 GrBitBltNC(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);

 JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen with clipping.                      |*/
/*+------------------------------------------------------------------------+*/
void screen_blit_buff_to(int x,int y,buffer_rec *sbuff,
			 int sbx1, int sby1,int sbx2, int sby2)
{
 char *ourmem[4];

 JLIB_ENTER("screen_blit_buff_to");

 ourmem[0] = B_BUFF_PTR(sbuff);

 /* fill in the correct details for the blit */
 GrCreateFrameContext(GR_frameRAM8,B_X_SIZE(sbuff),B_Y_SIZE(sbuff),ourmem,__jlib_fake_partial_context);
 
 __jlib_fake_partial_context->gc_lineoffset = GrLineOffset(B_X_SIZE(sbuff));

 /* blit using grx */
 GrBitBlt(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);

 JLIB_LEAVE;
}
