/*
Ŀ
jzinsstr.c								     
Insert a string into another string at a given index position. 	     
Note that the starting position is the index, not the character number like 
in pascal!.								     
Synopsis:								     
   char wstr[255];							     
									     
   strcpy(wstr,"this a test");                                              
									     
   jzinsstr(wstr,"is ",5);                                                  
									     
   { yields "this is a test" }                                              
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/

#include <jaz.h>
jzinsstr(fdestin,fsource,fstart)
char *fdestin;
char *fsource;
int fstart;
{

  int wdlen,wslen;
  int w,wlen,wpad;

  wdlen = strlen(fdestin);	/* get destination string length */
  wslen = strlen(fsource);	/* get source string length */

  wlen = min(fstart,wdlen);	/* don't initially point past destin */

  wpad = fstart - wlen; 	/* get extra length to pad */

  for (w = wlen ; w < fstart ; w ++)	/* pad with blanks if neccessary */
    fdestin[w] = ' ';

  /* start at end of string and move characters to the right */
  /* draw it out if necessary; It's hard to follow if you don't */

  for (w = wdlen + wslen - 1 ; w >= fstart + wslen ; w --)
    fdestin[w] = fdestin[w - wslen];

  for (w = 0 ; w < wslen ; w ++)	/* now insert into the dest string */
    fdestin[w+fstart] = *fsource++;

  fdestin[wslen+wdlen+wpad] = 0;	/* string is bigger, needs NULL */
}

