; @memcmp
;   AAA=str
;   BBB=018
;   F=0
;   O=0
; str01800.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_memcmp:FN_CALL PTR
p_fn_fc_memcmp P_FN_CALL @memcmp
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memcmp() -- Compare memory blocks
;int __fastcall fn_call memcmp(const void __near * const, const void __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_m1, (dest) offset from ds
;   AX	    p_m2, (source) offset from ds
;   DX	    cnt
;RETURNS:
;   AX
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
BEGIN_CODE_SEGMENT <STRING>
@memcmp PROC FN_CALL USES es si di cx

	    mov di, bx	    ;es:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov ax, ds
	    mov es, ax

	    xor ax, ax
	    cmp si,di		    ;Equal?
	    je @@done
@@cont:
	    mov cx, dx	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
@memcmp ENDP
END_CODE_SEGMENT <STRING>
END
