; memset_sss
;   AAA=str
;   BBB=017
;   F=0
;   O=1
; str01701.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_memset_sss:FN_CALL PTR
p_fn_memset_sss P_FN_CALL memset_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memset_sss() -- Set memory block
;void __near * fn_call memset_sss(void __near * const, const int, const int);
;GIVEN:
;   p_m 	near pointer, (source) offset from ss
;   chr 	value to set to
;   cnt 	number of bytes to set to chr
;RETURNS:
;   pointer	near pointer, offset from ss (p_m)
BEGIN_CODE_SEGMENT <STRING>
memset_sss PROC FN_CALL C uses es di, p_m:NEAR16 PTR, chr:WORD, cnt:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m]	    ;es:DI = block
	    mov cx, [cnt]	     ;CX = count
	    mov ax, [chr]
	    xor ah, ah		     ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, [p_m]
	    ret
memset_sss ENDP
END_CODE_SEGMENT <STRING>
END
