; strrchr_sss
;   AAA=str
;   BBB=008
;   F=0
;   O=1
; str00801.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strrchr_sss:FN_CALL PTR
p_fn_strrchr_sss P_FN_CALL strrchr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strrchr_sss() -- Search string for char, in reverse
;char __near * fn_call strrchr_sss(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string
BEGIN_CODE_SEGMENT <STRING>
strrchr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds/ss:si = p_Str
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr_sss ENDP
END_CODE_SEGMENT <STRING>
END
