; iscsymf
;   AAA=mis
;   BBB=006
;   F=
;   O=0
; str006.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_iscsymf:FN_CALL PTR
p_fn_iscsymf P_FN_CALL iscsymf
EXTERNDEF C p_fn_fc_iscsymf:FN_CALL PTR
p_fn_fc_iscsymf P_FN_CALL @iscsymf
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF


;iscsymf() - Letter or underscore
;int fn_call iscsymf(const int);
; RETURNS:
;   0	    if not a letter or underscore
;   1	    if	   a letter or underscore
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
iscsymf PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 'A' ; capital?
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore?
    je @@yes

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
iscsymf ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;iscsymf() - Letter or underscore
;int __fastcall fn_call iscsymf(const int);
; __fastcall
;   AX	    num
; RETURNS:
;   AX
;   0	    if not a letter or underscore
;   1	    if	   a letter or underscore
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@iscsymf PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'A' ; capital?
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore?
    je @@yes

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@iscsymf ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
