/* misc.h, clibc_16.lib */

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef DEBUG_YES
# define DEBUG_YES 1
#endif

#ifndef DEBUG_NO
# define DEBUG_NO 0
#endif

#ifndef CLIBC_16_FARCALL
# define CLIBC_16_FARCALL 1
#endif

#ifndef CLIBC_16_NEARCALL
# define CLIBC_16_NEARCALL 0
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_YES
# define  CLIBC_16_FC_EXT_PTRS_YES 1
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_NO
# define CLIBC_16_FC_EXT_PTRS_NO 0
#endif

/* defaults */
#ifndef CLC16_C
# define CLC16_C CLIBC_16_NEARCALL
#endif

#ifndef CLIBC_16_FC_EXT_PTRS
# define CLIBC_16_FC_EXT_PTRS CLIBC_16_FC_PTRS_NO
#endif

/* more */
#if CLC16_C == CLIBC_16_NEARCALL
# ifndef fn_call
#  define fn_call __near __based(__segname("_TEXT"))
# endif
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg("_TEXT","CODE")
# endif
# ifndef fn_call_dist
#  define fn_call_dist __near
# endif
# ifndef CLIBC_16_CS_NAME
#  define CLIBC_16_CS_NAME "_TEXT"
# endif
#else
# ifndef fn_call
#  define fn_call __far __based(__segname("CLIBC_16"))
# endif
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg("CLIBC_16","CODE")
# endif
# ifndef fn_call_dist
#  define fn_call_dist __far
# endif
# ifndef CLIBC_16_CS_NAME
#  define CLIBC_16_CS_NAME "CLIBC_16"
# endif
#endif

#ifdef DEBUG
# if DEBUG==DEBUG_YES
# endif
#endif

#ifdef FASTCALL_MISC_ALL
# define FASTCALL_ISSPACE
# define FASTCALL_ISALNUM
# define FASTCALL_ISALPHA
# define FASTCALL_ISASCII
# define FASTCALL_ISCNTRL
# define FASTCALL_ISCSYM
# define FASTCALL_ISCSYMF
# define FASTCALL_ISDIGIT
# define FASTCALL_ISLOWER
# define FASTCALL_ISUPPER
# define FASTCALL_ISXDIGIT
#endif

/* isspace */
#ifdef FASTCALL_ISSPACE
int __fastcall fn_call isspace(const int);
#else
int fn_call isspace(const int);
#endif

#ifndef DEFINED_P_FN_ISSPACE
# define DEFINED_P_FN_ISSPACE
  typedef int (fn_call_dist * P_FN_ISSPACE)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISSPACE
# define DEFINED_P_FN_FC_ISSPACE
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISSPACE)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISSPACE
#  define DEFINED_EXTERN_P_FN_FC_ISSPACE
   extern P_FN_FC_ISSPACE const p_fn_fc_isspace;
# endif
#endif

/* isalnum */
#ifdef FASTCALL_ISALNUM
int __fastcall fn_call isalnum(const int);
#else
int fn_call isalnum(const int);
#endif

#ifndef DEFINED_P_FN_ISALNUM
# define DEFINED_P_FN_ISALNUM
  typedef int (fn_call_dist * P_FN_ISALNUM)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISALNUM
# define DEFINED_P_FN_FC_ISALNUM
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISALNUM)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISALNUM
#  define DEFINED_EXTERN_P_FN_FC_ISALNUM
   extern P_FN_FC_ISALNUM const p_fn_fc_isalnum;
# endif
#endif

/* isalpha */
#ifdef FASTCALL_ISALPHA
int __fastcall fn_call isalpha(const int);
#else
int fn_call isalpha(const int);
#endif

#ifndef DEFINED_P_FN_ISALPHA
# define DEFINED_P_FN_ISALPHA
  typedef int (fn_call_dist * P_FN_ISALPHA)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISALPHA
# define DEFINED_P_FN_FC_ISALPHA
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISALPHA)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISALPHA
#  define DEFINED_EXTERN_P_FN_FC_ISALPHA
   extern P_FN_FC_ISALPHA const p_fn_fc_isalpha;
# endif
#endif

/* isascii */
#ifdef FASTCALL_ISASCII
int __fastcall fn_call isascii(const int);
#else
int fn_call isascii(const int);
#endif

#ifndef DEFINED_P_FN_ISASCII
# define DEFINED_P_FN_ISASCII
  typedef int (fn_call_dist * P_FN_ISASCII)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISASCII
# define DEFINED_P_FN_FC_ISASCII
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISASCII)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISASCII
#  define DEFINED_EXTERN_P_FN_FC_ISASCII
   extern P_FN_FC_ISASCII const p_fn_fc_isascii;
# endif
#endif

/* iscntrl */
#ifdef FASTCALL_ISCNTRL
int __fastcall fn_call iscntrl(const int);
#else
int fn_call iscntrl(const int);
#endif

#ifndef DEFINED_P_FN_ISCNTRL
# define DEFINED_P_FN_ISCNTRL
  typedef int (fn_call_dist * P_FN_ISCNTRL)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCNTRL
# define DEFINED_P_FN_FC_ISCNTRL
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCNTRL)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISCNTRL
#  define DEFINED_EXTERN_P_FN_FC_ISCNTRL
   extern P_FN_FC_ISCNTRL const p_fn_fc_iscntrl;
# endif
#endif

/* iscsym */
#ifdef FASTCALL_ISCSYM
int __fastcall fn_call iscsym(const int);
#else
int fn_call iscsym(const int);
#endif

#ifndef DEFINED_P_FN_ISCSYM
# define DEFINED_P_FN_ISCSYM
  typedef int (fn_call_dist * P_FN_ISCSYM)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCSYM
# define DEFINED_P_FN_FC_ISCSYM
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCSYM)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISCSYM
#  define DEFINED_EXTERN_P_FN_FC_ISCSYM
   extern P_FN_FC_ISCSYM const p_fn_fc_iscsym;
# endif
#endif

/* iscsymf */
#ifdef FASTCALL_ISCSYMF
int __fastcall fn_call iscsymf(const int);
#else
int fn_call iscsymf(const int);
#endif

#ifndef DEFINED_P_FN_ISCSYMF
# define DEFINED_P_FN_ISCSYMF
  typedef int (fn_call_dist * P_FN_ISCSYMF)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCSYMF
# define DEFINED_P_FN_FC_ISCSYMF
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCSYMF)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISCSYMF
#  define DEFINED_EXTERN_P_FN_FC_ISCSYMF
   extern P_FN_FC_ISCSYMF const p_fn_fc_iscsymf;
# endif
#endif

/* isdigit */
#ifdef FASTCALL_ISDIGIT
int __fastcall fn_call isdigit(const int);
#else
int fn_call isdigit(const int);
#endif

#ifndef DEFINED_P_FN_ISDIGIT
# define DEFINED_P_FN_ISDIGIT
  typedef int (fn_call_dist * P_FN_ISDIGIT)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISDIGIT
# define DEFINED_P_FN_FC_ISDIGIT
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISDIGIT)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISDIGIT
#  define DEFINED_EXTERN_P_FN_FC_ISDIGIT
   extern P_FN_FC_ISDIGIT const p_fn_fc_isdigit;
# endif
#endif

/* islower */
#ifdef FASTCALL_ISLOWER
int __fastcall fn_call islower(const int);
#else
int fn_call islower(const int);
#endif

#ifndef DEFINED_P_FN_ISLOWER
# define DEFINED_P_FN_ISLOWER
  typedef int (fn_call_dist * P_FN_ISLOWER)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISLOWER
# define DEFINED_P_FN_FC_ISLOWER
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISLOWER)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISLOWER
#  define DEFINED_EXTERN_P_FN_FC_ISLOWER
   extern P_FN_FC_ISLOWER const p_fn_fc_islower;
# endif
#endif

/* isupper */
#ifdef FASTCALL_ISUPPER
int __fastcall fn_call isupper(const int);
#else
int fn_call isupper(const int);
#endif

#ifndef DEFINED_P_FN_ISUPPER
# define DEFINED_P_FN_ISUPPER
  typedef int (fn_call_dist * P_FN_ISUPPER)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISUPPER
# define DEFINED_P_FN_FC_ISUPPER
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISUPPER)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISUPPER
#  define DEFINED_EXTERN_P_FN_FC_ISUPPER
   extern P_FN_FC_ISUPPER const p_fn_fc_isupper;
# endif
#endif

/* isxdigit */
#ifdef FASTCALL_ISXDIGIT
int __fastcall fn_call isxdigit(const int);
#else
int fn_call isxdigit(const int);
#endif

#ifndef DEFINED_P_FN_ISXDIGIT
# define DEFINED_P_FN_ISXDIGIT
  typedef int (fn_call_dist * P_FN_ISXDIGIT)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISXDIGIT
# define DEFINED_P_FN_FC_ISXDIGIT
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISXDIGIT)(const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_ISXDIGIT
#  define DEFINED_EXTERN_P_FN_FC_ISXDIGIT
   extern P_FN_FC_ISXDIGIT const p_fn_fc_isxdigit;
# endif
#endif
