INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_isupper:FN_CALL PTR
p_fn_fc_isupper P_FN_CALL @isupper
_DATA ENDS

 ENDIF
ENDIF

;isupper() - is uppercase letter ('A'-'Z')
;int fn_call isupper(const int);

;RETURNS:
;   0	if NOT uppercase letter
;   1	if     uppercase letter

CLIBC_16_CS SEGMENT
isupper PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 'A' ; uppercase ?
    jb @@done
    cmp bl, 'Z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isupper ENDP

; __fastcall
;   AX	    num
;int __fastcall fn_call isupper(const int);
@isupper PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'A' ; uppercase ?
    jb @@done
    cmp bl, 'Z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isupper ENDP
CLIBC_16_CS ENDS
END
