/* strcmp.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strcmp.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strcmp)
#endif

// strcmp() -- Compare strings
//  int strcmp(const char * const, const char * const); 
// GIVEN:
//	p_str1		String to compare.
//	p_str2		String to compare.
// RETURNS: (r8)
//	<0		if str1 < str2
//	0		if str1 = str2
//	>0		if str1 > str2
// NOTES:
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strcmp)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str1==r32
p_str2==r33
ret_val==r8
tmp1==r9
tmp2==r10
	mov ret_val=r0
Loop:
	ld1 tmp1=[p_str1],1
	ld1 tmp2=[p_str2],1
	cmp.eq p30,p31=tmp1,tmp2
	(p30) br Equal
	cmp.gtu p30,p31=tmp1,tmp2
	(p30) add ret_val=ret_val,r0,1		// ++ret_val
	(p31) sub ret_val=ret_val,r0,1		// --ret_val
	br Exit
Equal:
	cmp.ne p30,p31=tmp1,r0
	(p30) br Loop
Exit:
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strcmp)
