;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+                                                                             +
;+                     FLAT.INC Version 1.2 Source Code                        +
;+                                                                             +
;+              Copyright 1995, 1996 by TechniLib (TM) Company                 +
;+                          All Rights Reserved                                +
;+                                                                             +
;+                  SALE OR USE OF SOFTWARE DEVELOPED WITH                     +
;+                     UNREGISTERED COPIES OF THIS CODE                        +
;+                           INFRINGES COPYRIGHT                               +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;                    Flat-Model Programming For DOS
;                              Version 1.2
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   This include file may be used to enable approximate flat-model programming
;in DOS using assembly language.  The following template should be used in the
;program:
;
;              INCLUDE        FLAT.INC       ;Always 1st line
;
;MAIN          PROC NEAR                     ;Execution always begins at MAIN
;              .
;              .
;              .
;              RET                           ;Execution ends here
;MAIN          ENDP
;
;              [Other Procedures]            ;All procedures must be near
;
;              [Program Data]
;
;              END
;
;   The actual order of MAIN, other procedures, and data does not matter.
;The important things are that the module begin with FLAT.INC, that execution
;begin at MAIN, and that all procedures be near.
;   MAIN must be near for successful termination.  Other procedures must be
;near because the assembler will not properly handle far calls in protected
;mode.
;   The combined code and data may occupy more than 64K provided that:
;
;1) Real-mode code is never placed in the program.  This follows since real-
;mode will not be able to handle the large offsets in a 32-bit segment.
;2) Segment constants are never used in the program.  For example, never use
;a statement like MOV AX,DGROUP.  The DOS program loader will not be able
;to perform relocation edits upon such statements if the segment exceeds 64K.
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;                            FLAT.INC Switches
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;   There are five switches that affect the way FLAT.INC will assemble.  All
;of these switches default to FALSE.  To implement the switch, set it TRUE
;(TRUE = 1) before the inclusion of FLAT.INC
;
;1) TASMMODE:
;
;   TASM programmers should use the TASMMODE switch.  The first two lines of
;code would then be:
;
;TASMMODE      EQU            TRUE                          ;TRUE = 1
;              INCLUDE        FLAT.INC
;
;2) SUBMODULE:
;
;   If multiple modules are being used, then use the SUBMODULE switch in
;all modules apart from the main module.  The first two lines of code in
;submodules should be:
;
;SUBMODULE     EQU            TRUE                          ;TRUE = 1
;              INCLUDE        FLAT.INC
;
;3) ZEROBASE:
;
;   Under default behavior of FLAT.INC, MAIN will receive SS = TSEG selector.
;TSEG is the single 32-bit segment into which all 32-bit code and data are to
;reside.  ESP will be set for a stack of 4096 (1000H) free bytes.  MAIN will
;also receive DS = TSEG selector; ES = FLAT selector (zero base); FS = DSEG
;selector; GS = DGROUP selector.  All segments have 4Gb limits except FS and
;GS which have limits of 64K.  The advantages of these segment settings are
;discussed below.
;   In some cases one might prefer DS = FLAT and ES = TSEG.  A switch for
;FLAT.INC is provided for such cases.  It is called ZEROBASE.  ZEROBASE
;should be used for the main module only.
;
;4) VCPI:
;
;   If both DPMI and VCPI are present, then FLAT.INC configures for DPMI.
;If VCPI is preferred in such cases, then use the VCPI switch.  VCPI should
;be used for the main module only.
;
;5) NOTRAP
;
;   Use the NOTRAP switch to disable XLIB exception trapping.  NOTRAP should
;be used for the main module only.
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

TRUE           EQU            1
FALSE          EQU            0

               IFDEF TASMMODE
DOTASM         =              TASMMODE
               ELSE
DOTASM         =              FALSE          ;Assemble for MASM
               ENDIF

               IFDEF SUBMODULE
DOSUBMODULE    =              SUBMODULE
               ELSE
DOSUBMODULE    =              FALSE          ;Current module assumed to be main
               ENDIF

               IFDEF ZEROBASE
DOZEROBASE     =              ZEROBASE
               ELSE
DOZEROBASE     =              FALSE          ;DS based at TSEG, ES based at zero
               ENDIF

               IFDEF VCPI
DOVCPI         =              VCPI
               ELSE
DOVCPI         =              FALSE          ;Default to DPMI
               ENDIF

               IFDEF NOTRAP
DONOTRAP       =              NOTRAP
               ELSE
DONOTRAP       =              FALSE          ;Default to exception trapping
               ENDIF

               .MODEL         LARGE,PASCAL,FARSTACK
               .386
               .387

               IFE DOTASM

               OPTION         NOKEYWORD:<PUSHD>             ;Redefine PUSHW and PUSHD to correct a bug in late versions of MASM
               OPTION         NOKEYWORD:<PUSHW>

PUSHW          MACRO IMMEDIATE16:REQ         ;PUSH immediate 16-bit data
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32:REQ         ;PUSH immediate 32-bit data
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               INCLUDE        XLIB.INC
               INCLUDELIB     XLIBE.LIB      ;Use XLIBE to trap exceptions

               ELSE

               MASM51
               QUIRKS

PUSHW          MACRO IMMEDIATE16:REST        ;PUSH immediate 16-bit data
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32:REST        ;PUSH immediate 32-bit data
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               INCLUDE        XLIBB.INC
               INCLUDELIB     XLIBEB.LIB     ;Use XLIBEB to trap exceptions

               ENDIF                         ;IFE DOTASM

               IFE DOSUBMODULE
               .STACK         200H           ;Need a very small stack
               .DATA
               .CODE
               .STARTUP

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   The following instructions resize (reduce) the memory block containing the
;program.  Under default link options the program will consume all available
;memory.  This will cause XLIB to fail for inability to allocate memory for
;itself.
;   The code below assumes that the initial SS:SP points to the end of the
;program.  This will indeed be the case under both MASM and TASM if FARSTACK
;is used on the .MODEL statement.
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

               MOV            AX,SP          ;SS:SP = end of program
               SHR            AX,4
               MOV            BX,SS
               ADD            BX,AX
               INC            BX            ;BX = first para. beyond program
               MOV            AX,ES         ;ES:0000 = first para. of program
               SUB            BX,AX         ;BX = program size in para.
               MOV            AH,4AH        ;Function to resize memory block
               INT            21H           ;Carry will be set if failure
               JNC            SHORT RESIZED
               MOV            SI,OFFSET RESIZEFAIL
               CALL           TELETYPE
               MOV            AX,4C01H      ;Failed to resize so terminate
               INT            21H
RESIZED:

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;The following instructions initialize the XLIB DOS extender.
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

               PUSHW          DSEG           ;Load XLIB data segment
               POP            DS
               ASSUME         DS:DSEG
               INT            11H            ;Get equipment list in AX
               TEST           AL,02H         ;See if FPU present
               JZ             SETIFLAGS
               FNINIT                        ;Initialize FPU
               FLDCW          FPUCW          ;Load XLIB FPU control word
               OR             OFLAGS,04H     ;Enable FPU save/restore
SETIFLAGS:
               IF DOVCPI
               OR             IFLAGS,01H
               ENDIF
               IF DONOTRAP
               OR             IFLAGS,02H
               ENDIF
               CALL           INITXLIB       ;Initialize XLIB
               OR             AX,AX          ;AX = 0 if success
               JZ             SHORT INITDONE
               MOV            SI,OFFSET INITFAIL
               CALL           TELETYPE
               MOV            CX,8
               CALL           TELETYPEHEX    ;Print error code in EAX
               MOV            SI,OFFSET NEWLINE
               CALL           TELETYPE
               MOV            AX,4C01H       ;Terminate
               INT            21H

INITDONE:      XOR            EAX,EAX        ;Assume DS to be based at zero
               IFE DOZEROBASE
               MOV            AX,FLATDSEL    ;Set ES to FLAT
               MOV            PMES,AX
               MOV            AX,TSEGDSEL    ;Set DS to TSEG
               MOV            PMDS,AX
               MOV            AX,TSEG
               ENDIF

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   The following instructions set EBX such that DS:EBX will point to the
;program segment prefix as of entry to MAIN and EAX will contain the base
;address of DS.  EDX will contain the base address of TSEG.
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

               SHL            EAX,4          ;Compute base address for DS
               XOR            EBX,EBX        ;Compute linear address of PSP
               MOV            BX,ES
               SHL            EBX,4
               SUB            EBX,EAX        ;Normalize address to protected-mode DS
               MOV            EDX,TSEG       ;Compute base address of 32-bit segment
               SHL            EDX,4

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   The follow instructions transfer execution to MAIN in 32-bit protected mode.
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

               PUSHD          OFFSET MAIN    ;Protected-mode target address
               CALL           ENTERPM        ;Transfer control to target
               MOV            AX,4C00H       ;Terminate upon return
               INT            21H

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Console routines and data for this include file.
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;Write string at CS:SI in teletype mode.
TELETYPE       PROC NEAR
               PUSHA
               MOV            AH,0EH         ;Function number
               MOV            BX,0007H       ;Zero page (BH), foreground = white (BL)
CHARLOOP:      MOV            AL,CS:[SI]
               INC            SI
               OR             AL,AL
               JZ             SHORT EXIT
PRINTCHAR:     INT            10H
               JMP            SHORT CHARLOOP
EXIT:          POPA
               RET
TELETYPE       ENDP

;Print EAX as hexadecimal in teletype mode.  Call with CX = number of hex
;digits to print.
TELETYPEHEX    PROC NEAR
               PUSHAD
               MOV            BX,CX
               MOV            EDX,EAX
MAINLOOP:      AND            AL,0FH
               ADD            AL,48
               CMP            AL,57
               JBE            SHORT PUSHCHAR
               ADD            AL,7
PUSHCHAR:      PUSH           AX
               SHR            EDX,4
               MOV            AL,DL
               DEC            BX
               JNZ            SHORT MAINLOOP
               MOV            AH,0EH         ;Function number
               MOV            BL,07H         ;Zero page (BH), foreground = white (BL)
WRITELOOP:     POP            DX
               MOV            AL,DL
               INT            10H
               DEC            CX
               JNZ            SHORT WRITELOOP
               POPAD
               RET
TELETYPEHEX    ENDP

RESIZEFAIL     DB "Error:  Failed to resize program memory block.",13,10,0
INITFAIL       DB "XLIB initialization error: ",0
NEWLINE        DB 13,10,0

@CurSeg        ENDS

               ENDIF                         ;IFE DOSUBMODULE

TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

               IF DOTASM
               LARGESTACK
               ENDIF

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;                          Address Normalization
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;   The default segment settings allow the programmer to write code that is
;very approximate to flat-model code.  In the true flat-model, all segments
;have base of zero  In the default FLAT.INC model, CS, SS, and DS have base
;equal to 16*TSEG.  Code for this model will differ from that of the true flat
;model only with references to data located outside of TSEG.  Offsets to such
;addresses must be normalized by subtracting the segment base address.  For
;example, the color screen would be accessed in the true flat model with
;offset B8000H.  In the approximate flat model the offset should be adjusted
;to B8000-16*TSEG.  The same normalization must be done to addresses returned
;by XLIB memory allocation routines.  The  following procedures are included
;to perform such normalization:
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

               IFE DOSUBMODULE

;Allocate extended memory and return normalized address.  Call with EAX = size
;of block in bytes.  Error code returned in EAX.  Block handle returned in EBX.
;Number of allocated bytes returned in ECX.  Block is always at least as large
;as requested size.  Address of allocated block returned in EDX.  Address is
;always normalized to DS.  Call with EAX = 0 to get largest available block
;size in ECX.
GETFLATMEM     PROC NEAR
               IFE DOZEROBASE
               PUSHD          OFFSET NORMADDRESS            ;PUSH return address
               ENDIF
               JMP            PMGETMEM
GETFLATMEM     ENDP

;Release previously allocated extended memory block.  Call with block handle
;in EAX.  Error code returned in EAX.  Extended memory is automatically freed
;upon termination.
FREEFLATMEM    PROC NEAR
               JMP            PMFREEMEM
FREEFLATMEM    ENDP

;Allocate DOS memory and return normalized address.  Call with EAX = size of
;block in bytes.  Error code returned in EAX.  Block handle returned in EBX.
;Number of allocated bytes returned in ECX.  Block is always at least as large
;as requested size.  Address of allocated block returned in EDX.  Address is
;always normalized to DS.  Call with EAX = 0 to get largest available block
;size in ECX.
GETFLATDOSMEM  PROC NEAR
               IFE DOZEROBASE
               PUSHD          OFFSET NORMADDRESS            ;PUSH return address
               ENDIF
               JMP            PMGETDOSMEM
GETFLATDOSMEM  ENDP

;Release previously allocated DOS memory block.  Call with block handle in
;EAX.  Error code returned in EAX.  DOS memory is automatically freed upon
;termination.
FREEFLATDOSMEM PROC NEAR
               JMP            PMFREEDOSMEM
FREEFLATDOSMEM ENDP

               IFE DOZEROBASE

;Normalize logical address in EDX.
NORMADDRESS    PROC NEAR
               OR             EAX,EAX                       ;See if an error occurred
               JNZ            SHORT EXIT
               PUSH           DS
               MOV            DS,CS:CSDSEGSEL               ;Load DSEG selector
               ASSUME         DS:DSEG
               MOVZX          EAX,TSEGVAL                   ;Load TSEG
               SHL            EAX,4                         ;Compute base address
               SUB            EDX,EAX
               XOR            EAX,EAX                       ;Set error code back to zero
               POP            DS
               ASSUME         DS:TSEG
EXIT:          RET
NORMADDRESS    ENDP

               ENDIF                                        ;IFE DOZEROBASE

               ENDIF                                        ;IFE DOSUBMODULE

               IFE DOTASM
               EXTERNDEF PASCAL GETFLATMEM:NEAR
               EXTERNDEF PASCAL GETFLATDOSMEM:NEAR
               EXTERNDEF PASCAL FREEFLATMEM:NEAR
               EXTERNDEF PASCAL FREEFLATDOSMEM:NEAR
               ELSE
               GLOBAL PASCAL GETFLATMEM:NEAR
               GLOBAL PASCAL GETFLATDOSMEM:NEAR
               GLOBAL PASCAL FREEFLATMEM:NEAR
               GLOBAL PASCAL FREEFLATDOSMEM:NEAR
               ENDIF
