/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"
#include "fg2a.h"
/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*P_f)(double x);
double (*P_g)(double x);

   int    n =  2*1000;
double    a =      0.;
double    b =      1.;
double   dx =     .05;
double step =    .001;
double    M =      0.;
/*-------------------------------- PROGRAM ---------------------------------- */
 clrscrn();
 printf(" Compute the volume V of the solid of revolution          \n");
 printf(" generated by revolving R about the x-axis              \n\n");
 printf(" Draw the region R bounded by the graph of f,             \n");
 printf("  the graph of g, and the vertical lines x = a and x = b\n\n");
 printf(" Let  f and g be continous on [%.3lf,%.3lf].\n\n", a, b);
 printf(" f : x-> %s\n\n", feq);
 printf(" g : x-> %s\n\n", geq);
 printf(" To see the graph of f and g, open the file \"f_Df.plt\" with Gnuplot.\n\n");

             P_f = f;
             P_g = g;          /* plot [xmin:xmax] [ymin:ymax] */
            gplt_fgab(-2,      /* xmin  */
                       2,      /* xmax  */
                      -3,      /* ymin  */
                       3,      /* ymax  */
                       a,
                       b,
                     feq,
                     geq,
           (*P_f),
           (*P_g)
                       );
 getchar();

 clrscrn();
 printf(" Draw a typical vertical rectangle. \n\n");
 printf(" To see the graph of f, open the file \"f_Df.plt\" with Gnuplot.\n\n\n\n\n");

 printf(" The thickness of washer :                                      dx\n");
 printf(" The outer radius        :      %s        \n",feq);
 printf(" The inner radius        :                       %s        \n",geq);
 printf(" The volume              : Pi [(%s)**2 - (%s)**2] dx\n\n\n", feq, geq);
 printf(" Volume of a washer = Pi [(outer radius)**2 - (inner radius)**2] (thickness)");
 printf(" \n\n\n\n\n");

             P_f = f;
             P_g = g;          /* plot [xmin:xmax] [ymin:ymax] */
gplt_SolidRevolDiskfg(-2,      /* xmin  */
                       2,      /* xmax  */
                      -3,      /* ymin  */
                       3,      /* ymax  */
                       a,
                       b,
                      dx,
                    step,
                  (*P_f),
                  (*P_g)
                       );
 getchar();

 clrscrn();
 printf(" If we apply \n\n\n");
 printf("    (%.3lf\n", a);
 printf(" int(      \n");
 printf("    (%.3lf%\n\n\n", b);

 printf(" to  : Pi [(%s)**2 - (%s)**2] dx\n\n\n", feq, geq);
 printf(" We obtain a limit of sums of volumes of washers.\n\n\n");

               P_f = Vwasher;
 M = simpson((*P_f),a,b,n);

 printf("    (%.3lf\n", a);
 printf(" int(     Pi[(%s)**2 - (%s)**2] dx = %.12lf\n", feq,  geq, M);
 printf("    (%.3lf\n", b);

 printf("\n Press return to continue");
 getchar();

 return 0;
}

