/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <conio.h>
#include <dos.h>


#if ! defined(__TURBOC__)
#include <time.h>		/*  for clock_t and clock()  */


/*  void sound ( short frequency, long duration )
 *
 *  Makes the PC speaker emit a sound at `frequency' Herz for approximately
 *  `duration' milliseconds.
 */
void sound ( short frequency, long duration )
{
    clock_t start;

    duration *= CLK_TCK;
    duration /= 1000;
    frequency = (short) (1193180L / (long) frequency);
    (void) outp ( 0x43, 182 );
    (void) outp ( 0x42, frequency & 0xFF );
    (void) outp ( 0x42, frequency >> 8 );

    start = clock();
    (void) outp ( 0x61, inp ( 0x61 ) | 3 );
    while ( clock() - start < duration ) ;
    (void) outp ( 0x61, inp ( 0x61 ) & 0xFC );
}

#endif


/***
 *
 *  Function beep :   Emit a beep.
 *
 ***/

void beep(void)
{
#define FREQ  1000
#define DELAY 50

#if defined(__TURBOC__)
  sound(FREQ);
  delay(DELAY);
  nosound();
#else
  sound( FREQ, DELAY );
#endif

#undef FREQ
#undef DELAY
}



/***
 *
 *  Function buzzer:   Emit a buzzer sound.
 *
 ***/

void buzzer(void)
{
#define FREQ  50
#define DELAY 150

#if defined(__TURBOC__)
  sound(FREQ);
  delay(DELAY);
  nosound();
#else
  sound( FREQ, DELAY );
#endif

#undef FREQ
#undef DELAY
}
