#include "date.h"
#include "bctools.h"
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>


/***
 *  Function    :   input_time
 *
 *  Description :   Input hours and minutes at given position.
 *
 *  Parameters  :   in   int *  hour
 *                  in   int *  min
 *                  in   int *  sec
 *                  in   int    xpos
 *                  in   int    ypos
 *
 *  Decisions   :   Default = current hour and minutes
 *                            if minutes are not given, 0 is assumed
 *		    Colors = white on blue
 *		
 *  Return      :    0 if OK
 *                  -1 if no input
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

int input_time( int *hour , int *min , int xpos , int ypos )

{ struct text_info info ;
  struct time now ;

  gettextinfo( &info ) ;     /*  Save current window settings  */

  window( xpos , ypos , xpos+6 , ypos ) ;
  textbackground(BLUE) ;
  clrscr() ;
  textcolor(WHITE) ;

  gettime( &now ) ;        /* Get current time */

  for (;;) { char buffer[8] ;
	     int i ;

	     *hour = now.ti_hour ;
	     *min  = now.ti_min ;
	     gotoxy( 2 , 1 ) ;
	     cprintf( "%2d:%02d" , *hour , *min ) ;
	     gotoxy( 2 , 1 ) ;

	     i = getch() ;
	     if ( i == ESC ) return -1 ;
	     if ( i == RETURN ) break ;

	     *min = 0 ;
	     clreol() ;
	     ungetch( i ) ;
	     *buffer = 6 ;
	     cgets( buffer ) ;
	     i = sscanf( buffer+2 , "%d%[^0-9]%d" , hour , NULL , min ) ;
	     if ( i <= 0 ) return -1 ;
	     if ( istimevalid(*hour , *min, 0) )
		{ gotoxy( 2 , 1 ) ;
		  cprintf( "%2d:%02d" , *hour , *min ) ;
 		  break ;
		}
	     else beep() ;
	   }

	       /*  Restore previous window settings  */
  window( info.winleft , info.wintop , info.winright , info.winbottom ) ;
  textattr( info.attribute ) ;

  return 0 ;
}
