#include "bctools.h"
#include <conio.h>



/***
 *
 *  Function border :   Draw double lines border.
 *
 *  Decisions :         If right or bottom = 0,
 *                      window limit is assumed.
 *
 ***/

void border( int left, int top, int right, int bottom )

{ int i, scroll = _wscroll;
  struct text_info info;

  gettextinfo( &info );     /*  Get current window settings  */

  if ( ! left   ) left = 1;
  if ( ! top    )  top = 1;
  if ( ! right  ) right  = info.winright - info.winleft + 1;
  if ( ! bottom ) bottom = info.winbottom - info.wintop + 1;

  _wscroll = 0;    /* Disable scrolling */

  gotoxy( left, top );
  putch( '' );
  for ( i = left + 1; i < right; i++ ) putch( '' );
  putch( '' );

  for ( i = top + 1; i < bottom; i ++ )
      {
	gotoxy( left, i );
	putch( '' );
	gotoxy( right, i );
	putch( '' );
      }

  gotoxy( left, bottom );
  putch( '' );
  for ( i = left + 1; i < right; i++ ) putch( '' );
  putch( '' );

  _wscroll = scroll;    /* Restore scrolling */
}
