**************************************
* TIME CLOCK UPDATE TO PAYROLL
* BY TIM SCHROEDER
* 316-241-0303
* COPYRIGHT 1996 TIM SCHROEDER
* ALL RIGHTS RESERVED
*************************************
* this file is distributed in source
* code form to allow users to link
* my payroll to there POS systems
* Let me know of any success stories
**************************************
CLOSE DATA
mtmpf1 = SYS(3)
#IF 'Windows' $ VERSION()
* Test if timeclok is runing
x=ddesetoption('SAFETY',.F.)
x=DDEINITIATE('Timeclok','SYSTEM')
IF NOT x = -1
  llretval=ynalert('Timeclok is running option not allowed.' ,3)
  mgclokruning = .T.
  x = DDETERMINATE('Timeclok')
  DO cleanup
ENDIF
#ENDIF
saystr = 'This option will update hours '
saystr=saystr+'from time clock punches.'
IF NOT popwarn(saystr)
  DO cleanup
ENDIF
=noteit('/Time clock update/')
IF USED("employee")
  SELECT employee
  SET ORDER TO TAG "Name"
ELSE
  SELECT 0
  USE (LOCFILE("employee.dbf","DBF","Where is employee?"));
    AGAIN ALIAS employee ;
    ORDER TAG "name"
ENDIF

IF USED("empl_job")
  SELECT empl_job
  SET ORDER TO TAG emplno
ELSE
  SELECT 0
  USE (LOCFILE("empl_job.dbf","DBF","Where is empl_job?"));
    AGAIN ALIAS empl_job INDEX empl_job.cdx;
    ORDER TAG emplno
ENDIF
IF USED("hours")
  SELECT HOURS
  SET ORDER TO TAG DATE
ELSE
  SELECT 0
  USE (LOCFILE("HOURS.dbf","DBF","Where is hours?"));
    AGAIN ALIAS HOURS ;
    ORDER TAG DATE
ENDIF

******** SYSTABLE
IF USED('SYSTABLE')
  SELECT systable
ELSE
  SELECT 0
  USE systable
ENDIF
SET FILTER TO id = 'RATES'
SET ORDER TO TAG ORDER
*AFTER MANY ATTEMPTS GO GET THIS APP TO
* WORK I HAVE DECIDED TO USE A SEPERATE TABLE
* FOR OT.
IF USED('OT')
  SELECT ot
ELSE
  SELECT 0
  USE ot
ENDIF
SET ORDER TO TAG emplno

******* PUNCHES
IF USED('punches')
  SELECT punches
  SET ORDER TO TAG in_date
ELSE
  SELECT 0
  USE (LOCFILE((mgclockdr)+'punches',"DBF","Where is punches?"));
    AGAIN ALIAS punches ;
    ORDER TAG in_date
ENDIF

SELECT HOURS


** DECIDE WHAT PERIOD USER WANTS
lcperstr =tcperiod() && RETURNS PERIOD OR WEEKLY

*** set a filter in hours
SET FILTER TO hours.emplno = punches.emplno
*** then add to that filter
IF .NOT. dtfilter(lcperstr)
  ** cancel selected in dtfilter
  DO cleanup
ENDIF
*** revised method 1.4
*** users thought they needed to change the filter
*** in dtfilter.prg
*** this was setting a filter in hours.dbf so that overtime
*** was not calculated properly. Reset filter in hours
SET FILTER TO hours.emplno = punches.emplno
DO CASE
  * dtfilter sets a filter to the dates allright
  * but the carryover hours are filtered out for
  * overtime calculations (week1)
CASE lcperstr = 'PERIOD'
  mgstartdt = predow(mgbegdayno,mgstartdt)
ENDCASE
INDEX ON emplno+DTOC(DATE)+ALLTRIM(jobdesc) ;
  TO (mtmpf1)

SELECT punches
SET FILTER TO in_date >= mgstartdt AND;
  in_date <= mgenddt AND NOT UPDATED

* use this filter if dtfilter not called
*SET FILTER TO in_date >= mgperbeg AND;
*  in_date <= mgperend AND NOT UPDATED

REPLACE ALL errstr WITH ''
REPLACE ALL errcode WITH ''
iserror = .F.
GO TOP
*******************************************
* Test for invalid records
******************************************
SCAN
  WAIT WINDOW NOWAIT 'Checking records'
  mstr = emplno+DTOC(in_date)+ALLTRIM(jobdesc)
  SELECT HOURS
  SEEK mstr
  IF FOUND()
    SELECT punches
    * Dupe
    REPLACE punches.errcode WITH 'D'
    REPLACE errstr WITH ;
      'Hours in Payroll allready'
    iserror = .T.
  ENDIF
  * check that description still exists
  SELECT empl_job
  LOCATE FOR jobdesc = punches.jobdesc .AND. ;
    emplno = punches.emplno

  IF NOT FOUND()
    SELECT punches
    * rate not found in employee job file
    REPLACE punches.errcode WITH 'R'
    REPLACE errstr WITH ;
      'Rate not found in employee job file.'
    iserror = .T.
  ELSE
    SELECT punches
    REPLACE punches.rate WITH empl_job.rate
    REPLACE punches.amount WITH empl_job.rate * punches.tot_time
  ENDIF

  * if a tip record exists
  IF punches.istipped AND NOT EMPTY(punches.tips)
    SELECT empl_job
    LOCATE FOR jobdesc = 'TIPS' .AND. ;
      emplno = punches.emplno
    IF NOT FOUND()
      SELECT punches
      * TIPS not found in employee job file
      REPLACE punches.errcode WITH 'X'
      REPLACE errstr WITH ;
        'Tips not assigned to employee.'
      iserror = .T.
    ENDIF
  ENDIF
  SELECT punches
  DO CASE
  CASE EMPTY(out_date)
    * not clocked out
    REPLACE punches.errcode WITH 'O'
    REPLACE errstr WITH ;
      'No clock out.'
    iserror = .T.
  CASE tot_time > 22 OR tot_time < 0
    * over maximum time limit probable error
    REPLACE punches.errcode WITH 'T'
    REPLACE errstr WITH ;
      'Hours out of range in punches'
    iserror = .T.
  CASE EMPTY(jobdesc)
    REPLACE punches.errcode WITH 'J'
    REPLACE errstr WITH ;
      'No job desc in punches.'
    iserror = .T.
  ENDCASE
ENDSCAN

*****************************************
* If error found print an exception report
*******************************************
IF iserror
  saystr = 'Error found! Ready to print the exception report.'
  IF ynalert(saystr,1)
    SET FILTER TO in_date >= mgstartdt AND;
      in_date <= mgenddt AND NOT UPDATED AND;
      NOT EMPTY(errcode)
    xvar = prnwhere(1)
    IF xvar = 1
      xvar = 'print'
    ELSE
      xvar = 'screen'
    ENDIF

    IF _DOS

      DO CASE
      CASE mgcontrol AND xvar='print'  && send control codes
        SET CONSOLE OFF
        ??? mgcpi10
        ??? mgport
        REPORT FORM timeexc TO PRINTER
        SET CONSOLE ON
        ??? mgsetup
      CASE NOT mgcontrol AND xvar='print' && no control codes
        mstr = 'Set Your Printer up for the Exceptions Report'
        IF popwarn(mstr)
          REPORT FORM timeexc TO PRINTER
        ENDIF
      CASE xvar='screen'
        REPORT FORM timeexc PREVIEW
      ENDCASE
    ENDIF

    IF _WINDOWS
      IF xvar = 'print'
        SET CONSOLE OFF
        WAIT WINDOW NOWAIT 'This report will use Portrate 11 inch'
        REPORT FORM timeexc TO PRINTER PROMPT
        * Windows likes to change directories without warning
        SET DEFAULT TO &mgprogdir
        SET CONSOLE ON
        WAIT CLEAR
      ELSE

        REPORT FORM timeexc PREVIEW
      ENDIF
    ENDIF

  ELSE
    =ynalert('I will not update while errors are found',3)
    DO cleanup
  ENDIF && YNALERT
  =ynalert('Please fix errors and try again',3)
  DO cleanup
ENDIF && ISERROR
****************************************
*** continue with the update
****************************************
saystr = 'Delete records in time clock after update?'
CLEAR TYPEAHEAD
lldelit = .F.
* do not allow a choice for now.
*if ynalert(saystr,2)
*  lldelit = .t.
*endif
SELECT empl_job
SET FILTER TO emplno = punches.emplno
SELECT punches
GO TOP
SELECT empl_job
SELECT punches
WAIT WINDOW NOWAIT 'Updating hours'
SCAN
  mstr = emplno+DTOC(in_date)+ALLTRIM(jobdesc)
  SELECT empl_job
  LOCATE FOR jobnum = punches.jobnum
  SELECT HOURS
  SEEK mstr
  IF FOUND()
    * add to the hours already posted
    * payroll allows only 1 posting per day
    * punches allows unlimited posting per day
    REPLACE emplno WITH punches.emplno
    REPLACE HOURS WITH punches.tot_time+hours.hours
    REPLACE rate WITH punches.rate
    REPLACE amount WITH hours.rate * hours.hours
  ELSE
    SELECT HOURS
    APPEND BLANK
    REPLACE emplno WITH punches.emplno
    REPLACE DATE WITH punches.in_date
    REPLACE HOURS WITH punches.tot_time
    REPLACE jobnum WITH punches.jobnum
    REPLACE jobdesc WITH punches.jobdesc
    REPLACE rate WITH punches.rate
    REPLACE amount WITH punches.amount
    REPLACE useforot WITH empl_job.useforot
    REPLACE issalary WITH empl_job.issalary
    REPLACE istip WITH empl_job.istip
    REPLACE ishours WITH empl_job.ishours
    REPLACE isbonus WITH empl_job.isbonus
    REPLACE isvac WITH empl_job.isvac
    REPLACE iscomp WITH empl_job.iscomp
    REPLACE isother WITH empl_job.isother
    REPLACE nonmin WITH empl_job.nonmin
  ENDIF
  *** PROCESS OVERTIME
  SCATTER MEMVAR
  DO ot_handler

  * add tip record
  IF NOT EMPTY(punches.tips)
    SELECT empl_job
    LOCATE FOR emplno = punches.emplno ;
      .AND. istip
    SELECT HOURS
    mstr1 = emplno+DTOC(punches.in_date)+;
      ALLTRIM(empl_job.jobdesc)
    SEEK mstr1
    IF FOUND()
      REPLACE amount WITH punches.tips + amount
    ELSE
      APPEND BLANK
      REPLACE emplno WITH punches.emplno
      REPLACE DATE WITH punches.in_date
      REPLACE HOURS WITH 0.00
      REPLACE jobnum WITH empl_job.jobnum
      REPLACE jobdesc WITH empl_job.jobdesc
      REPLACE rate WITH 0.00
      REPLACE amount WITH punches.tips

      REPLACE useforot WITH empl_job.useforot
      REPLACE issalary WITH empl_job.issalary
      REPLACE istip WITH empl_job.istip
      REPLACE ishours WITH empl_job.ishours
      REPLACE isbonus WITH empl_job.isbonus
      REPLACE isvac WITH empl_job.isvac
      REPLACE iscomp WITH empl_job.iscomp
      REPLACE isother WITH empl_job.isother
      REPLACE nonmin WITH empl_job.nonmin
    ENDIF
  ENDIF
  SELECT punches
  REPLACE UPDATED WITH .T.
  IF lldelit
    =poptalk(1,1,'Delete punches')
    DELETE
  ENDIF

ENDSCAN
IF WEXIST('poptalk')
  RELEASE WINDOW poptalk
ENDIF
saystr = 'Update done. Please check your reports. '
saystr = saystr + 'Note: Other taxable, Comissions not added.'
IF _WINDOWS
  =ynalert(saystr,3)
ELSE
  =popalert('Notice',saystr)
ENDIF
DO cleanup
******************************************************
PROCEDURE cleanup
CLOSE DATA
IF FILE(mtmpf1+'.ndx')
  DELETE FILE (mtmpf1+'.ndx')
ENDIF
RETURN TO MASTER
****************************************
**   OVERTIME CALCULATION PROCEDURE
**   updates ot.dbf
****************************************
PROCEDURE ot_handler
*var for start of week
*dtweekstart=predow(daynum('tuesday'),hours.date)
*mod for version 1.1
dtweekstart=predow(mgbegdayno,hours.date)
dtweekend=nextdow(hours.date,IIF(mgbegdayno=1,7,mgbegdayno-1))
* IF I HAD JUST PUT THIS CASE IN FROM THE BEGINNING
* I WOULD HAVE SAVED A LOT OF COMPLEXITY
DO CASE
CASE NOT m.useforot
  RETURN
  *left some of the old case statements in
  * just in case a screwed up systable record
CASE m.jobdesc = 'TIPS'
  RETURN
CASE m.jobdesc = 'OTHER TAXABLE'
  RETURN
CASE m.jobdesc = 'COMISSION'
  RETURN
ENDCASE
STORE RECNO() TO m.lastrec
SUM hours.hours FOR;
  hours.date >=dtweekstart AND ;
  hours.date <= dtweekend AND NOT DELETED();
  AND useforot;
  TO tothours

* take out the day just added
tothours = tothours - m.hours

** if any salary hours ot is disallowed
LOCATE FOR issalary = .T. .AND. ;
  hours.date >=dtweekstart .AND. ;
  hours.date <= dtweekend .AND. ;
  hours.emplno = m.emplno
IF FOUND()
  IF tothours > 40
    * warn user in case salary is an orphan
    * record eg. person has gone from salary
    * to regular pay without deleting salary
    * record.
    WAIT WINDOW NOWAIT;
      'No overtime for '+ALLTRIM(punches.last)+;
      ' because salary record found in jobs.'
  ENDIF
  m.salaried = .T.
ELSE
  m.salaried = .F.
ENDIF
GO m.lastrec

** here we go !!!!
***********************************
* this app records all hours in hours
* even though some of those hours may
* be may be overtime. The reports take
* care of this situation
************************************
*take care of some preliminary stuff
IF tothours+m.hours > 40 ;
    AND NOT m.salaried OR tothours > 40 ;
    AND NOT m.salaried
  *set up for a posting
  m.maxdesc = getmaxdesc()
  * get the rate and description for the job
  * worked most by this employee this is the
  * rate this app uses
  SELECT empl_job
  LOCATE FOR emplno = m.emplno AND;
    jobdesc = m.maxdesc

  * OVERTIME DEFAULT RECORD
  *SELECT systable
  *LOCATE FOR PROMPT = 'OVERTIME'
  *IF NOT FOUND()
  *  WAIT WINDOW 'OVERTIME RECORD MUST BE ADDED TO SYSTABLE'+;
  *    ' PLEASE CONTACT SYSTEM ADMINISTRATOR'
  *ENDIF
  SELECT HOURS
  GO m.lastrec
ENDIF
*ver 1.3 added case instead of if else
DO CASE
CASE tothours >= 40  && all m.hours to overtime
  SELECT ot
  LOCATE FOR ;
    wkstart = dtweekstart AND emplno = m.emplno

  IF NOT FOUND()
    APPEND BLANK
    REPLACE emplno WITH m.emplno
    REPLACE wkstart WITH dtweekstart
    REPLACE wkend WITH dtweekend
    REPLACE HOURS WITH m.hours
    **********************************************
    * this program uses at least minumim wage
    * as a basis for ot calculation.
    **********************************************
    REPLACE rate WITH IIF(empl_job.rate > mgminwage,;
      empl_job.rate * 1.5,mgminwage*1.5)
    REPLACE maxjobnum WITH empl_job.jobnum
    REPLACE maxdesc WITH empl_job.jobdesc

  ELSE
    ** replacements for found record
    *REPLACE ot.hours WITH ot.hours + m.hours
    *Above line can cause double add of overtime since
    * this program allows overtime to be added on each pass
    * eg. 2 or more punches on the same day with both going to
    * overtime would cause double add of overtime.
    REPLACE ot.hours WITH tothours+m.hours-40
    */TS 6-15-98 MOD NEXT LINE
    REPLACE rate WITH IIF(empl_job.rate > mgminwage,;
      empl_job.rate * 1.5,mgminwage*1.5)
    REPLACE maxjobnum WITH empl_job.jobnum
    REPLACE maxdesc WITH empl_job.jobdesc
    IF ot.hours < 0
      DELETE
    ENDIF
  ENDIF  && if found()

  *ENDIF tothours  > 40

CASE tothours + m.hours > 40
  **** all hours not to ot
  m.othours = (tothours + m.hours)-40
  IF m.othours < 0
    m.othours = 0
  ENDIF
  SELECT ot
  * find the overtime record IN OT
  LOCATE FOR ;
    wkstart = dtweekstart AND emplno = m.emplno

  IF NOT FOUND()
    APPEND BLANK
  ENDIF
  REPLACE emplno WITH m.emplno
  REPLACE wkstart WITH dtweekstart
  REPLACE wkend WITH dtweekend
  REPLACE HOURS WITH m.othours
  REPLACE rate WITH IIF(empl_job.rate > mgminwage,;
    empl_job.rate * 1.5,mgminwage*1.5)
  REPLACE maxjobnum WITH empl_job.jobnum
  REPLACE maxdesc WITH empl_job.jobdesc
ENDCASE
***** end of ot handling

*************************************************
* Gets the description of the job worked most by
* this employee for this week.
*************************************************
FUNCTION getmaxdesc
SELECT systable
*COUNT FOR id = 'RATES' TO tot_job_num
* VERSION 2 MOD Due to error in vac being selected
*tot_job_num = 6
* new methoid for shareware ver
oldfilter = FILTER()
SET FILTER TO useforot
COUNT FOR useforot TO tot_job_num
DIMENSION  ajobs[tot_job_num,2]
STORE 0 TO ajobs
GO TOP
* fill array with hours and the jobnum
FOR x = 1 TO tot_job_num
  SELECT HOURS
  ajobs[x,2] = systable.order
  SUM HOURS FOR hours.jobnum = systable.order;
    AND hours.date >= dtweekstarts;
    AND hours.date <= dtweekend;
    AND hours.emplno = m.emplno;
    TO ajobs[x,1]

  SKIP 1 IN systable
ENDFOR
* get the max from array
=ASORT(ajobs,1)
SELECT systable
LOCATE FOR ORDER = ajobs[tot_job_num,2]
mreturnval = systable.prompt
SET FILTER TO &oldfilter
RETURN mreturnval

