@ECHO OFF
REM    Master Boot Sector Write
IF "%1" == "" GOTO DefaultFileName
IF NOT EXIST %1 GOTO NoFile
IF EXIST MBS.BIN DEL MBS.BIN
REN %1 MBS.BIN
SET RENAME=Y

:DefaultFileName
IF NOT EXIST MBS.BIN GOTO NoMbsFile
MBSW_.COM
if errorlevel 4 goto error4
if errorlevel 3 goto error3
if errorlevel 2 goto error2
if errorlevel 1 goto error1
GOTO CleanUp

:NoFile
ECHO MBSW.BAT: Error: There is no file named %1
GOTO TheEnd

:NoMbsFile
ECHO MBSW.BAT: Error: there is no file named MBS.BIN
GOTO CleanUp

:error1
ECHO MBSW.BAT: Error: unable to open file MBS.BIN
ECHO Maybe the file does not exist; or maybe the file is being used
ECHO by another program; or maybe there are too many open files.
GOTO CleanUp

:error2
ECHO MBSW.BAT: Error: unable to read any data from file MBS.BIN
ECHO Maybe the file has a size of 0 and does not contain any data.
GOTO CleanUp

:error3
ECHO MBSW.BAT: Error: read some but not enough data from file MBS.BIN
ECHO MBSW_.COM needs to read 512 bytes. Maybe the file is smaller than 512
ECHO bytes.
GOTO CleanUp

:error4
ECHO MBSW.BAT: Error: unable to write master boot sector to the hard drive
ECHO maybe you have an operating system or antivirus TSR which
ECHO does not allow programs to change the master boot sector
GOTO CleanUp

:CleanUp
IF NOT "%RENAME%" == "Y" GOTO TheEnd
REN MBS.BIN %1
SET RENAME=

:TheEnd
