/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*       Initialization and some     */
/*           data structures         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


struct kint {
		  	 unsigned char nconst;
		  	 unsigned char nmodf;
  		     LPSTR descr;
 			 LPSTR constnam;
	   	    };

struct nodet{
             char item;
             unsigned char val;
             unsigned char left;
             unsigned char right;
            } ;

struct treet{
             struct nodet node[256];
             char id[64][10];
             float constant[32];
             int nnode,
                 nnum,
                 nid,
                 nsub,
                 npro,
                 nmodf,
                 nconst,
                 revers;
             char descr[64];
            } ;

struct opt {
            int dyn;
            long pfo;
	        double	endtime;
            double	reltol;
            double	abstol;
            double	hrcz;
            int adams;
            int bdf;
            int ss;
            int debug;
            int txt;
            int structan;
            int staban;
            int stdela;
            int nonela;
            int stdcc;
            int noncc;
            int dat;
            int datsep;
            int datwidth;
            int dattit;
            int datmca;
            int datss;
            int quotes;
            int append;
			char	timeu[32];
			char	concu[32];
            int scan;
            int scanlog;
            unsigned long scandens;
           };

struct plt{
           int type;		/* 0 for 2d, 1 for 3d */
           int file;		/* 0 for dynamics, 1 for steady state */
           int x;			/* column for x */
           int y[10];		/* columns for y */
           int z;			/* column for z */
           int ny;			/* number of y variables */
           int logx;		/* 1 if log x axis */
           int logy;		/* 1 if log y axis */
           int logz;		/* 1 if log z axis */
           int lines;		/* 1 if points connected by lines */
           int colour;		/* 1 if colour to be used */
           int hidden;		/* 1 if hidden line removal */
           int contour;		/* 1 if contour plots on base */
          };

struct ou {
           LPSTR title;
           unsigned int idx;
          };

struct sp{
          int idx;
          LPSTR title;
	      double low;
	      double high;
	      unsigned long dens;
	      int log;
	      int lidx;
	      int linkedto;
	      double factor;
	      int operation;
	     };

extern GLOBALHANDLE hMetname;								/* handle to memory block w/ metname	*/
extern GLOBALHANDLE hStepname;								/* handle to memory block w/ stepname	*/
extern GLOBALHANDLE hStoiu;									/* handle to memory block w/ stoiu		*/
extern GLOBALHANDLE hSto;									/* handle to memory block w/ stoi		*/
extern GLOBALHANDLE hLoop;									/* handle to memory block w/ loop		*/
extern GLOBALHANDLE hParams;								/* handle to memory block w/ params		*/
extern GLOBALHANDLE hKtype;									/* handle to memory block w/ ktype		*/
extern GLOBALHANDLE hRstr;									/* handle to memory block w/ rstr		*/
extern GLOBALHANDLE hOutpEl;								/* handle to memory block w/ outpel		*/
extern GLOBALHANDLE hStrPool;								/* handle to memory block w/ strings	*/
extern GLOBALHANDLE hTree;									/* handle to memory block w/ trees		*/
extern GLOBALHANDLE hTreeStr;								/* handle to memory block w/ tree str	*/
extern GLOBALHANDLE hTmpF;									/* handle to memory block w/ temp files	*/

extern char (huge *metname)[NAME_L];						/* pointer to work with metname array	*/
extern char (huge *stepname)[NAME_L];						/* metabolite names						*/
extern int		huge *stoiu;								/* pointer to work with stoiu array		*/
extern int		huge *stoi;									/* pointer to work with stoi array		*/
extern unsigned char (huge *loop)[MAX_STEP][MAX_MET];		/* def. of modification loops			*/
extern int		(huge *rstr)[MAX_STEP][MAX_MOL];			/* order of substrates and products		*/
extern char	topname[256];									/* title for the topology				*/
extern char stepstr[MAX_STEP][256];						/* array to hold description of steps	*/
extern double 	huge *params[MAX_STEP];						/* ptr to parameters for each rate eq.	*/
extern DWORD	sizeparam;									/* size of paameters memory block		*/
extern DWORD	sizeoutp;									/* size of outpel memory block			*/
extern DWORD	sizestrp;									/* size of StrPool memory block			*/
extern DWORD	sizestra;									/* size of allocated strings in StrPool	*/
extern DWORD	sizespar;
extern DWORD	sizetr;										/* size of allocated strings in TreeStr	*/
extern unsigned char	revers[MAX_STEP];					/* 1 if reaction is reversible			*/
extern int		kinetu[MAX_STEP];							/* type of kinetics (user numb.)		*/
extern int		kfl[MAX_STEP];								/* flags for input of user-def.kinetics */
extern int		intmet[MAX_MET];							/* 1 if internal metabolite				*/
extern double	xu[MAX_MET];								/* metabolite concentrations			*/
extern double	moiety[MAX_MET];							/* concentration of conserved moieties	*/
extern LPSTR	strpool;									/* points to the string pool mem block	*/
extern LPSTR	treestr;									/* points to the tree string pool		*/
extern LPSTR	treeptr;									/* points to the tree string pool		*/
extern struct	opt options;								/* structure with simulation options	*/
extern struct	plt plot;									/* structure with plot options			*/
extern struct	kint huge *ktype;							/* ptr array of kinetic types & proprt	*/
extern struct	ou huge *outpel;							/* ptr array of output elements			*/
extern struct	sp huge *spar;								/* ptr array of scanning elements		*/
extern float	ver_no;										/* .top and .sim version number			*/
extern double	dft_endtime;								/* time value for last iteration		*/
extern double	dft_hrcz;									/* highest rate considered zero			*/
extern int		totmet;										/* number of total metabolites			*/
extern int		nmetab;										/* number of internal metabolites		*/
extern int		indmet;										/* number of independent metabolites	*/
extern int		nextmet;									/* number of external metabolites		*/
extern int		nsteps;										/* number of steps                		*/
extern int		nloops;										/* number of modifier loops             */
extern int		noutpel;                                    /* number of output elements			*/
extern int		nudf;										/* number of user-defined functions		*/
extern int		nrateq;										/* number of user-defined functions		*/
extern int		totsel;                                     /* number of selected output elements	*/
extern int		totscan;									/* number of dimensions to scan			*/
extern int		nscanpar;                                   /* number of scanning elements			*/
extern int		nlinks;										/* number of links between parameters	*/
extern unsigned char dft_debugval;							/* debug mode							*/
extern double	dft_conc;									/* default cmetabolite concentration	*/
extern double	dft_const;									/* default value for kinetic constants	*/
extern char		*dft_timeu;									/* default time units					*/
extern char		*dft_concu;									/* default conctration units			*/
extern unsigned long dft_pfo;								/* number of points for output			*/
extern struct	treet huge *tree;							/* function tree for rate equations		*/
extern struct	treet tr;									/* tree for the input					*/
extern LPSTR	TmpFiles;									/* string holding names of temp files	*/

int		InitGepasiVar( void );
void	TidyGepasiVar( void );
int 	SetParams( void );
int 	SetOutpEl( void );
void 	step_string( void );
void	conc_dft( void );
void 	numer_dft( void );

