REM Program: Hex Editor v5.6a, Module 2 of 5, PD 2004.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 02/01/2004.
REM Status: Public Domain.
REM Email: eoredson@yahoo.com
REM Urls: www.simtel.net www.filegate.net
REM  www.winsite.com

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM Subroutines:
REM   CalculatePosition1    --  calculate screen values given file position.
REM   CalculatePosition2    --  calculate screen values given variable.
REM   Colorf            --  specialized color function.
REM   Colorf2           --  specialized color function.
REM   DisplayScreen2    --  display screen border.
REM   DisplayBootUsage  --  display boot usage.
REM   DisplayScreen     --  display main editing screen.
REM   Deconcatenate     --  deconcatenates filename.
REM   DropDownMenu      --  starts top drop down menu.
REM   DisplayTab        --  redraws menu tab.
REM   DisplayCriticalError  --  display error trap message.
REM   DOSCommand        --  shells to DOS and runs command.
REM   InitializePaste   --  initialize paste file.
REM   InitPasteFiles    --  init paste files for new file.
REM   OpenDataFiles     --  search for and open data files.
REM   OpenMarkerFile    --  open marker file.
REM   OpenUndoFile      --  open undo file.
REM   OpenPasteFiles    --  open paste files.
REM   HelpScreen        --  display help screens.
REM   InitVars          --  inits some startup variables.
REM   Locatef           --  specialized locate function.
REM   MultiFileFunction     --  routine to process multiple files.
REM   Printf            --  specialized print function.
REM   PrintHelpScreens  --  prints help information.
REM   ReadCommandLine   --  reads lowercase command line.
REM   ReadConfigFile    --  search for and read configure file.

REM Functions:
REM   CalculateColumn   --  calculate column groups.
REM   CalculateColumn2  --  calculate column groups.
REM   CalculatePosition3#  --  calculate mouse position.
REM   CalculatePosition4#  --  calculate mouse position.
REM   DumpLineRange$    -- format line range.
REM   Conanicalize      --  trims a filename.
REM   Directories       --  get a directory from temp data file.
REM   Filenames         --  get a filename from temp data file.
REM   ReleaseTime       --  releases time slice to windows.
REM   TestFile          --  test if a file could or does exist.
REM   TestMouse         --  returns True if mouse present.
REM   TestWindows       --  returns True for windows running.
REM   TimeElapsed       --  test time elapsed from initial time.
REM   TimeNow           --  returns seconds past midnight.
REM   TrimSpaces        --  removes spaces from a string.
REM   UndoByte          --  get an undo byte from temp data file.
REM   UndoPosition      --  get an undo position from temp data file.

REM Mouse routines:
REM   MouseDriver       --  processes mouse activity.
REM   MouseDriver2      --  processes mouse drag activity.
REM   MouseFunction     --  accesses mouse.
REM   MouseFunction2    --  positions mouse.
REM   HMouse            --  hides mouse cursor.
REM   SMouse            --  shows mouse cursor.

' routine to init variables.
SUB InitVars
 ' init a quote symbol.
 Quote = CHR$(34)

 ' init screen colors.
 Black = 0: Blue = 1: Cyan = 11: Green = 10: Magenta = 13
 Plain = 7: Red = 12: White = 15: Yellow = 14

 ' init ascii characters.
 Hline = 205: Vline = 186
 ULcorner = 201: URcorner = 187
 LLcorner = 200: LRcorner = 188

 ' store video page.
 InregsX.AX=&H0F00
 Call InterruptX(&H10,InregsX,OutregsX)
 Video.Page=OutregsX.BX

 ' store basic dta.
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 BASIC.DTA.SEG = OutregsX.ES
 BASIC.DTA.OFF = OutregsX.BX

 ' store mouse timing.
 MouseTime = 1!

 ' check mouse present.
 Mouse.Present = TestMouse

 ' verify windows loaded.
 Windows.Detected = TestWindows

 ' init filename variables.
 ConfigFile = "hexedit.cfg"
 DumpFile = "hexedit.dmp"
END SUB

' routine to send string of characters to screen.
' (this optimizes screen i/o in XP dos box VM86).
SUB Printf(Var1$)
 InregsX2=InregsX
 VarZ=Video.Page*256+Background.Color*16+Foreground.Color
 For VarX=1 To Len(Var1$)
    VarY=Asc(Mid$(Var1$,VarX,1))
    InregsX.AX=&H0900+VarY
    InregsX.BX=VarZ
    InregsX.CX=1 ' char
    Call InterruptX(&H10,InregsX,OutregsX)
    ' reposition cursor.
    If Pos(0)+1<=80 Then
       Locate Csrlin,Pos(0)+1,0
    Endif
 Next
 InregsX=InregsX2
END SUB

' subroutine stores recent color change.
SUB Colorf(Var)
 Foreground.Color=Var
 Color Var
END SUB

' subroutine stores recent color change.
SUB Colorf2(Var1,Var2)
 Foreground.Color=Var1
 Background.Color=Var2
 Color Var1,Var2
END SUB

' routine sets cursor position.
SUB LOCATEf(Var1,Var2,Var3)
 ' test end of page.
 If Var1>24 Then
    ' scroll screen.
    InregsX2=InregsX
    InregsX.AX=&H0601
    InregsX.BX=&H0700
    InregsX.CX=&H0000
    InregsX.DX=24*256+&H4F
    Call InterruptX(&H10,InregsX,OutregsX)
    Var1=24
    InregsX=InregsX2
 Endif
 Locate Var1,Var2,Var3
END SUB

' read lowercase command line.
SUB ReadCommandLine(Var$)
 Var$ = ""
 InregsX.AX = &H6200
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSPsegment = OutregsX.BX
 PSPoffset = 128
 DEF SEG = PSPsegment
 FOR Count = 1 TO 127
    CommandChar = PEEK(PSPoffset + Count)
    SELECT CASE CommandChar
    CASE 0, 10, 13
       EXIT FOR
    CASE ELSE
       Var$ = Var$ + CHR$(CommandChar)
    END SELECT
 NEXT
 DEF SEG
END SUB

' routine to process multiple files.
SUB MultiFileFunction(Var)
 Select Case Var
 Case 1 ' Init current file.
    File(CurrentFile).AsciiValue = False
    File(CurrentFile).ASCIIZ = ASCIIZ
    File(CurrentFile).Buffer = CHR$(0)
    File(CurrentFile).CopyPositionEnd = 0
    File(CurrentFile).CopyPositionPivot = 0
    File(CurrentFile).CopyPositionStart = 0
    File(CurrentFile).CurrentMarker = 0
    File(CurrentFile).CurrentUndo = 0
    File(CurrentFile).CurrentWindow2 = 0
    File(CurrentFile).Filename = Filename
    File(CurrentFile).FileAttribute = FileAttribute
    File(CurrentFile).FileByte = CHR$(0)
    File(CurrentFile).FileLength = False
    File(CurrentFile).FilePage = 1
    File(CurrentFile).FilePosition = 1
    File(CurrentFile).Handle = Handle
    File(CurrentFile).MarkerCount = 0
    File(CurrentFile).PageColumn = 1
    File(CurrentFile).PageRow = 1
    File(CurrentFile).ShortFilename = ShortFilename
 Case 2 ' Store current file.
    File(CurrentFile).AsciiValue = AsciiValue
    File(CurrentFile).ASCIIZ = ASCIIZ
    File(CurrentFile).Buffer = Buffer
    File(CurrentFile).CopyPositionEnd = CopyPositionEnd
    File(CurrentFile).CopyPositionPivot = CopyPositionPivot
    File(CurrentFile).CopyPositionStart = CopyPositionStart
    File(CurrentFile).CurrentMarker = CurrentMarker
    File(CurrentFile).CurrentUndo = CurrentUndo
    File(CurrentFile).CurrentWindow2 = CurrentWindow2
    File(CurrentFile).Filename = Filename
    File(CurrentFile).FileAttribute = FileAttribute
    File(CurrentFile).FileByte = FileByte
    File(CurrentFile).FileLength = FileLength
    File(CurrentFile).FilePage = FilePage
    File(CurrentFile).FilePosition = FilePosition
    File(CurrentFile).Handle = Handle
    File(CurrentFile).MarkerCount = MarkerCount
    File(CurrentFile).PageColumn = PageColumn
    File(CurrentFile).PageRow = PageRow
    File(CurrentFile).ShortFilename = ShortFilename
 Case 3 ' Restore current file.
    AsciiValue = File(CurrentFile).AsciiValue
    ASCIIZ = File(CurrentFile).ASCIIZ
    Buffer = File(CurrentFile).Buffer
    CopyPositionEnd = 0
    CopyPositionPivot = 0
    CopyPositionStart = 0
    CurrentMarker = File(CurrentFile).CurrentMarker
    CurrentUndo = File(CurrentFile).CurrentUndo
    CurrentWindow2 = File(CurrentFile).CurrentWindow2
    Filename = File(CurrentFile).Filename
    FileAttribute = File(CurrentFile).FileAttribute
    FileByte = File(CurrentFile).FileByte
    FileLength = File(CurrentFile).FileLength
    FilePage = File(CurrentFile).FilePage
    FilePosition = File(CurrentFile).FilePosition
    Handle = File(CurrentFile).Handle
    MarkerCOunt = File(CurrentFile).MarkerCount
    PageColumn = File(CurrentFile).PageColumn
    PageRow = File(CurrentFile).PageRow
    ShortFilename = File(CurrentFile).ShortFilename
 End Select
END SUB

' routine to open undo file.
SUB OpenUndoFile(Var2)
 ON LOCAL ERROR GOTO Error.RoutineX1
 ' reset process counter.
 Var = False
 Var2 = False
 ' start counter loop.
 DO
    ' make temp filename with counter.
    V1$ = "UNDOBYTE.DA" + MID$(STR$(Var), 2)
    V2$ = ""
    ' get valid path for file.
    CALL OpenDataFiles(V1$, V2$)
    ' check file open.
    CLOSE #6
    Disk.Ready = False
    ' attempt to open file.
    OPEN V1$ FOR RANDOM AS #6 LEN = LEN(UndoFile)
    ' exit loop if valid file.
    IF Disk.Ready = False THEN
       EXIT DO
    END IF
    ' increment process counter.
    Var = Var + 1
    ' check maximum processes open.
    IF Var > 9 THEN
       Var2 = True
       ErrorTrap = 90
       Exit Sub
    END IF
 LOOP
 ' store process number.
 Process.Number = Var
 EXIT SUB
Error.RoutineX1:
 Disk.Ready = True
 ErrorTrap = Err
 RESUME NEXT
END SUB

' routine to open marker file.
SUB OpenMarkerFile(Var2)
 ON LOCAL ERROR GOTO Error.RoutineX2
 ' make temp filename with process number.
 V1$ = "MARKERS1.DA" + MID$(STR$(Process.Number), 2)
 V2$ = ""
 Var2 = False
 ' get valid path.
 CALL OpenDataFiles(V1$, V2$)
 CLOSE #7
 Disk.Ready = False
 ' attempt to open file.
 OPEN V1$ FOR RANDOM AS #7 LEN = LEN(MarkerFile)
 If Disk.Ready Then
    Var2 = True
 Endif
 EXIT SUB
Error.RoutineX2:
 Disk.Ready = True
 ErrorTrap = Err
 RESUME NEXT
END SUB

' routine to initialize paste file.
SUB InitializePaste(Var2)
 ON LOCAL ERROR GOTO Error.RoutineX3
 ' make temp filename with process number.
 V1$ = "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 V2$ = ""
 Var2 = False
 ' get valid path.
 CALL OpenDataFiles(V1$, V2$)
 CLOSE #4
 Disk.Ready = False
 ' check file exists.
 IF DIR$(V1$)<>"" THEN
    KILL V1$ ' delete file.
 END IF
 IF Disk.Ready Then
    Var2 = True
 End if
 EXIT SUB
Error.RoutineX3:
 Disk.Ready = True
 ErrorTrap = Err
 RESUME NEXT
END SUB

' routine to open paste files.
SUB OpenPasteFiles(Var2)
 ON LOCAL ERROR GOTO Error.RoutineX4
 ' make filename with process number.
 V1$ = "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 ' make filename with process number and file number.
 V2$ = "UNDOFIL" + MID$(STR$(Process.Number), 2) + ".DA" + MID$(STR$(CurrentFile), 2)
 ' get valid path.
 Var2 = False
 CALL OpenDataFiles(V1$, V2$)
 CLOSE #4, #5
 Disk.Ready = False
 ' attempt to open file.
 OPEN V1$ FOR RANDOM AS #4 LEN = 1
 IF Disk.Ready THEN
    Var2 = True
    EXIT SUB
 END IF
 Disk.Ready = False
 ' attempt to open file.
 OPEN V2$ FOR RANDOM AS #5 LEN = 1
 IF Disk.Ready THEN
    Var2 = True
 END IF
 EXIT SUB
Error.RoutineX4:
 Disk.Ready = True
 ErrorTrap = Err
 RESUME NEXT
END SUB

' routine to init paste files for new file.
SUB InitPasteFiles(Var2)
 ON LOCAL ERROR GOTO Error.RoutineX5
 ' make filename with process number.
 V1$ = "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 ' make filename with process number and file number.
 V2$ = "UNDOFIL" + MID$(STR$(Process.Number), 2) + ".DA" + MID$(STR$(CurrentFile), 2)
 ' get valid path.
 Var2 = False
 CALL OpenDataFiles(V1$, V2$)
 CLOSE #4, #5
 Disk.Ready = False
 ' attempt to open file.
 OPEN V1$ FOR RANDOM AS #4 LEN = 1
 IF Disk.Ready THEN
    Var2 = True
    EXIT SUB
 END IF
 Disk.Ready = False
 IF DIR$(V2$)<>"" THEN
    KILL V2$ ' remove temp file.
 END IF
 IF Disk.Ready THEN
    Var2 = True
    EXIT SUB
 END IF
 Disk.Ready = False
 ' attempt to open temp file.
 OPEN V2$ FOR RANDOM AS #5 LEN = 1
 IF Disk.Ready THEN
    Var2 = True
 END IF
 EXIT SUB
Error.RoutineX5:
 Disk.Ready = True
 ErrorTrap = Err
 RESUME NEXT
END SUB

REM Position calculation routines follow:

' displays cell position in string format type 1.
SUB FormatPosition1
 CALL CalculatePosition2
 IF CurrentWindow2 = False THEN
    PRINTf "(page:" + MID$(STR$(FilePage2 - 1), 2) + ","
 ELSE
    PRINTf "(page:" + RIGHT$("00000000" + HEX$(FilePage2 - 1), 8) + "H,"
 END IF
 PRINTf "row:" + MID$(STR$(PageRow2), 2) + ","
 PRINTf "column:" + MID$(STR$(PageColumn2), 2) + ")"
END SUB

' function to calculate column groups.
FUNCTION CalculateColumn
 SELECT CASE PageColumn
 CASE 1 TO 4
    CalculateColumn = (PageColumn - 1) * 2 + 1
 CASE 5 TO 8
    CalculateColumn = (PageColumn - 1) * 2 + 2
 CASE 9 TO 12
    CalculateColumn = (PageColumn - 1) * 2 + 3
 CASE 13 TO 16
    CalculateColumn = (PageColumn - 1) * 2 + 4
 CASE 17 TO 20
    CalculateColumn = (PageColumn - 1) * 2 + 5
 END SELECT
END FUNCTION

' function to calculate column groups.
FUNCTION CalculateColumn2
 SELECT CASE PageColumn2
 CASE 1 TO 4
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 1
 CASE 5 TO 8
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 2
 CASE 9 TO 12
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 3
 CASE 13 TO 16
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 4
 CASE 17 TO 20
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 5
 END SELECT
END FUNCTION

' calculate current screen page number, row, and column, given file position.
SUB CalculatePosition1
 FilePage = INT((FilePosition - 1) / 320) + 1
 PageRow = INT((FilePosition - (FilePage - 1) * 320 - 1) / 20) + 1
 PageColumn = INT((FilePosition - (FilePage - 1) * 320) - (PageRow - 1) * 20)
END SUB

' calculate screen page number, row, and column, given variable.
SUB CalculatePosition2
 IF TempPosition3 = 0 THEN
    FilePage2 = 0
    PageRow2 = 0
    PageColumn2 = 0
 ELSE
    FilePage2 = INT((TempPosition3 - 1) / 320) + 1
    PageRow2 = INT((TempPosition3 - (FilePage2 - 1) * 320 - 1) / 20) + 1
    PageColumn2 = INT((TempPosition3 - (FilePage2 - 1) * 320) - (PageRow2 - 1) * 20)
 END IF
END SUB

' function to calculate mouse position.
FUNCTION CalculatePosition3#
 Var1# = (FilePage - 1) * 320 + (Mouse.Row - 4) * 20
 SELECT CASE Mouse.Column
 CASE 6, 7
    Var1# = Var1# + 1#
 CASE 8, 9
    Var1# = Var1# + 2#
 CASE 10, 11
    Var1# = Var1# + 3#
 CASE 12, 13
    Var1# = Var1# + 4#
 CASE 15, 16
    Var1# = Var1# + 5#
 CASE 17, 18
    Var1# = Var1# + 6#
 CASE 19, 20
    Var1# = Var1# + 7#
 CASE 21, 22
    Var1# = Var1# + 8#
 CASE 24, 25
    Var1# = Var1# + 9#
 CASE 26, 27
    Var1# = Var1# + 10#
 CASE 28, 29
    Var1# = Var1# + 11#
 CASE 30, 31
    Var1# = Var1# + 12#
 CASE 33, 34
    Var1# = Var1# + 13#
 CASE 35, 36
    Var1# = Var1# + 14#
 CASE 37, 38
    Var1# = Var1# + 15#
 CASE 39, 40
    Var1# = Var1# + 16#
 CASE 42, 43
    Var1# = Var1# + 17#
 CASE 44, 45
    Var1# = Var1# + 18#
 CASE 46, 47
    Var1# = Var1# + 19#
 CASE 48, 49
    Var1# = Var1# + 20#
 END SELECT
 CalculatePosition3# = Var1#
END FUNCTION

' function to calculate mouse position.
FUNCTION CalculatePosition4#
 Var1# = (FilePage - 1) * 320 + (Old.Mouse.Row - 4) * 20
 SELECT CASE Old.Mouse.Column
 CASE 6, 7
    Var1# = Var1# + 1#
 CASE 8, 9
    Var1# = Var1# + 2#
 CASE 10, 11
    Var1# = Var1# + 3#
 CASE 12, 13
    Var1# = Var1# + 4#
 CASE 15, 16
    Var1# = Var1# + 5#
 CASE 17, 18
    Var1# = Var1# + 6#
 CASE 19, 20
    Var1# = Var1# + 7#
 CASE 21, 22
    Var1# = Var1# + 8#
 CASE 24, 25
    Var1# = Var1# + 9#
 CASE 26, 27
    Var1# = Var1# + 10#
 CASE 28, 29
    Var1# = Var1# + 11#
 CASE 30, 31
    Var1# = Var1# + 12#
 CASE 33, 34
    Var1# = Var1# + 13#
 CASE 35, 36
    Var1# = Var1# + 14#
 CASE 37, 38
    Var1# = Var1# + 15#
 CASE 39, 40
    Var1# = Var1# + 16#
 CASE 42, 43
    Var1# = Var1# + 17#
 CASE 44, 45
    Var1# = Var1# + 18#
 CASE 46, 47
    Var1# = Var1# + 19#
 CASE 48, 49
    Var1# = Var1# + 20#
 END SELECT
 CalculatePosition4# = Var1#
END FUNCTION

' function to format line range.
FUNCTION DumpLineRange$
 Var$ = "File: " + RTRIM$(Filename) + ", position" + STR$(FirstByte) + " to"
 IF LastByte <= FileLength THEN
    Var$ = Var$ + STR$(LastByte)
 ELSE
    Var$ = Var$ + STR$(FileLength)
 END IF
 Var$ = Var$ + " (x" + RIGHT$("00000000" + HEX$(FirstByte - 1), 8) + " - "
 IF LastByte <= FileLength THEN
    Var$ = Var$ + "x" + RIGHT$("00000000" + HEX$(LastByte - 1), 8) +")"
 ELSE
    Var$ = Var$ + "x" + RIGHT$("00000000" + HEX$(FileLength - 1), 8) +")"
 END IF
 Var$ = Var$ + "."
 DumpLineRange$ = Var$
END FUNCTION

' routine to read in custom config file variables.
' searchs current path, environment path, then path statement.
SUB ReadConfigFile (Var$)
 ' declare error trap.
 ON LOCAL ERROR GOTO Error.Routine

 ' check for screen row variable.
 IF ENVIRON$("HEXSCREEN") <> Nul THEN
    ScreenRow = True
 END IF

 ' check for heap sort variable.
 IF ENVIRON$("HEXSORT") <> Nul THEN
    HeapSortOff = True
 END IF

 ' check for heap sort variable.
 IF ENVIRON$("AMBIGUATE") <> Nul THEN
    AmbiguateSwitch = True
 END IF

 ' init alternate characters.
 IF ENVIRON$("HEXCHARS") <> Nul THEN
    Hline = 45
    Vline = 124
    ULcorner = 43
    URcorner = 43
    LLcorner = 43
    LRcorner = 43
 END IF

 ' define screen offsets for file menu box.
 ' allows menu reposotioning.
 Xcoor = 5
 Ycoor = 20

 ' search current directory.
 Config.Filename$ = ConfigFile
 IF DIR$(Config.Filename$) <> Nul THEN
    GOTO ReadFile2
 END IF
 ' search environment data file.
 File$ = ENVIRON$("HEXEDIT")
 IF LEN(File$) THEN
    File$ = RTRIM$(File$)
    File$ = LTRIM$(File$)
    IF RIGHT$(File$, 1) <> "\" THEN
       File$ = File$ + "\"
    END IF
    Config.Filename$ = File$ + ConfigFile
    IF DIR$(Config.Filename$) <> Nul THEN
       GOTO ReadFile2
    END IF
 END IF
 ' search path statement.
 Path$ = ENVIRON$("PATH")
 DO
    ' parse path.
    Parse = INSTR(Path$, ";")
    IF Parse THEN
       File$ = LEFT$(Path$, Parse - 1)
       Path$ = MID$(Path$, Parse + 1)
    ELSE
       File$ = Path$
       Path$ = Nul
    END IF
    ' store filename.
    File$ = RTRIM$(File$)
    File$ = LTRIM$(File$)
    IF LEN(File$) THEN
       IF RIGHT$(File$, 1) <> "\" THEN
          File$ = File$ + "\"
       END IF
       Config.Filename$ = File$ + ConfigFile
       IF DIR$(Config.Filename$) <> Nul THEN
          GOTO ReadFile2
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 EXIT SUB

' read in the data file
ReadFile2:
 ' open filename.
 ErrorTrap = False
 CLOSE #1
 OPEN Config.Filename$ FOR INPUT SHARED AS #1
 IF ErrorTrap THEN
    EXIT SUB
 END IF
 ' read input lines.
 DO WHILE NOT EOF(1)
    LINE INPUT #1, FileLine$
    FileLine2$ = FileLine$
    ' remove spaces.
    FileLine$ = TrimSpaces$(FileLine$)
    ' check for comment.
    IF LEFT$(FileLine$, 1) = ";" THEN
       FileLine$ = Nul
    END IF
    ' check assignment value.
    Parse = INSTR(FileLine$, "=")
    ' parse off left/right sides.
    IF Parse THEN
       ' get left/right side values.
       Char$ = LEFT$(FileLine$, Parse - 1)
       Setting$ = MID$(FileLine$, Parse + 1)
       ' get right side value for filenames
       ' enclosed in quotes containing spaces.
       Parse = INSTR(FileLine2$, "=")
       Setting2$ = MID$(FileLine2$, Parse + 1)
       Setting2$ = RTRIM$(Setting2$)
       Setting2$ = LTRIM$(Setting2$)
       ' check length of values.
       IF LEN(Char$) > 0 AND LEN(Setting$) > 0 THEN
          SELECT CASE UCASE$(Char$)
          ' check dump filename.
          CASE "DUMPFILE"
             DumpFile = Setting$
          ' check and concatenate loaded filenames.
          CASE "EDITFILE"
             IF Var$ = "" THEN
                Var$ = Setting2$
             ELSE
                Var$ = Var$ + CHR$(13) + Setting2$
             END IF
          ' check environment replacement variables.
          CASE "HEXSCREEN"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                ScreenRow = True
             CASE "ON", "-1", "TRUE"
                ScreenRow = False
             END SELECT
          CASE "HEXSORT"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                HeapSortOff = True
             CASE "ON", "-1", "TRUE"
                HeapSortOff = False
             END SELECT
          CASE "HEXDISPLAY"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                FileDisplay = True
             CASE "ON", "-1", "TRUE"
                FileDisplay = False
             END SELECT
          CASE "AMBIGUATE"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                AmbiguateSwitch = False
             CASE "ON", "-1", "TRUE"
                AmbiguateSwitch = True
             END SELECT
          CASE "MOUSEDRAGSCROLL"
             MouseTime = CSNG(VAL(Setting$))
          CASE "XCOOR"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 2 THEN
                IF NewValue <= 8 THEN
                   Xcoor = NewValue
                END IF
             END IF
          CASE "YCOOR"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 1 THEN
                IF NewValue <= 39 THEN
                   Ycoor = NewValue
                END IF
             END IF
          CASE "BLACK"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Black = NewValue
                END IF
             END IF
          CASE "BLUE"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Blue = NewValue
                END IF
             END IF
          CASE "CYAN"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Cyan = NewValue
                END IF
             END IF
          CASE "GREEN"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Green = NewValue
                END IF
             END IF
          CASE "MAGENTA"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Magenta = NewValue
                END IF
             END IF
          CASE "PLAIN"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Plain = NewValue
                END IF
             END IF
          CASE "RED"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Red = NewValue
                END IF
             END IF
          CASE "WHITE"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   White = NewValue
                END IF
             END IF
          CASE "YELLOW"
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 THEN
                IF NewValue <= 15 THEN
                   Yellow = NewValue
                END IF
             END IF
          CASE ELSE
             ' check ascii value.
             NewValue = INT(VAL(Setting$))
             IF NewValue >= False AND NewValue <= 255 THEN
                SELECT CASE UCASE$(Char$)
                CASE "HLINE"
                   Hline = NewValue
                CASE "VLINE"
                   Vline = NewValue
                CASE "ULCORNER"
                   ULcorner = NewValue
                CASE "URCORNER"
                   URcorner = NewValue
                CASE "LLCORNER"
                   LLcorner = NewValue
                CASE "LRCORNER"
                   LRcorner = NewValue
                END SELECT
             END IF
          END SELECT
       END IF
    END IF
 LOOP
TopProgram:
 CLOSE #1
 EXIT SUB

' critical error trap.
Error.Routine:
 ErrorTrap = ERR
 ' check screen.
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 ' display error message.
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor ReadConfigFile " + Version + " " + Release + " critical error trap:"
 ' display error.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit), A(bort):"
 LOCATEf Csrlin, 44, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME NEXT
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    CASE "a"
       PRINTf "a"
       LOCATEf Csrlin+1, 1, 0
       EXIT DO
    END SELECT
 LOOP
END SUB

REM Define functions.

' function to release time slice in windows.
FUNCTION ReleaseTime
 ON LOCAL ERROR RESUME NEXT
 IF SupportedCall = False THEN
    InregsX.AX = &H1680
    InregsX.BX = &H0
    CALL InterruptX(&H2F, InregsX, OutregsX)
    IF (OutregsX.AX AND &HFF) = &H80 THEN
       SupportedCall = True
    END IF
 END IF
 ReleaseTime = True
END FUNCTION

' remove spaces from variable.
FUNCTION TrimSpaces$ (Var$)
 ON LOCAL ERROR RESUME NEXT
 Var1$ = Var$
 DO
    Parse = INSTR(Var1$, " ")
    IF Parse THEN
       Var1$ = LEFT$(Var1$, Parse - 1) + MID$(Var1$, Parse + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 TrimSpaces$ = Var1$
END FUNCTION

' conanicalizes filename.
FUNCTION Conanicalize$ (Var$)
 ON LOCAL ERROR RESUME NEXT
 Var1$ = Var$
 ' strip drive letter.
 Var1$ = UCASE$(Var1$)
 IF MID$(Var1$, 2, 1) = ":" THEN
    Var1$ = MID$(Var1$, 3)
 END IF
 ' strip dos path.
 DO
    Path = INSTR(Var1$, "\")
    IF Path THEN
       Var1$ = MID$(Var1$, Path + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 ' strip network path.
 DO
    Path = INSTR(Var1$, "/")
    IF Path THEN
       Var1$ = MID$(Var1$, Path + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 Conanicalize$ = Var1$
END FUNCTION

' Test data file exists.
' Returns: TestFile=-1 if file exists,
'   or non-existent and can be created.
FUNCTION TestFile(Var$)
 DIM TestASCIIZ AS STRING*261
 TestASCIIZ = Var$ + CHR$(0)
 ' dos get file attribute.
 InregsX.AX = &H4300
 InregsX.DS = VARSEG(TestASCIIZ)
 InregsX.DX = VARPTR(TestASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)
 ' check carry flag error.
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    TestFile = True
    EXIT FUNCTION
 END IF
 ' check file nonexistent.
 IF (OutregsX.AX) = 2 THEN
    TestFile = True
    EXIT FUNCTION
 END IF
 TestFile = False
END FUNCTION

REM Drop down menu subroutine:

REM Returns: variable CurrentMenu equals 1 to 7, or 0 if exit,
REM  variable CurrentMenuSelection is menu selection in CurrentMenu.

SUB DropDownMenu
 ' declare error trap.
 ON LOCAL ERROR GOTO Error.Routine2
 GOSUB StoreArea
TopProgram1:
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection

 ' keyboard/mouse input loop.
 DO
    CharInput$ = ""

    ' call mouse subroutine.
    CALL MouseDriver

    ' check left mouse button.
    IF Mouse.ButtonX THEN
       Mouse.Row = Mouse.RowX
       Mouse.Column = Mouse.ColumnX
       GOSUB MouseButton1X
    ELSE
       ' check right/middle mouse button.
       IF Mouse.Button2 OR Mouse.Button3 THEN
          GOSUB RestoreArea
          CurrentMenu = False
          EXIT SUB
       ELSE
          ' check mouse position.
          IF Mouse.Row OR Mouse.Column THEN
             GOSUB MoveMouse
          END IF
       END IF
    END IF

    ' store keyboard buffer.
    CharInput$ = INKEY$
    IF LEN(CharInput$) THEN
       SELECT CASE LEN(CharInput$)
       CASE 1
          SELECT CASE ASC(CharInput$)
          CASE 13 ' Enter
             GOSUB RestoreArea
             EXIT SUB
          CASE 27 ' Escape
             GOSUB RestoreArea
             CurrentMenu = False
             EXIT SUB
          END SELECT
       CASE 2
          SELECT CASE ASC(RIGHT$(CharInput$, 1))
          CASE 72 ' Up
             GOSUB MenuUp
          CASE 80 ' Down
             GOSUB MenuDown
          CASE 75 ' Left
             IF FileLength THEN
                GOSUB MenuLeft
             END IF
          CASE 77 ' Right
             IF FileLength THEN
                GOSUB MenuRight
             END IF
          END SELECT
       END SELECT
    END IF
    ' release time slice,
    Var = ReleaseTime
 LOOP
 EXIT SUB

' moves one menu left, wrapping.
MenuLeft:
 GOSUB RestoreArea
 IF CurrentMenu = 1 THEN
    CurrentMenu = 7
 ELSE
    CurrentMenu = CurrentMenu - 1
 END IF
 GOSUB StoreArea
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection
 RETURN

' moves one menu right, wrapping.
MenuRight:
 GOSUB RestoreArea
 IF CurrentMenu = 7 THEN
    CurrentMenu = 1
 ELSE
    CurrentMenu = CurrentMenu + 1
 END IF
 GOSUB StoreArea
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection
 RETURN

' moves menu up, wrapping.
' selects CurrentMenuSelection variable.
MenuUp:
 SELECT CASE CurrentMenu
 CASE 1
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 5
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 2
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 3
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 4
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 5
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 5
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 6
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 7
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 END SELECT
 RETURN

' moves menu down, wrapping.
' selects CurrentMenuSelection variable.
MenuDown:
 SELECT CASE CurrentMenu
 CASE 1
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 5 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 2
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 3
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 4
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 5 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 5
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 6
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 7
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 END SELECT
 RETURN

' removes hilight from current menu selection.
EraseCurrentMenuSelection:
 CALL HMouse
 COLORf2 White, 0
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL SMouse
 RETURN

' adds hilight to current menu selection.
DrawCurrentMenuSelection:
 CALL HMouse
 COLORf2 White, 1
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL SMouse
 RETURN

' draws current menu selection.
DisplayCurrentMenuSelection:
 SELECT CASE CurrentMenu
 CASE 1
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 7, 0
       PRINTf "Open new file"
    CASE 2
       LOCATEf 4, 7, 0
       PRINTf "Close file   "
    CASE 3
       LOCATEf 5, 7, 0
       PRINTf "View files   "
    CASE 4
       LOCATEf 6, 7, 0
       PRINTf "Toggle window"
    CASE 5
       LOCATEf 7, 7, 0
       PRINTf "Exit program "
    END SELECT
 CASE 2
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 17, 0
       PRINTf "ANSI Chart"
    CASE 2
       LOCATEf 4, 17, 0
       PRINTf "HEX Chart "
    END SELECT
 CASE 3
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 27, 0
       PRINTf "HEX Screen Dump"
    CASE 2
       LOCATEf 4, 27, 0
       PRINTf "HEX File Dump  "
    END SELECT
 CASE 4
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 37, 0
       PRINTf "Append Bytes       "
    CASE 2
       LOCATEf 4, 37, 0
       PRINTf "Append ASCII String"
    CASE 3
       LOCATEf 5, 37, 0
       PRINTf "Redraw Screen      "
    CASE 4
       LOCATEf 6, 37, 0
       PRINTf "Undo last byte     "
    CASE 5
       LOCATEf 7, 37, 0
       PRINTf "Undo All bytes     "
    END SELECT
 CASE 5
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 47, 0
       PRINTf "Jump to byte"
    CASE 2
       LOCATEf 4, 47, 0
       PRINTf "Jump to page"
    END SELECT
 CASE 6
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 57, 0
       PRINTf "HEX Screen Print"
    CASE 2
       LOCATEf 4, 57, 0
       PRINTf "HEX File Print  "
    END SELECT
 CASE 7
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 65, 0
       PRINTf "Search string"
    CASE 2
       LOCATEf 4, 65, 0
       PRINTf "Search bytes "
    END SELECT
 END SELECT
 RETURN

' draws menu.
DrawMenu:
 CurrentMenuSelection = 1
 GOSUB BoxBorder
 BoxDrawX1 = Xstore1
 BoxDrawX2 = Xstore2
 BoxDrawY1 = Ystore1
 BoxDrawY2 = Ystore2
 CALL HMouse
 SELECT CASE CurrentMenu
 CASE 1
    BoxDrawLength = 15
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 7, 0
    PRINTf "Open new file"
    LOCATEf 4, 7, 0
    PRINTf "Close file   "
    LOCATEf 5, 7, 0
    PRINTf "View files   "
    LOCATEf 6, 7, 0
    PRINTf "Toggle window"
    LOCATEf 7, 7, 0
    PRINTf "Exit program "
 CASE 2
    BoxDrawLength = 12
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 17, 0
    PRINTf "ANSI Chart"
    LOCATEf 4, 17, 0
    PRINTf "HEX Chart "
 CASE 3
    BoxDrawLength = 17
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 27, 0
    PRINTf "HEX Screen Dump"
    LOCATEf 4, 27, 0
    PRINTf "HEX File Dump  "
 CASE 4
    BoxDrawLength = 21
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 37, 0
    PRINTf "Append Bytes       "
    LOCATEf 4, 37, 0
    PRINTf "Append ASCII String"
    LOCATEf 5, 37, 0
    PRINTf "Redraw Screen      "
    LOCATEf 6, 37, 0
    PRINTf "Undo last byte     "
    LOCATEf 7, 37, 0
    PRINTf "Undo All bytes     "
 CASE 5
    BoxDrawLength = 14
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 47, 0
    PRINTf "Jump to byte"
    LOCATEf 4, 47, 0
    PRINTf "Jump to page"
 CASE 6
    BoxDrawLength = 18
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 57, 0
    PRINTf "HEX Screen Print"
    LOCATEf 4, 57, 0
    PRINTf "HEX File Print  "
 CASE 7
    BoxDrawLength = 15
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 65, 0
    PRINTf "Search string"
    LOCATEf 4, 65, 0
    PRINTf "Search bytes "
 END SELECT
 CALL SMouse
 RETURN

' stores area under menu.
StoreArea:
 IF CurrentMenu = False THEN
    RETURN
 END IF
 CALL HMouse
 GOSUB BoxBorder
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xstore1 TO Xstore2
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ystore1 TO Ystore2
       ColumnY1 = ColumnY1 + 1
       ' store ascii character.
       Area1(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2)
       ' store color. (undocumented: also stores background color).
       Area2(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2, 1)
    NEXT
 NEXT
 ' hilight menu tab.
 COLORf2 White, 1
 CALL DisplayTab(CurrentMenu)
 CALL SMouse
 RETURN

' restores area under menu.
RestoreArea:
 IF CurrentMenu = False THEN
    RETURN
 END IF
 CALL HMouse
 GOSUB BoxBorder
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xstore1 TO Xstore2
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ystore1 TO Ystore2
       ColumnY1 = ColumnY1 + 1
       LOCATEf RowX2, ColumnY2, 1
       ' restore color.
       TempZ = Area2(RowX1, ColumnY1)
       VarB = INT(TempZ / 16)
       VarF = TempZ MOD 16
       COLORf2 VarF, VarB
       ' restore ascii character.
       PRINTf CHR$(Area1(RowX1, ColumnY1))
    NEXT
 NEXT
 ' remove hilight menu tab.
 COLORf2 White, 0
 CALL DisplayTab(CurrentMenu)
 CALL SMouse
 RETURN

' returns borders of box.
BoxBorder:
 SELECT CASE CurrentMenu
 CASE 1
    Xstore1 = 2
    Xstore2 = 8
    Ystore1 = 6
    Ystore2 = 20
 CASE 2
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 16
    Ystore2 = 27
 CASE 3
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 26
    Ystore2 = 42
 CASE 4
    Xstore1 = 2
    Xstore2 = 8
    Ystore1 = 36
    Ystore2 = 56
 CASE 5
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 46
    Ystore2 = 59
 CASE 6
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 56
    Ystore2 = 73
 CASE 7
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 64
    Ystore2 = 78
 END SELECT
 RETURN

' draws box from (BoxDrawX1,BoxDrawY1) To (BoxDrawX2,BoxDrawY2),
'  length of box from left to right being BoxDrawLength.
DrawBox:
 COLORf Yellow
 LOCATEf BoxDrawX1, BoxDrawY1, 0
 PRINTf CHR$(ULcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(URcorner)
 FOR RowX1 = BoxDrawX1 + 1 TO BoxDrawX2 - 1
    LOCATEf RowX1, BoxDrawY1, 0
    PRINTf CHR$(Vline)
    LOCATEf RowX1, BoxDRawY2, 0
    PRINTf CHR$(Vline)
 NEXT
 LOCATEf BoxDrawX2, BoxDrawY1, 0
 PRINTf CHR$(LLcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(LRcorner)
 RETURN

' process mouse move.
MoveMouse:
 ' select drop down menu.
 IF Mouse.Row = 1 THEN
    NewMenuSelection = False
    SELECT CASE Mouse.Column
    CASE 6 TO 9 ' File
       NewMenuSelection = 1
    CASE 16 TO 21 ' Charts
       NewMenuSelection = 2
    CASE 26 TO 29 ' Dump
       NewMenuSelection = 3
    CASE 36 TO 39 ' Edit
       NewMenuSelection = 4
    CASE 46 TO 49 ' Jump
       NewMenuSelection = 5
    CASE 56 TO 60 ' Print
       NewMenuSelection = 6
    CASE 64 TO 69 ' Search
       NewMenuSelection = 7
    END SELECT
    IF NewMenuSelection > False THEN
       IF NewMenuSelection <> CurrentMenu THEN
          IF CurrentMenu > False THEN
             GOSUB RestoreArea
          END IF
          CurrentMenu = NewMenuSelection
          CurrentMenuSelection = 1
          GOSUB StoreArea
          GOSUB DrawMenu
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
    IF CurrentMenu > False THEN
       CALL HMouse
       COLORf2 White, 1
       CALL DisplayTab(CurrentMenu)
       CALL SMouse
    END IF
    RETURN
 END IF
 ' check mouse selection boundaries.
 SELECT CASE CurrentMenu
 CASE 1
    IF Mouse.Row >=3 AND Mouse.Row <= 7 THEN
       IF Mouse.Column >= 7 AND Mouse.Column <= 19 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 2
    IF Mouse.Row >=3 AND Mouse.Row <= 4 THEN
       IF Mouse.Column >= 17 AND Mouse.Column <= 26 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 3
    IF Mouse.Row >=3 AND Mouse.Row <= 4 THEN
       IF Mouse.Column >= 27 AND Mouse.Column <= 41 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 4
    IF Mouse.Row >=3 AND Mouse.Row <= 7 THEN
       IF Mouse.Column >= 37 AND Mouse.Column <= 55 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 5
    IF Mouse.Row >=3 AND Mouse.Row <= 5 THEN
       IF Mouse.Column >= 47 AND Mouse.Column <= 58 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 6
    IF Mouse.Row >=3 AND Mouse.Row <= 5 THEN
       IF Mouse.Column >= 57 AND Mouse.Column <= 72 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 7
    IF Mouse.Row >=3 AND Mouse.Row <= 5 THEN
       IF Mouse.Column >= 65 AND Mouse.Column <= 77 THEN
          IF Mouse.Row - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = Mouse.Row - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 END SELECT
 RETURN

' process left mouse button.
MouseButton1X:
 ExitMouse = False
 IF Mouse.Row - 2 = CurrentMenuSelection THEN
    SELECT CASE CurrentMenu
    CASE 1
       IF Mouse.Column >= 7 AND Mouse.Column <= 19 THEN
          ExitMouse = True
       END IF
    CASE 2
       IF Mouse.Column >= 17 AND Mouse.Column <= 26 THEN
          ExitMouse = True
       END IF
    CASE 3
       IF Mouse.Column >= 27 AND Mouse.Column <= 41 THEN
          ExitMouse = True
       END IF
    CASE 4
       IF Mouse.Column >= 37 AND Mouse.Column <= 55 THEN
          ExitMouse = True
       END IF
    CASE 5
       IF Mouse.Column >= 47 AND Mouse.Column <= 58 THEN
          ExitMouse = True
       END IF
    CASE 6
       IF Mouse.Column >= 57 AND Mouse.Column <= 72 THEN
          ExitMouse = True
       END IF
    CASE 7
       IF Mouse.Column >= 65 AND Mouse.Column <= 77 THEN
          ExitMouse = True
       END IF
    END SELECT
    ' exit subroutine with menu selection.
    IF ExitMouse THEN
       GOSUB RestoreArea
       EXIT SUB
    END IF
 END IF
 RETURN

TopProgram2:
 EXIT SUB

' critical error trap.
Error.Routine2:
 ErrorTrap = ERR
 CurrentMenu = False
 ' check screen.
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 ' display error message.
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor DropDownMenu " + Version + " " + Release + " critical error trap:"
 ' display error.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit):"
 LOCATEf Csrlin, 35, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram2
    END SELECT
 LOOP
END SUB

' subroutine to check mouse activity.
SUB MouseDriver
 ON LOCAL ERROR RESUME NEXT
 STATIC Pressed1 AS INTEGER
 Mouse.Button1 = False
 Mouse.Button2 = False
 Mouse.Button3 = False
 Mouse.Row = False
 Mouse.Column = False
 Mouse.ButtonX = False
 ' check mouse present
 IF Mouse.Present = False THEN
    EXIT SUB
 END IF
 ' read middle mouse button.
 CALL MouseFunction(Button, 2)
 IF (OutregsX.AX AND 4) = 4 THEN
    IF OutregsX.BX > 0 THEN
       Mouse.Button3 = True
       Mouse.Row = OutregsX.DX / 8 + 1
       Mouse.Column = OutregsX.CX / 8 + 1
       EXIT SUB
    END IF
 END IF
 ' read right mouse button.
 CALL MouseFunction(Button, 1)
 IF (OutregsX.AX AND 2) = 2 THEN
    IF OutregsX.BX > 0 THEN
       Mouse.Button2 = True
       Mouse.Row = OutregsX.DX / 8 + 1
       Mouse.Column = OutregsX.CX / 8 + 1
       EXIT SUB
    END IF
 END IF
 ' read left mouse button.
 CALL MouseFunction(Button, 0)
 Var2 = OutregsX.CX / 8 + 1
 Var3 = OutregsX.DX / 8 + 1
 IF (OutregsX.AX AND 1) = 0 THEN
    ' check button released.
    IF Pressed1 THEN
       Pressed1 = 0
       ' get button press data.
       Mouse.ButtonX = True
       Mouse.RowX = Var3
       Mouse.ColumnX = Var2
       EXIT SUB
    END IF
 END IF
 ' check mouse button pressed.
 IF (OutregsX.AX AND 1) = 1 THEN
    Pressed1 = -1
    EXIT SUB
 END IF
 ' read mouse position.
 CALL MouseFunction(Position, 0)
 Var2 = OutregsX.CX / 8 + 1
 Var3 = OutregsX.DX / 8 + 1
 IF Var3 <> Mouse.X OR Var2 <> Mouse.Y THEN
    Mouse.X = Var3
    Mouse.Y = Var2
    Mouse.Row = Mouse.X
    Mouse.Column = Mouse.Y
 END IF
END SUB

' subroutine to check mouse activity.
SUB MouseDriver2
 ON LOCAL ERROR RESUME NEXT
 STATIC Pressed2 AS INTEGER
 Mouse.Button1 = False
 Mouse.Button2 = False
 Mouse.Button3 = False
 Mouse.Row = False
 Mouse.Column = False
 Mouse.ButtonX = False
 ' check mouse present
 IF Mouse.Present = False THEN
    EXIT SUB
 END IF
 ' read middle mouse button.
 CALL MouseFunction(Button, 2)
 IF (OutregsX.AX AND 4) = 4 THEN
    IF OutregsX.BX > 0 THEN
       Mouse.Button3 = True
       Mouse.Row = OutregsX.DX / 8 + 1
       Mouse.Column = OutregsX.CX / 8 + 1
       EXIT SUB
    END IF
 END IF
 ' read right mouse button.
 CALL MouseFunction(Button, 1)
 IF (OutregsX.AX AND 2) = 2 THEN
    IF OutregsX.BX > 0 THEN
       Mouse.Button2 = True
       Mouse.Row = OutregsX.DX / 8 + 1
       Mouse.Column = OutregsX.CX / 8 + 1
       EXIT SUB
    END IF
 END IF
 ' read left mouse button.
 CALL MouseFunction(Button, 0)
 Var2 = OutregsX.CX / 8 + 1
 Var3 = OutregsX.DX / 8 + 1
 IF (OutregsX.AX AND 1) = 0 THEN
    ' check button released.
    IF Pressed2 THEN
       Pressed2 = 0
       ' get button press data.
       Mouse.ButtonX = True
       Mouse.RowX = Var3
       Mouse.ColumnX = Var2
       EXIT SUB
    END IF
 END IF
 ' check mouse button pressed.
 IF (OutregsX.AX AND 1) = 1 THEN
    ' check button pressed w/ mouse position.
    CALL MouseFunction(Position, 0)
    Var2 = OutregsX.CX / 8 + 1
    Var3 = OutregsX.DX / 8 + 1
    IF Var3 <> Mouse.X OR Var2 <> Mouse.Y THEN
       Mouse.Button1 = 2
       Mouse.X = Var3
       Mouse.Y = Var2
       Mouse.Row = Mouse.X
       Mouse.Column = Mouse.Y
       EXIT SUB
    END IF
    ' check button pressed w/ mouse position.
    CALL MouseFunction(Position, 0)
    Var2 = OutregsX.CX / 8 + 1
    Var3 = OutregsX.DX / 8 + 1
    IF Var3 = 2 OR Var3 = 3 THEN
       IF Var2 >= 6 AND Var2 <= 49 THEN
          Mouse.Button1 = 3
          Mouse.X = Var3
          Mouse.Y = Var2
          Mouse.Row = Mouse.X
          Mouse.Column = Mouse.Y
          EXIT SUB
       END IF
    END IF
    ' check button pressed w/ mouse position.
    CALL MouseFunction(Position, 0)
    Var2 = OutregsX.CX / 8 + 1
    Var3 = OutregsX.DX / 8 + 1
    IF Var3 = 20 OR Var3 = 21 THEN
       IF Var2 >= 6 AND Var2 <= 49 THEN
          Mouse.Button1 = 4
          Mouse.X = Var3
          Mouse.Y = Var2
          Mouse.Row = Mouse.X
          Mouse.Column = Mouse.Y
          EXIT SUB
       END IF
    END IF
    Pressed2 = -1
    ' init mouse drag pivot byte.
    CALL MouseFunction(Button, 0)
    Var2 = OutregsX.CX / 8 + 1
    Var3 = OutregsX.DX / 8 + 1
    CopyStart = 0
    Time1 = 0!
    IF Var3 > 3 AND Var3 < 20 THEN
       IF Var2 >= 6 AND Var2 <= 49 THEN
          CopyStart = FilePosition
       END IF
    END IF
    EXIT SUB
 END IF
 ' read mouse position.
 CALL MouseFunction(Position, 0)
 Var2 = OutregsX.CX / 8 + 1
 Var3 = OutregsX.DX / 8 + 1
 IF Var3 <> Mouse.X OR Var2 <> Mouse.Y THEN
    Mouse.X = Var3
    Mouse.Y = Var2
    Mouse.Row = Mouse.X
    Mouse.Column = Mouse.Y
 END IF
END SUB

' subroutine calls mouse bios function.
SUB MouseFunction (Var1, Var2)
 ON LOCAL ERROR RESUME NEXT
 REM INT 33H:
 REM   AX=00 - initialize mouse.
 REM   AX=01 - show mouse cursor.
 REM   AX=02 - hide mouse cursor. (re-entrant).
 REM   AX=03 - return position and button status.
 REM   AX=05 - return button press data.
 InregsX.AX = Var1
 InregsX.BX = Var2
 CALL InterruptX(&H33, InregsX, OutregsX)
END SUB

' subroutine positions mouse.
SUB MouseFunction2 (Var1, Var2)
 ON LOCAL ERROR RESUME NEXT
 REM INT 33H:
 REM   AX=04 - position mouse.
 InregsX.AX = MovePosition
 InregsX.CX = Var1 ' column
 InregsX.DX = Var2 ' row
 CALL InterruptX(&H33, InregsX, OutregsX)
END SUB

' hide mouse.
'   Hide/Show should be in pairs with the text update inbetween.
'   Multiple calls to HideMouse should be released with ShowMouse
'   the same number of times.
SUB HMouse
 IF Mouse.Present THEN
    CALL MouseFunction(HideMouse, 0)
    Show.Mouse = Show.Mouse - 1
 END IF
END SUB

' show mouse.
'   Show.Mouse=1 indicates the cursor has been initialized.
'   more than 1 show mouse may confuse system and hang.
SUB SMouse
 IF Mouse.Present THEN
    IF Show.Mouse < 1 THEN
       CALL MouseFunction(ShowMouse, 0)
       Show.Mouse = Show.Mouse + 1
    END IF
 END IF
END SUB

' directory structure function.
FUNCTION Directories$ (Var1%)
 ON LOCAL ERROR RESUME NEXT
 IF Windows.Detected THEN
    GET 3, Var1%, WinFileStruc
    Directories$ = WinFileStruc.Name
 ELSE
    GET 3, Var1%, DosFileStruc
    Directories$ = DosFileStruc.Name
 END IF
END FUNCTION

' filename structure function.
FUNCTION Filenames$ (Var1%)
 ON LOCAL ERROR RESUME NEXT
 IF Windows.Detected THEN
    GET 2, Var1%, WinFileStruc
    Filenames$ = WinFileStruc.Name
 ELSE
    GET 2, Var1%, DosFileStruc
    Filenames$ = DosFileStruc.Name
 END IF
END FUNCTION

' undo structure function.
FUNCTION UndoByte%(Var1%)
 ON LOCAL ERROR RESUME NEXT
 GET 6, Var1%, UndoFile
 UndoByte = UndoFile.UndoByte1(CurrentFile)
END FUNCTION

' undo structure function.
FUNCTION UndoPosition#(Var1%)
 ON LOCAL ERROR RESUME NEXT
 GET 6, Var1%, UndoFile
 UndoPosition = UndoFile.UndoPosition1(CurrentFile)
END FUNCTION

' undo structure function.
FUNCTION Markers#(Var1%)
 ON LOCAL ERROR RESUME NEXT
 GET 7, Var1%, MarkerFile
 Markers = MarkerFile.Markers1(CurrentFile)
END FUNCTION

' calculate elapsed time function.
Function TimeElapsed(Start.Time!,Wait.Time!)
 Elapsed.Time!=TimeNow!-Start.Time!
 If Elapsed.Time!<SFalse Then
    Elapsed.Time!=Elapsed.Time!+86400!
 Endif
 If Elapsed.Time!>Wait.Time! Then
    TimeElapsed=True
 Else
    TimeElapsed=False
 Endif
End Function

' return seconds past midnight.
Function TimeNow!
 InregsX.AX=&H0000
 Call InterruptX(&H1A,InregsX,OutregsX)
 If OutregsX.CX<False Then
    Var#=OutregsX.CX+65536
 Else
    Var#=OutregsX.CX
 Endif
 Var#=Var#*&H10000
 If OutregsX.DX<False Then
    Var#=Var#+OutregsX.DX+65536
 Else
    Var#=Var#+OutregsX.DX
 Endif
 Var#=Var#/18.2#
 TimeNow!=Csng(Var#)
End Function

' tests for mouse.
FUNCTION TestMouse
 CALL MouseFunction(CheckMouse, 0)
 IF OutregsX.AX = &HFFFF THEN
    ' set pixels per row/column.
    InregsX.AX = 7
    InregsX.BX = 0
    InregsX.CX = 0
    InregsX.DX = 632
    CALL InterruptX(&H33, InregsX, OutregsX)
    InregsX.AX = 8
    InregsX.BX = 0
    InregsX.CX = 0
    InregsX.DX = 192
    CALL InterruptX(&H33, InregsX, OutregsX)
    TestMouse = True
    EXIT FUNCTION
 END IF
 TestMouse = False
END FUNCTION

' tests for windows.
FUNCTION TestWindows
 InregsX.AX = &H160A
 CALL InterruptX(&H2F, InregsX, OutregsX)
 IF OutregsX.AX = False THEN
    Temp = (OutregsX.BX AND &HFF00) / 256
    IF Temp >= 4 THEN
       TestWindows = True
       EXIT FUNCTION
    END IF
 END IF
 TestWindows = False
END FUNCTION

' deconcatenates a filename to 32/64 bytes with preceding \..\ characters.
SUB Deconcatenate(Z$,Z%)
 IF INSTR(Z$, "\") = False THEN
    EXIT SUB
 END IF
 DO
    IF LEN(Z$) > Z% THEN
       V1 = INSTR(Z$, "\")
       IF V1 > 0 THEN
          DO
             IF MID$(Z$, V1, 4) = "\..\" THEN
                V1 = INSTR(V1 + 1, Z$, "\")
             ELSE
                EXIT DO
             END IF
          LOOP
          V2 = INSTR(V1 + 1, Z$, "\")
          IF V2 > 0 THEN
             Z$ = LEFT$(Z$, V1) + ".." + MID$(Z$, V2)
          ELSE
             EXIT DO
          END IF
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 DO
    V = INSTR(Z$, "\..\..\")
    IF V > 0 THEN
       Z$ = LEFT$(Z$, V - 1) + "\..\" + MID$(Z$, V + 7)
    ELSE
       EXIT DO
    END IF
 LOOP
 IF LEN(Z$) > Z% THEN
    Z$ = LEFT$(Z$, Z% - 3) + "..."
 END IF
END SUB

' initialize files.
'   tests temp environment directories,
'   temp directory, root, then default.
SUB OpenDataFiles(V1$, V2$)
 ON LOCAL ERROR GOTO Error.Routine4
 V$ = ENVIRON$("TMP")
 IF V$ = "" THEN
    V$ = ENVIRON$("TEMP")
 END IF
 IF LEN(V$) THEN
    IF RIGHT$(V$, 1) = "\" THEN
       F1$ = V$ + V1$
    ELSE
       F1$ = V$ + "\" + V1$
    END IF
    F2$ = ""
    IF LEN(V2$) THEN
       IF RIGHT$(V$, 1) = "\" THEN
          F2$ = V$ + V2$
       ELSE
          F2$ = V$ + "\" + V2$
       END IF
    END IF
    IF TestFile(F1$) THEN
       IF F2$ = "" THEN
          GOTO OpenDataFilename
       END IF
       IF TestFile(F2$) THEN
          GOTO OpenDataFilename
       END IF
    END IF
 END IF
 F1$ = "C:\TEMP\" + V1$
 IF LEN(V2$) THEN
    F2$ = "C:\TEMP\" + V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = "" THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 F1$ = "C:\" + V1$
 IF LEN(V2$) THEN
    F2$ = "C:\" + V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = "" THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 F1$ = V1$
 IF LEN(V2$) THEN
    F2$ = V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = "" THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 ERROR 76
 END

' returns filenames.
OpenDataFilename:
 V1$ = F1$
 V2$ = F2$
 EXIT SUB

' simple error routine
Error.Routine4:
 ErrorTrap = ERR
 CLS
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor " + Version + " " + Release + " fileopen critical error trap:"
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Check TEMP variables, .CFG file, or DOS file handles, then restart."
 COLORf Plain
 END
END SUB

' prints help information.
SUB PrintHelpScreens
 ON LOCAL ERROR GOTO Print.Error1
 PRINT #1, "Help screen: Hex Editor " + Version + " " + Release + " functions:"
 PRINT #1, "Function keys:"
 PRINT #1, " Alt-A  Append multiple bytes to file.   Alt-U  Undo last byte change."
 PRINT #1, " Alt-B  Append multiple null bytes.      Alt-V  View files."
 PRINT #1, " Alt-C  ANSI Chart.                      Alt-W  Close file."
 PRINT #1, " Alt-D  HEX Screen Dump.                 Alt-X  Exit program."
 PRINT #1, " Alt-E  HEX File Dump.                   Alt-Y  Toggle right window."
 PRINT #1, " Alt-F  Start input menu.                Alt-Z  Undo all byte changes."
 PRINT #1, " Alt-G  Append multiple specified bytes. Editing keys:"
 PRINT #1, " Alt-H  HEX Chart.                       Tab    -- Switch windows."
 PRINT #1, " Alt-J  Jump to byte position.           Enter  -- Change byte value."
 PRINT #1, " Alt-K  Search for ASCII string.         Insert -- Change string value."
 PRINT #1, " Alt-L  Jump to page position.           Delete -- Change hex string."
 PRINT #1, " Alt-M  Append ASCII string to file.     Escape -- Input Menu."
 PRINT #1, " Alt-N  Open new file.                   Other keys:"
 PRINT #1, " Alt-O  Print help.                      (hex value numeral preceded)."
 PRINT #1, " Alt-P  HEX Screen Print.                (ascii values preceded with H"
 PRINT #1, " Alt-Q  Help screen.                     treated as hexidecimal.)"
 PRINT #1, " Alt-R  Redraw screen.                   (right window unprintable chars"
 PRINT #1, " Alt-S  Search for multiple bytes.       are represented with a dot)."
 PRINT #1, " Alt-T  HEX File Print.                  (<escape> key exits search)."
 PRINT #1, "Marker keys:"
 PRINT #1, " 1  -  add marker              2  -  add specific marker value"
 PRINT #1, " 3  -  delete marker           4  -  delete specific marker"
 PRINT #1, " 5  -  jump previous marker    6  -  jump current marker"
 PRINT #1, " 7  -  jump next marker        8  -  jump specific marker"
 PRINT #1, " 9  -  list all markers        0  -  list specific marker"
 PRINT #1, " -  -  list markers of value   +  -  list range of markers"
 PRINT #1, " =  -  delete a range          [  -  delete all markers"
 PRINT #1, " ]  -  delete markers of value"
 PRINT #1, "Information keys:"
 PRINT #1, " ? key displays file length, and undos remaining."
 PRINT #1, " ! key displays current page, row, and column."
 PRINT #1, " ~ key displays last page and markers used."
 PRINT #1, " " + CHR$(34) + " key displays current path of file being edited."
 PRINT #1, " ; key displays the range of the current hilighted area."
 PRINT #1, " { key displays number of pasted entries stored in the undo file."
 PRINT #1, "Display keys:"
 PRINT #1, " F1 key toggles 64-byte filename display."
 PRINT #1, " F2 key toggles lower screen help key list."
 PRINT #1, " F11 key opens DOS shell in editor or file menu box."
 PRINT #1, " F12 key or Alt-I prompts for DOS command in editor."
 PRINT #1, "Hilight keys:"
 PRINT #1, " Shift-<key> hilights area, where <key> is:"
 PRINT #1, " <left>/<right>/<up>/<down>/<page up>/<page down>/<home>/<end>"
 PRINT #1, "Clipboard controls:"
 PRINT #1, " Control-C (copy)/Control-V (paste)"
 PRINT #1, " Control-X (undo previous paste)/Control-Z (undo all pastes)"
 PRINT #1, "Multiple file keys:"
 PRINT #1, " F6  -  Next file.          F9  -  Close file.        
 PRINT #1, " F7  -  Previous file.      F10 -  View files."
 PRINT #1, " F8  -  Load new file."
 PRINT #1, " Alt-1 to Alt-9  -  select specific file."
 PRINT #1, "File menu box keys:"
 PRINT #1, " F1  -  drive change.       F4  -  back 1 drive letter."
 PRINT #1, " F2  -  toggle file sort.   F5  -  forward 1 drive letter."
 PRINT #1, " F3  -  move file menu box. F6  -  toggle 8.3 ambiguation."
 PRINT #1, " F7  -  redraw file menu box. F8  -  specify filename attribute override."
 PRINT #1, " Alt-A to Alt-Z  -  select drive letter."
 PRINT #1, CHR$(12);
Print.Resume1:
 EXIT SUB
Print.Error1:
 RESUME Print.Resume1
END SUB

' redraws menu tab.
SUB DisplayTab(Var)
 SELECT CASE Var
 CASE 1 ' File
    LOCATEf 1, 6, 0
    PRINTf "File"
 CASE 2 ' Charts
    LOCATEf 1, 16, 0
    PRINTf "Charts"
 CASE 3 ' Dump
    LOCATEf 1, 26, 0
    PRINTf "Dump"
 CASE 4 ' Edit
    LOCATEf 1, 36, 0
    PRINTf "Edit"
 CASE 5 ' Jump
    LOCATEf 1, 46, 0
    PRINTf "Jump"
 CASE 6 ' Print
    LOCATEf 1, 56, 0
    PRINTf "Print"
 CASE 7 ' Search
    LOCATEf 1, 64, 0
    PRINTf "Search"
 END SELECT
 COLORf2 White, 0
END SUB

' display error trap message.
SUB DisplayCriticalError(Var)
 SELECT CASE Var
 CASE 5
    PRINTf "Syntax error." ' should not happen.
 CASE 6
    PRINTf "Overflow."
 CASE 9
    PRINTf "Subscript out of range."
 CASE 14
    PRINTf "Out of string space."
 CASE 24
    PRINTf "Device timeout."
 CASE 25
    PRINTf "Device fault."
 CASE 27
    PRINTf "Out of paper."
 CASE 52
    PRINTf "Bad file name or number."
 CASE 53
    PRINTf "File not found."
 CASE 54
    PRINTf "Bad file mode."
 CASE 55
    PRINTf "File already open."
 CASE 57
    PRINTf "Device I/O error."
 CASE 58
    PRINTf "File already exists."
 CASE 59
    PRINTf "Bad record length."
 CASE 61
    PRINTf "Disk full."
 CASE 62
    PRINTf "Input past eof."
 CASE 63
    PRINTf "Bad record length."
 CASE 64
    PRINTf "Bad filename."
 CASE 67
    PRINTf "Not enough file handles."
 CASE 68
    PRINTf "Device unavailable."
 CASE 70
    PRINTf "Permission denied."
 CASE 71
    PRINTf "Disk not ready."
 CASE 72
    PRINTf "Disk-media error."
 CASE 75
    PRINTf "Path/File access error."
 CASE 76
    PRINTf "Pathname not found."
 CASE 81
    PRINTf "Invalid name."
 CASE 90
    PRINTf "Too many processes."
 CASE ELSE
    PRINTf "Untrapped error" + STR$(Var) + "."
 END SELECT
 END SUB

' shells to DOS and runs command.
SUB DOSCommand(CommandLine3$)
 ON LOCAL ERROR GOTO Dos.Error1
 ' clear screen
 COLORf Plain
 CLS
 ' open filename.
 Close #1
 DOSfilename$ = "DOSEXIT"+MID$(STR$(Process.Number), 2)+".BAT"
 Open DOSfilename$ For Output Shared As #1
 ' write DOS commands.
 Print #1, CommandLine3$
 Print #1,"PAUSE"
 Print #1,"EXIT"
 Close #1
 ' store current drive/path.
 Var$=Curdir$
 ' shell to batch file.
 Shell DOSfilename$
 ' restore drive/path.
 Chdrive Var$
 Chdir Var$
Dos.Resume1:
 EXIT SUB
Dos.Error1:
 RESUME Dos.Resume1
END SUB

' display screen border.
SUB DisplayScreen2
 CLS
 COLORf Magenta
 PRINTf CHR$(ULcorner) + STRING$(76, Hline) + CHR$(URcorner)
 FOR Var2 = 2 TO 23
    LOCATEf Var2, 1, 0
    PRINTf CHR$(Vline)
    LOCATEf Var2, 78, 0
    PRINTf CHR$(Vline)
 NEXT
 LOCATEf 24, 1, 0
 PRINTf CHR$(LLcorner) + STRING$(76, Hline) + CHR$(LRcorner)
 COLORf Plain
END SUB

' display boot usage.
SUB DisplayBootUsage
 CLS
 COLORf White
 LOCATEf 1, 1, 0
 PRINTf "Hex Editor " + Version + " " + Release + "."
 COLORf Green
 LOCATEf 2, 1, 0
 PRINTf "Command Usage:"
 COLORf Yellow
 LOCATEf 3, 1, 0
 PRINTf "   Hexedit [@]<filename.ext>, [@]<filename.ext>, ..."
 COLORf Green
 LOCATEf 4, 1, 0
 PRINTf "Where:"
 COLORf Yellow
 LOCATEf 5, 1, 0
 PRINTf "   <filename.ext> is the file to edit. May include drive/pathname, and"
 LOCATEf 6, 1, 0
 PRINTf "   supports long filenames in quotes. Filename may be omitted. Multiple"
 LOCATEf 7, 1, 0
 PRINTf "   files allowed with * and ? characters. Maximum of 9 files available."
 LOCATEf 8, 1, 0
 PRINTf "   Filename prepended with @ loads filelist from contents of file."
 COLORf Green
 LOCATEf 9, 1, 0
 PRINTf "Example:"
 COLORf Yellow
 LOCATEf 10, 1, 0
 PRINTf "   Hexedit " + CHR$(34) + "\dos\page.com" + CHR$(34)
 LOCATEf 11, 1, 0
 PRINTf "   Or use the file menu box by starting Hexedit without a filename."
 COLORf Green
 LOCATEf 12, 1, 0
 PRINTf "File Menu Box Usage:"
 COLORf Yellow
 LOCATEf 13, 1, 0
 PRINTf "   Navigate using cursors, selecting with <enter>, and switch windows"
 LOCATEf 14, 1, 0
 PRINTf "   with <tab> and Shift-<tab>. Exits to editor or DOS with <escape>."
 COLORf Green
 LOCATEf 15, 1, 0
 PRINTf "File Editor Usage:"
 COLORf Yellow
 LOCATEf 16, 1, 0
 PRINTf "   Enter editing functions or cursor movement through the hex values,"
 LOCATEf 17, 1, 0
 PRINTf "   while changing them with <enter>, <delete> or <insert> as you edit."
 COLORf Green
 LOCATEf 18, 1, 0
 PRINTf "Author status:"
 COLORf Yellow
 LOCATEf 19, 1, 0
 PRINTf "   Written by: Erik Jon Oredson AS. Csci"
 LOCATEf 20, 1, 0
 PRINTf "   Email: eoredson@yahoo.com"
 LOCATEf 21, 1, 0
 PRINTf "   Urls: www.simtel.net www.filegate.net"
END SUB

' display main program editing screen.
SUB DisplayScreen
CALL HMouse
CLS
COLORf Magenta
LOCATEf 1, 1, 0
PRINTf " " + CHR$(ULcorner)
PRINTf STRING$(3,HLine)
COLORf White
PRINTf "File"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Charts"
COLORf Magenta
PRINTf STRING$(4,HLine)
COLORf White
PRINTf "Dump"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Edit"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Jump"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Print"
COLORf Magenta
PRINTf STRING$(3,HLine)
COLORf White
PRINTf "Search"
COLORf Magenta
PRINTf STRING$(8,HLine)
PRINTf CHR$(URcorner)
LOCATEf 2, 1, 0
PRINTf " " + CHR$(Vline) + STRING$(75, 32) + CHR$(Vline)
LOCATEf 3, 1, 0
PRINTf " " + CHR$(Vline) + " "
COLORf Green
PRINTf CHR$(ULcorner) + STRING$(46, Hline) + CHR$(URcorner) + " "
PRINTf CHR$(ULcorner) + STRING$(22, Hline) + CHR$(URcorner)
COLORf White
PRINTf "x"
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 4, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "0"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "<"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline)
COLORf White
PRINTf "?"
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 5, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "1"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "|"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 6, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "2"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 7, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "3"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 8, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "4"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 9, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "5"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 10, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "6"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 11, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "7"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 12, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "8"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 13, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "9"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 14, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "A"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 15, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "B"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 16, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "C"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 17, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "D"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 18, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "E"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 19, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "F"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "|"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 20, 1, 0
PRINTf " " + CHR$(Vline) + " "
COLORf Green
PRINTf CHR$(LLcorner) + STRING$(46, Hline) + CHR$(LRcorner)
COLORf White
PRINTf ">"
COLORf Green
PRINTf CHR$(LLcorner) + STRING$(22, Hline) + CHR$(LRcorner) + " "
' check to skip info line area.
IF ScreenRow THEN
   COLORf Magenta
   LOCATEf 21, 1, 0
   PRINTf " " + CHR$(LLcorner) + STRING$(75, Hline) + CHR$(LRcorner)
   COLORf Plain
   CALL SMouse
   EXIT SUB
END IF
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 21, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-A Append bytes, Alt-M Append string, Alt-C ANSI Chart, Alt-N New File "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 22, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-H HEX Chart, Alt-R Redraw, Alt-S Search bytes, Alt-U Undo, Alt-X Exit "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 23, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-J Jump, Alt-K Search string, Alt-D Dump, Alt-P Print, Alt-Z Undo All. "
COLORf Magenta
PRINTf CHR$(Vline)
COLORf Magenta
LOCATEf 24, 1, 0
PRINTf " " + CHR$(LLcorner) + STRING$(75, Hline) + CHR$(LRcorner)
COLORf Plain
CALL SMouse
END SUB

REM End-of-subprogram. Please deliver the cats now.
