/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                Scheduler definitions used in BinkleyTerm                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Definitions for day of the week */

#define DAY_SUNDAY		0x01
#define DAY_MONDAY		0x02
#define DAY_TUESDAY		0x04
#define DAY_WEDNESDAY	0x08
#define DAY_THURSDAY	0x10
#define DAY_FRIDAY		0x20
#define DAY_SATURDAY	0x40
#define DAY_UNUSED		0x80

#define DAY_WEEK	(DAY_MONDAY|DAY_TUESDAY|DAY_WEDNESDAY|DAY_THURSDAY|DAY_FRIDAY)
#define DAY_WKEND	(DAY_SUNDAY|DAY_SATURDAY)

/* Definitions for matrix behavior */

#define MAT_CM			0x0001
#define MAT_DYNAM		0x0002
#define MAT_BBS			0x0004
#define MAT_NOREQ		0x0008
#define MAT_OUTONLY		0x0010
#define MAT_NOOUT		0x0020
#define MAT_FORCED		0x0040
#define MAT_LOCAL		0x0080
#define MAT_SKIP		0x0100
#define MAT_NOMAIL24	0x0200
#define MAT_NOOUTREQ	0x0400
#define MAT_NOCM		0x0800
#define MAT_HIPRICM		0x1000
#define MAT_KILLBAD		0x2000	/* Kill *.$$? packets */
#define MAT_RESERVED3	0x4000
#define MAT_RESERVED4	0x8000

/*********************************************************************
* If either of these structures are changed, don't forget to change  *
* the BinkSched string in sched.c, as well as the routines that read *
* and write the schedule file (read_sched, write_sched)!!!           *
*********************************************************************/
typedef struct _bink_event
{
	short minute;				/* Start of Event, minutes past 12AM */
	short length;				/* Number of minutes event runs      */
	short behavior;				/* Behavior mask                     */
	short wait_time;			/* Avg seconds to wait between dials */
	short node_cost;			/* Max cost node to call, this event */
	short with_connect;			/* Number of calls to make w/carrier */
	short no_connect;			/* Number of calls to make w/o DCD   */
	unsigned char days;			/* Bit field for days to execute     */
	char last_ran;				/* Day of month event last ran       */
	unsigned long mailqsize;	/* Mail amount needed to make call   */
	unsigned char errlevel[9];	/* Errorlevel exits                  */

	char cmd[32];				/* Chars to append to packer,        */
								/* aftermail and cleanup             */
	char month;					/* Month when to do it               */
	char day;					/* Day of month to do it             */
	char err_extent[6][4];		/* 3 byte ext's for errlvls 4-9      */
	unsigned char faxerrlevel;	/* Exit for fax reception            */
	unsigned char extra[3];		/* Extra space for later             */
} BINK_EVENT, *BINK_EVENTP;

typedef struct _history
{
	short which_day;			/* Day number for this record        */
	short bbs_calls;			/* Number of BBS callers             */
	short mail_calls;			/* Number of mail calls              */
	short calls_made;			/* Number of outgoing calls made     */
	short connects;				/* Number of outbound call successes */
	short files_in;				/* Number of files received          */
	short files_out;			/* Number of files sent              */
	short last_caller;			/* Type of last call                 */
	ADDR last_addr;				/* Address of last, excl. Domain     */
	char last_Domain[32];		/* Domain of last                    */
	long last_Elapsed;			/* Time of last outbound session     */
	ADDR next_addr;				/* Address of next, excl. Domain     */
	char next_Domain[32];		/* Domain of next                    */
	long callcost;				/* Cumulative of call costs          */
	long size_in;				/* Size of files received            */
	long time_in;				/* Time of files received            */
	long err_in;				/* Errors while receiving files      */
	long size_out;				/* Size of files sent                */
	long time_out;				/* Time of files sent                */
	long err_out;				/* Errors while sending files        */
} HISTORY, *HISTORYP;

