//======================================================================================//
//=                         D C L   C O D E   G E N E R A T O R                        =//
//======================================================================================//
//=  File        : DCG.DCL                                                             =//
//=  Description : DCL Definitions for DCG                                             =//
//=  Version     : 2.00                                                                =//
//=  Author      : Carlos Legarreta                                                    =//
//=  Date        : March 31, 1996                                                      =//
//======================================================================================//
// This file and all distribution files are subject to the license agreemen as stated   //
// in the documentation.                                                                //
//======================================================================================//

dcl_settings : default_dcl_settings { audit_level = 0; }

/*--------------------------------------------------------------------------------------*/
/* DCG : Main Program Dialogue Box                                                      */
/*--------------------------------------------------------------------------------------*/
dcg : dialog {
    key = "dcg";
    : row {
        : boxed_column {
            label = "DCL Work File";
            : text { 
                key = "dcg_dclfile"; 
                width = 31;
                fixed_width = true;
            }
        }
        : boxed_column {
            label = "Active Dialogue Box Name";
            : text { 
                key = "dcg_dlgname"; 
                width = 31;
                fixed_width = true;
            }
        }
    }
    : row {
        : column {
        children_fixed_width = true;
            : button {
                label = "File";
                key = "dcg_file";
                mnemonic = "F";
                width = 16;
            }
            : button {
                label = "Options";
                key = "dcg_opti";
                mnemonic = "O";
                width = 16;
            }
        }
        : column {
            children_fixed_width = true;
            : button {
                label = "View DCL";
                key = "dcg_view";
                mnemonic = "V";
                width = 16;
            }
            : button {
                label = "ACAD.DCE";
                key = "dcg_adce";
                mnemonic = "C";
                width = 16;
            }
        }
        : column {
            children_fixed_width = true;
            : button {
                label = "Dialog Manager";
                key = "dcg_dlgm";
                mnemonic = "M";
                width = 16;
            }
            : button {
                label = "Dialog Name";
                key = "dcg_name";
                mnemonic = "N";
                width = 16;
            }
        }
        : button {
            label = "Preview...";
            key = "dcg_prev";
            mnemonic = "P";
            height = 3.3;
            is_default = true;
            width = 16;
        }
    }
    : spacer { height = 0.5; }
    : row {
        : list_box {
            label = "Predefined Elements:";
            key = "dcg_pred";
            width = 25;
            fixed_width = true;
        }
        spacer_1;
        : boxed_column {
            key = "tile_cmds";
            children_alignment = centered;
            : button {
                key = "tile_add";
                label = ">> Add >>";
                mnemonic = "A";
            }
            : button {
                key = "tile_edt";
                label = "Edit";
                mnemonic = "E";
            }
            : button {
                key = "tile_rep";
                label = "Replace";
                mnemonic = "R";
            }
            : button {
                key = "tile_del";
                label = "Delete";
                mnemonic = "D";
            }
            : button {
                key = "tile_mov";
                label = "Move";
                mnemonic = "v";
            }
        }
        spacer_1;
        : list_box {
            label = "Selected Elements:" ;
            key = "dcg_slct";
            width = 25;
            fixed_width = true;
        }
    }
    spacer;
    : row {
        : column {
            : row {
                fixed_width = true;
                alignment = right;
                : ok_button {
                    label = "Exit";
                    mnemonic = "x";
                    key = "dcg_exit";
                    is_default = false;
                }
                : spacer { width = 1; }
                : help_button { key = "dcg_help"; }
                : spacer { width = 1; }
                : info_button { key = "dcg_info"; }
            }
            errtile;
        }
        : column {
            : row {
                spacer_0;
                : image {
                    key = "dcg_img";
                    width = 3.5;
                    height = 1;
                    color = -15;
                    alignment = centered;
                }
            }
        }
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_FILE : File functions menu.                                                      */
/*--------------------------------------------------------------------------------------*/
dcg_file : dialog {
    label = "File";
    : column {
        : button {
            label = "New";
            key = "file_new";
            mnemonic = "N";
        }
        : button {
            label = "Open...";
            key = "file_opn";
            mnemonic = "O";
        }
        : button {
            label = "Save";
            key = "file_sav";
            mnemonic = "S";
        }
        : button {
            label = "Save As...";
            key = "file_sas";
            mnemonic = "A";
        }
        : button {
            label = "Merge DCL...";
            key = "file_mrg";
            mnemonic = "M";
        }
        : button {
            label = "Print";
            key = "file_prn";
            mnemonic = "P";
        }
        : text {
            label = "-------------";
            alignment = centered;
        }
        spacer;
        ok_button;
    }
}



/*--------------------------------------------------------------------------------------*/
/* DCG_CON_UNSAVED : Confirm NEW, OPEN, and EXIT.                                       */
/*--------------------------------------------------------------------------------------*/
dcg_conf_unsaved : dialog {
    key = "file";
    : text {
        label = "WARNING!";
        alignment = centered;
        is_bold = true;
    }
    : text {
        label = "Current file has been modified.";
        alignment = centered;
    }
    : text {
        label = "Do you want to save the changes?";
        alignment = centered;
    }
    spacer_1;
    : row {
        width = 40;
        fixed_width = true;
        : spacer {
        }
        : button {
            key = "yes";
            label = "Yes";
            mnemonic = "Y";
            width = 10;
            fixed_width = true;
        }
        : button {
            key = "no";
            label = "No";
            mnemonic = "N";
            width = 10;
            fixed_width = true;
        }
        : button {
            key = "cancel";
            label = "Cancel";
            mnemonic = "C";
            is_default = true;
            width = 10;
            fixed_width = true;
        }
        spacer;
    }
}




/*--------------------------------------------------------------------------------------*/
/* DCG_FILE_NEW : Confirm deletion of current dlg box.                                  */
/*--------------------------------------------------------------------------------------*/
dcg_file_new : dialog {
    label = "New";
    : text {
        label = "   Clear current Dialog?   ";
    }
    : row {
        spacer_1;
        : button {
            label = "Yes";
            key = "accept";
            mnemonic = "Y";
        }
        : button {
            label = "No";
            key = "cancel";
            mnemonic = "N";
            is_default = true;
            is_cancel = true;
        }
        spacer_1;
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_OPTIONS : Options menu dialogue box                                              */
/*--------------------------------------------------------------------------------------*/
dcg_options : dialog {
    label = "Options";
    : row {
        : boxed_column {
            label = "DCG Preferences";
            : toggle {
                label = "Confirm on [DELETE]";
                mnemonic = "D";
                key = "dcg_confdel";
            }
            : toggle {
                label = "Confirm on [REPLACE]";
                mnemonic = "L";
                key = "dcg_confrep";
            }
            : toggle {
                label = "Auto [EDIT] after [ADD]";
                mnemonic = "E";
                key = "dcg_autoedt";
            }
            : toggle {
                label = "Auto load ACAD.DCE upon error";
                mnemonic = "A";
                key = "dcg_autodce";
            }
            : toggle {
                label = "Process all dialogs for [PREVIEW]";
                mnemonic = "i";
                key = "dcg_procall";
            }
            : toggle {
                label = "Hide DCG during [PREVIEW]";
                mnemonic = "P";
                key = "dcg_hidedcg";
            }
            spacer;
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "TAB spacing:";
                    mnemonic = "T";
                    key = "dcg_tabs";
                    edit_width = 2;
                    edit_limit = 1;
                    action = "(set_tile \"dcg_slid\" $value) (if (/= $value \"\")(set_tile \"dcg_tabs\" (get_tile \"dcg_slid\")))";
                }
                : slider {
                    key = "dcg_slid";
                    min_value = 0;
                    max_value = 5;
                    action = "(set_tile \"dcg_tabs\" $value)";
                    width = 12;
                }
            }
            : popup_list {
                label = "Printer Port:";
                key = "dcg_prntdev";
                mnemonic = "P";
                list = "[none]\nPRN\nLPT1\nLPT2\nLPT3\nCOM1\nCOM2\nCOM3";
                edit_width = 8;
                value = "0";
            }
        }
        spacer;
        : boxed_column {
            label = "DCL Code Settings";
            width = 31;
            : boxed_radio_column {
                label = "Semantic Audit Level";
                key = "dcl_sett";
                : radio_button {
                    label = "0: No Checking";
                    key = "0";
                    mnemonic = "0";
                }
                : radio_button {
                    label = "1: Errors";
                    key = "1";
                    mnemonic = "1";
                }
                : radio_button {
                    label = "2: Warnings";
                    key = "2";
                    mnemonic = "2";
                }   
                : radio_button {
                    label = "3: Hints";
                    key = "3";
                    mnemonic = "3";
                }
            }
            spacer;
            : row {
            children_alignment = bottom;
                : edit_box {
                    label = "TAB spacing:";
                    mnemonic = "T";
                    key = "dcl_tabs";
                    edit_width = 2;
                    edit_limit = 2;
                    action = "(set_tile \"dcl_slid\" $value) (if (/= $value \"\") (set_tile \"dcl_tabs\" (get_tile \"dcl_slid\")))";
                }
                : slider {
                    key = "dcl_slid";
                    min_value = 0;
                    max_value = 30;
                    action = "(set_tile \"dcl_tabs\" $value)";
                    width = 12;
                }
            }
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button { is_default = false; }
            spacer_1;
            : button {   
                label = "  Save  ";
                key = "opt_save";
                mnemonic = "S";
                is_default = true;
            }        
            spacer_1;
            cancel_button;
            spacer_1;
            help_button;
        }
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_DLG_MAN : Dialogue Box Manager, create/switch between/delete dialogue boxes.     */
/*--------------------------------------------------------------------------------------*/  
dcg_dlg_man : dialog {
    label = "Dialogue Box Manager";
    initial_foxus = "dialogs";
    spacer;
    : row {
        : list_box {
            label = "Defined dialogue boxes:";
            key = "dlgs";
            mnemonic = "D";
            width = 25;
        }
        spacer;
        : column {
            width = 10;
            spacer_1;
            : button {
                label = "New";
                key = "new";
                mnemonic = "N";
            }
            : button {
                label = "Name";
                key = "name";
                mnemonic = "m";
            }
            : spacer { height = 0.2; }
            : button {
                label = "Delete";
                key = "delete";
                mnemonic = "D";
            }
            : text {
                label = "-----------";
                alignment = centered;
            }
            : button {
                label = "Close";
                key = "close";
                is_default = true;
            }
            : button {
                label = "Help";
                mnemonic = "H";
                key = "help";
            }
            spacer;
        }
        spacer;
    }
    errtile;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_DLGNAME : Input Dialogue Box for "[DIALOG NAME]".                                */
/*--------------------------------------------------------------------------------------*/  
dcg_dlgname : dialog {
    label = "Active Dialogue Box Name";
    initial_focus = "dlg_name";
    spacer;
    : edit_box {
        label = "Name:";
        key = "dlg_name";
        mnemonic = "D";
        edit_width = 30;
        edit_limit = 60;
        allow_accept = true;
    }
    spacer;
    ok_cancel_help;
    errtile;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_VIEW_DCLCODE : Dialog to View Current DCL Code.                                  */
/*--------------------------------------------------------------------------------------*/
dcg_view_dclcode : dialog {
    key = "title";
    initial_focus = "dcl_code";
    : list_box {
        key = "dcl_code";
        width = 65;
        height = 15;
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            spacer_1;
            help_button;
        }
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_DLGS_SELECT : Select from all dlgs or current.                                   */
/*--------------------------------------------------------------------------------------*/
dcg_dlgs_select : dialog {
    key = "title";
    : boxed_radio_column {
        label = "Select";
        key = "selection";
        : radio_button {
            label = "Active dialogue box";
            key = "0";
            value = "1";
        }
        : radio_button {
            label = "All dialogue boxes";
            key = "1";
        }
        spacer;
    }
    spacer;
    ok_cancel;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_VIEW_ACADDCE : Dialog to View ACAD.DCE Error File.                               */
/*--------------------------------------------------------------------------------------*/
dcg_view_acaddce : dialog {
    label = "ACAD.DCE Error File";
    initial_focus = "dce_text";
    : list_box {
        key = "dce_text";
        width = 65;
        height = 15;
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            spacer_1;
            help_button;
        }
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_MOVE : MOVE Tile Dialogue Box.                                                   */
/*--------------------------------------------------------------------------------------*/
dcg_move : dialog {
    label = "Move";
    initial_focus = "dcg_slct";
    : text {
        key = "dcg_text";
        width = 25;
    }
    : list_box {
        key = "dcg_slct";
//        height = 10;
        width = 25;
    }
    ok_cancel_help;
    errtile;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_DELETE_CONFIRM : Confirm "[DELETE]" command.                                     */
/*--------------------------------------------------------------------------------------*/
dcg_delete_confirm : dialog {
    key = "del_lbl";
    spacer;
    : column {
        children_alignment = centered;
        : text { 
            width = 30;
            key = "del_msg";
        }                  
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {        
                label = "Yes";
                key   = "dcg_yes";
                mnemonic = "Y";
                width = 10;
            }
            spacer;
            : button {  
                label = "No";
                key   = "dcg_no";
                mnemonic = "N";
                width = 10;
            }
        }
    }
    spacer;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_OPEN_CONFIRM : Confirms "[OPEN]" if DCL not saved.                               */
/*--------------------------------------------------------------------------------------*/
dcg_open_confirm : dialog {
    label = "WARNING!";
    spacer;
    : row {
        : column {
            children_alignment = centered;
            : text { label = " Current dialog has been modified. "; }
            : text { label = "ALL CHANGES WILL BE LOST."; }
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {
                label = "Continue...";
                is_default = false;
            }
            spacer;
            : cancel_button { 
                label = "   Cancel   ";
                is_default = true; 
            }
        }
    }
    spacer;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EXIT : Confirm "[EXIT]" Dialogue Box.                                            */
/*--------------------------------------------------------------------------------------*/
dcg_exit : dialog {
    key = "ext_lbl";
    spacer;
    : column {
        children_alignment = centered;
        : text { 
            width = 35;
            key = "ext_msg";
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {        
                label = "  Yes  ";
                key   = "dcg_yes";
                mnemonic = "Y";
            }
            spacer;
            : button {  
                label = "  No  ";
                key   = "dcg_no";
                mnemonic = "N";
            }
        }
    }
    spacer;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_INFO : Product Information Dialog.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_info : dialog {
    label = "About DCG...";
    : row {
        children_alignment = bottom;
        spacer_1;
        : image {
            key = "dcg_img";
            height = 4;
            aspect_ratio = 1.5;
            color  = -15;
        }
        : text_part {    
            width = 24;
            key   = "inf_text1";
        }
    }
    : text_part { 
        label = "_______________________________________";
        alignment = centered;
    }
    : paragraph {
        children_alignment = centered;
        : text_part {
            label = "";
            key   = "inf_text2";
            width = 43;

        }
        spacer_1;
        : text_part {     
            label = "";
            key   = "inf_text3";
        }
        : text_part {
            label = "";
            key   = "inf_text4";
        }
        : text_part {
            label = "";
            key   = "inf_text5";
        }
    }
    spacer_1;
    ok_only;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_KEY_LIST : Lists all keys currently being used.                                  */
/*--------------------------------------------------------------------------------------*/
dcg_key_list : dialog {
    label = "Defined Keys";
    spacer;
    : concatenation {
        : text_part {
            label = "Key";
            fixed_width = true;
            width = 15;
        }
        : text_part {
            label = "Tile type";
            fixed_width = true;
            width = 15;
        }
        : text_part {
            label = "Label";
            fixed_width = true;
            width = 15;
        }
    }
    : list_box {
        key = "key_list";
        fixed_width = true;
        tabs = "15 30";
        width = 45;
    }
    spacer;
    ok_only;
}


//======================================================================================//
//=         PROTOTYPES & SUBASSEMBLIES - Used by Some Dialogue Box Definitons          =//
//======================================================================================//

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_LABEL : "TILE LABEL" Edit Box                                                */
/*--------------------------------------------------------------------------------------*/
dcg_edt_label : edit_box {
    label = "Label: ";
    key   = "label";
    mnemonic = "L";
    allow_accept = true;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_MNEMONIC : "TILE MNEMONIC" Edit Box w/ Slider.                               */
/*--------------------------------------------------------------------------------------*/
dcg_edt_mnemonic : row {
    key = "mnem_assy";
    : edit_box { 
        label = "Mnemonic:";
        key   = "mnemonic";
        mnemonic = "M";
        edit_width = 1;
        edit_limit = 1;
        allow_accept = true;
        is_enabled = false;
    }
    : slider {
        key = "mnemonic_slider";
        min_value = 1;
        max_value = 40;
        width = 12;
        is_enabled = false;
        alignment = bottom;
        action = "(set_tile \"mnemonic\" (substr (get_tile \"label\") (atoi $value) 1))";
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_VALUE : "TILE VALUE" Edit Box                                                */
/*--------------------------------------------------------------------------------------*/
dcg_edt_value : edit_box {
    label = "Value: ";
    key   = "value";
    mnemonic = "V";
    allow_accept = true;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_KEY : "TILE KEY" Edit Box                                                    */
/*--------------------------------------------------------------------------------------*/
dcg_edt_key : row {
    : edit_box {
        label = "Key:   ";
        key   = "key";
        mnemonic = "K";
        allow_accept = true;
    }
    : button {
        label = "?";
        key = "key_lst";
        width = 1;
        fixed_width = true;
        mnemonic = "?";
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ACTION : "ACTION" Edit Box                                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edt_action : edit_box {
    label = "Action:";
    key = "action";
    mnemonic = "A";
    allow_accept = true;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_LIST : "LIST" Edit Box                                                       */
/*--------------------------------------------------------------------------------------*/
dcg_edt_list : edit_box {
    label = "List:";
    key = "list";
    mnemonic = "i";
    allow_accept = true;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_TABS : "TABS" Edit Box                                                       */
/*--------------------------------------------------------------------------------------*/
dcg_edt_tabs : edit_box {
    label = "Tabs:";
    key   = "tabs";
    mnemonic = "b";
    allow_accept = true;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ENABLED : "...IS ENABLED" Toggle Switch                                      */
/*--------------------------------------------------------------------------------------*/
dcg_edt_enabled : toggle {
    label = "Enabled";
    key = "is_enabled";
    mnemonic = "E";
    value = "1";
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_TABSTOP : "...IS TAB STOP" Toggle Switch                                     */
/*--------------------------------------------------------------------------------------*/
dcg_edt_tabstop : toggle { 
    label = "TAB Stop";
    key = "is_tab_stop";
    mnemonic = "T";
    value = "1";
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ACCEPT : "ALLOW ACCEPT" Toggle Switch                                        */
/*--------------------------------------------------------------------------------------*/
dcg_edt_accept : toggle {
    label = "Allow Accept";
    key   = "allow_accept";
    mnemonic = "c";
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ALIGNMENT : "ALIGNMENT" Popup List                                           */
/*--------------------------------------------------------------------------------------*/
dcg_edt_alignment : popup_list {
    label = "Alignment:";
    mnemonic = "g";
    list = "[default]\nCentered\nLeft\nRight\nTop\nBottom";
    value = "0";
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ATTRIB1 : "..IS ENABLED/TAB STOP" Subassembly                                */
/*--------------------------------------------------------------------------------------*/
dcg_edt_attrib1 : boxed_row {
    label = "Attributes";
    dcg_edt_enabled;
    dcg_edt_tabstop;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_ATTRIB2 : "...IS ENABLED/TAB STOP/ALLOW ACCEPT"                              */
/*--------------------------------------------------------------------------------------*/
dcg_edt_attrib2 : boxed_row {
    label = "Attributes";
    dcg_edt_enabled;
    dcg_edt_tabstop;
    dcg_edt_accept;
}


/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_IMGCOLOR : Color Popup List for Image tiles                                  */
/*--------------------------------------------------------------------------------------*/
dcg_edt_imgcolor : popup_list {
    label = "Color: ";
    key   = "image_color_list";
    mnemonic = "l";
    list = "[default]\nWhite\nBlack\nRed\nYellow\nGreen\nCyan\nBlue\nMagenta\nDialog line\nDialog foreground\nDialog background\nGraphics background";
    value = "0";
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_IMGRATIO : Image "ASPECT RATIO" Attribute                                    */
/*--------------------------------------------------------------------------------------*/
dcg_edt_imgratio : row {
    children_alignment = bottom;
    : edit_box {
        label = "Aspect Ratio:";
        key   = "aspect_ratio";
        mnemonic = "R";
        edit_width = 3;
        allow_accept = true;
        action = "(set_tile \"ar_s\" $value) (if (/= $value \"\") (set_tile \"aspect_ratio\" (get_tile \"ar_s\")))";
    }
    : slider {
        key = "ar_s";
        min_value = 0;
        max_value = 100;
        action = "(set_tile \"aspect_ratio\" $value)";
        width = 12;
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_CHILDREN : Cluster's Children Attributes - Sub.                              */
/*--------------------------------------------------------------------------------------*/
dcg_edt_children : boxed_column {
    label = "Cluster Children";
    : dcg_edt_alignment {
        key = "children_alignment";
        mnemonic = "n";
    }
    : row {
        children_alignment = bottom;
        : toggle {
            label = "Fixed Height";
            mnemonic = "d";
            key = "children_fixed_height";
        }
        : toggle {
            label = "Fixed Width";
            mnemonic = "d";
            key = "children_fixed_width";
        }
    }
} 

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_WIDTH : Width attribute subassembly.                                         */
/*--------------------------------------------------------------------------------------*/
dcg_edt_width : row {
    children_alignment = bottom;
    : edit_box {
        label = "Width: ";
        key   = "width";
        mnemonic = "W";
        edit_width = 2;
        allow_accept = true;
        action = "(set_tile \"w_s\" $value) (if (/= $value \"\") (set_tile \"width\" (get_tile \"w_s\")))";
    }
    : slider {
        key = "w_s";
        min_value = 0;
        max_value = 99;
        action = "(set_tile \"width\" $value)";
        width = 12;
    }
    : toggle {
        label = "Fixed";
        mnemonic = "x";
        key = "fixed_width";
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_HEIGHT1 : Height attribute subassembly.  #1                                  */
/*--------------------------------------------------------------------------------------*/
dcg_edt_height1 : row {
    children_alignment = bottom;
    : edit_box {
        label = "Height:";
        mnemonic = "H";
        key   = "height";
        edit_width = 2;
        allow_accept = true;
        action = "(set_tile \"h_s\" $value) (if (/= $value \"\") (set_tile \"height\" (get_tile \"h_s\")))";
    }
    : slider {
        key = "h_s";
        min_value = 0;
        max_value = 99;
        action = "(set_tile \"height\" $value)";
        width = 12;
    }
    : toggle {
        label = "Fixed";
        mnemonic = "x";
        key   = "fixed_height";
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_HEIGHT2 : Height attribute subassembly.  #2                                  */
/*--------------------------------------------------------------------------------------*/
dcg_edt_height2 : row {
    children_alignment = bottom;
    : edit_box {
        label = "Height:";
        mnemonic = "H";
        key   = "height";
        edit_width = 2;
        allow_accept = true;
        action = "(set_tile \"h_s\" $value) (if (/= $value \"\") (set_tile \"height\" (get_tile \"h_s\")))";
    }
    : slider {
        key = "h_s";
        min_value = 0;
        max_value = 99;
        action = "(set_tile \"height\" $value)";
        width = 12;
    }
    : toggle {
        label = "Fixed";
        mnemonic = "x";
        key   = "fixed_height";
        value = "1";
    }
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_SIZE1 : Size/Layout Attributes - Subassembly  (fixed_height = false)         */
/*--------------------------------------------------------------------------------------*/
dcg_edt_size1 : boxed_column {
    label = "Size/Layout";
    dcg_edt_width;
    dcg_edt_height1;
    spacer;
    : dcg_edt_alignment { key = "alignment"; }
    spacer;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDT_SIZE2 : Size/Layout Attributes - Subassembly  (fixed_height = true)          */
/*--------------------------------------------------------------------------------------*/
dcg_edt_size2 : boxed_column {
    label = "Size/Layout";
    dcg_edt_width;
    dcg_edt_height2;
    spacer;
    : dcg_edt_alignment { key = "alignment"; }
    spacer;
}

//======================================================================================//
// =              EDIT COMMAND - Dialog Definitions for all Tile Elements              =//
//======================================================================================//

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_DIALOG : Dialogue Box Attributes.                                           */
/*--------------------------------------------------------------------------------------*/
dcg_edit_dialog : dialog {
    label = "EDIT: Dialogue Box";
    initial_focus = "accept";
    : boxed_column {
        label = "Attributes";
        dcg_edt_label;
        dcg_edt_value;
        dcg_edt_key;
        : edit_box {
            label = "Initial Focus:";
            key = "initial_focus";
            mnemonic = "I";
            allow_accept = true;
        }
    }
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_BUTTON : "BUTTON" Attributes.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_button : dialog {
    label = "EDIT: Button";
    initial_focus = "accept";
    dcg_edt_label;
    dcg_edt_key;
    dcg_edt_action;
    dcg_edt_mnemonic;
    spacer;
    : boxed_row {
        label = "Button Is...";
        : column {
            : toggle {
                label = "Default";
                mnemonic = "f";
                key = "is_default";
            }
            : toggle {
                label = "Cancel";
                mnemonic = "C";
                key = "is_cancel";
            }
        }
        : column {
            dcg_edt_enabled;
            dcg_edt_tabstop;
        }
    }
    spacer;
    dcg_edt_size2;                      // fixed_height = true
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_EDIT_BOX : "EDIT BOX" Attributes.                                           */
/*--------------------------------------------------------------------------------------*/
dcg_edit_edit_box : dialog {
    label = "EDIT: Edit Box";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            : boxed_column {
                label = "Edit...";
                : row {
                    children_alignment = bottom;
                    : edit_box {
                        label = "Width:";
                        key   = "edit_width";
                        mnemonic = "d";
                        edit_width = 3;
                        edit_limit = 3;
                        allow_accept = true;
                        action = "(set_tile \"ew_s\" $value)(if (/= $value \"\") (set_tile \"edit_width\" (get_tile \"ew_s\")))";
                    }
                    : slider {
                        key = "ew_s";
                        min_value = 0;
                        max_value = 256;
                        action = "(set_tile \"edit_width\" $value)";
                        width = 12;
                        fixed_width = true;
                    }
                }
                : row {
                    children_alignment = bottom;
                    : edit_box {
                        label = "Limit:";
                        key   = "edit_limit";
                        mnemonic = "m";
                        edit_width = 3;
                        edit_limit = 3;
                        allow_accept = true;
                        action = "(set_tile \"el_s\" $value)(if (/= $value \"\") (set_tile \"edit_limit\" (get_tile \"el_s\")))";
                    }   
                    : slider {
                        key = "el_s";
                        min_value = 0;
                        max_value = 256;
                        action = "(set_tile \"edit_limit\" $value)";
                        width = 12;
                        fixed_width = true;
                    }
                }
                spacer;
            }
        }
        : column {
            : boxed_row {
                label = "Attributes";
                : column {
                    dcg_edt_enabled;
                    dcg_edt_tabstop;
                }
                : column {
                    dcg_edt_accept;
                }
            }
            spacer;
            dcg_edt_size2;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_IMAGE : "IMAGE" Attributes.                                                 */
/*--------------------------------------------------------------------------------------*/
dcg_edit_image : dialog {
    label = "EDIT: Image";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_imgcolor;
    dcg_edt_imgratio;
    spacer;
    dcg_edt_size1;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_IMAGE_BUTTON : "IMAGE BUTTON" Attributes.                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edit_image_button : dialog {
    label = "EDIT: Image Button";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_action;
    dcg_edt_imgcolor;
    dcg_edt_attrib2;
    dcg_edt_imgratio;
    spacer;
    dcg_edt_size1;
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_LIST_BOX : "LIST BOX" Attributes.                                           */
/*--------------------------------------------------------------------------------------*/
dcg_edit_list_box : dialog {
    label = "EDIT: List Box";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            dcg_edt_list;
            dcg_edt_tabs; 
        }
        : column {
            : boxed_row {
                label = "Attributes";
                : column {
                    dcg_edt_enabled;
                    dcg_edt_tabstop;
                }
                spacer;
                : column {
                    : toggle {
                        label = "Multiple Select";
                        mnemonic = "S";
                        key   = "multiple_select";
                    }
                    dcg_edt_accept;
                }
            }
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_POPUP_LIST : "POPUP LIST" Attributes.                                       */
/*--------------------------------------------------------------------------------------*/
dcg_edit_popup_list : dialog {
    label = "EDIT: Popup List";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            dcg_edt_list;
            dcg_edt_tabs;
        }
        : column {
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "Edit Width:";
                    key   = "edit_width";
                    mnemonic = "d";
                    edit_width = 3;
                    allow_accept = true;
                    action = "(set_tile \"ew_s\" $value)(if (/= $value \"\") (set_tile \"edit_width\" (get_tile \"ew_s\")))";
                }
                : slider {
                    key = "ew_s";
                    min_value = 0;
                    max_value = 256;
                    action = "(set_tile \"edit_width\" $value)";
                    width = 12;
                }
            }
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size2;
        } 
    }
    spacer;
    ok_cancel_help;
}   
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_RADIO_BUTTON : "RADIO BUTTON" Attributes.                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edit_radio_button : dialog {
    label = "EDIT: Radio Button";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size2;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_SLIDER : "SLIDER" Attributes.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_slider : dialog {
    label = "EDIT: Slider";
    initial_focus = "key";
    : row {
        : column {
            dcg_edt_key;
            dcg_edt_action;
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "Def Value:" ;
                    key   = "value";
                    mnemonic = "V";
                    edit_limit = 6;
                    edit_width = 6;
                    allow_accept = true;
                    action = "(set_tile \"v_s\" $value)(if (/= $value \"\") (set_tile \"value\" (get_tile \"v_s\")))";
                }
                : slider {
                    key = "v_s";
                    min_value = -32768;
                    max_value = 32767;
                    value = "0";
                    action = "(set_tile \"value\" $value)";
                    width = 12;
                    fixed_width = true;
                }
            }
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "Min Value:";
                    key   = "min_value";
                    mnemonic = "i";
                    edit_limit = 6;
                    edit_width = 6;
                    allow_accept = true;
                    action = "(set_tile \"mi_s\" $value)(if (/= $value \"\") (set_tile \"min_value\" (get_tile \"mi_s\")))";
                }
                : slider {
                    key = "mi_s";
                    min_value = -32768;
                    max_value = 32767;
                    value = "0";
                    action = "(set_tile \"min_value\" $value)";
                    width = 12;
                    fixed_width = true;
                }
            }
            : row {
                children_alignment = bottom;
                : edit_box {                 
                    label = "Max Value:";
                    key   = "max_value";
                    mnemonic = "u";
                    edit_limit = 6;
                    edit_width = 6;
                    allow_accept = true;
                    action = "(set_tile \"ma_s\" $value)(if (/= $value \"\") (set_tile \"max_value\" (get_tile \"ma_s\")))";
                }
                : slider {
                    key = "ma_s";
                    min_value = -32768;
                    max_value = 32767;
                    value = "10000";
                    action = "(set_tile \"max_value\" $value)";
                    width = 12;
                    fixed_width = true;
                }
            }
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "Small Inc:";
                    key   = "small_increment";
                    mnemonic = "S";
                    edit_width = 6;
                    allow_accept = true;
                    action = "(set_tile \"si_s\" $value)(if (/= $value \"\") (set_tile \"small_increment\" (get_tile \"si_s\")))";
                }
                : slider {
                    key = "si_s";
                    min_value = 0;
                    max_value = 1000;
                    action = "(set_tile \"small_increment\" $value)";
                    width = 12;
                    fixed_width = true;
                }
            }
            : row {
                children_alignment = bottom;
                : edit_box {
                    label = "Big Inc:  ";
                    key   = "big_increment";
                    mnemonic = "B";
                    edit_width = 6;
                    allow_accept = true;
                    action = "(set_tile \"bi_s\" $value)(if (/= $value \"\") (set_tile \"big_increment\" (get_tile \"bi_s\")))";
                }
                : slider {
                    key = "bi_s";
                    min_value = 0;
                    max_value = 10000;
                    action = "(set_tile \"big_increment\" $value)";
                    width = 12;
                    fixed_width = true;
                }
            }
        }
        : column {
            : boxed_radio_row {
                label = "Layout";
                key = "layout";
                value = "0";
                : radio_button {
                    label = "Horizontal";
                    key   = "0";
                    mnemonic = "z";
                }
                : radio_button {
                    label = "Vertical";
                    key   = "1";
                    mnemonic = "r";
                }
            }
            spacer;
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
}
   
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_SPACER : "SPACER" Attributes.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_spacer : dialog {
    label = "EDIT: Spacer";
    initial_focus = "key";
    dcg_edt_key;
    spacer;
    dcg_edt_size1;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_TEXT : "TEXT" Attributes.                                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edit_text : dialog {
    label = "EDIT: Text";
    initial_focus = "accept";
    dcg_edt_label;
    dcg_edt_value;
    dcg_edt_key;
    : boxed_row {
        label = "Attribute:";
        spacer_1;
        : toggle {
            label = "Bold Text";
            key = "is_bold";
            mnemonic = "B";
        }
    }
    spacer;
    dcg_edt_size2;                      // fixed_height = true
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_TEXT_PART : "TEXT PART" Attributes.                                         */
/*--------------------------------------------------------------------------------------*/
dcg_edit_text_part : dialog {
    label = "EDIT: Text Part";
    initial_focus = "accept";
    dcg_edt_label;
    dcg_edt_key;
    spacer;
    dcg_edt_size2;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_TOGGLE : "TOGGLE" Attributes.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_toggle : dialog {
    label = "EDIT: Toggle";
    initial_focus =  "label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size2;
        }
    }
    spacer;
    ok_cancel_help;
}


/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_COMMENT : DCL Comments                                                      */
/*--------------------------------------------------------------------------------------*/
dcg_edit_comment : dialog {
    label = "EDIT: Comment(s)";
    initial_focus = "comment1";
    : row {
        : column {
            children_alignment = centered;
            children_fixed_width = true;
            : text { label = "Indent:"; }
            spacer;
            : toggle { key = "tab1"; }
            spacer;
            : toggle { key = "tab2"; }
            spacer;
            : toggle { key = "tab3"; }
            spacer;
            : toggle { key = "tab4"; }
            spacer;
            : toggle { key = "tab5"; }
        }
        : column {
            width = 50;
            spacer;
            spacer_1;
            : edit_box {
                key = "cmt1";
                allow_accept = true;
            }
            : edit_box {
                key = "cmt2";
                allow_accept = true;
            }
            : edit_box {
                key = "cmt3";
                allow_accept = true;
            }
            : edit_box {
                key = "cmt4";
                allow_accept = true;
            }
            : edit_box {
                key = "cmt5";
                allow_accept = true;
            }
        }
    }
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_PARAGRAPH : "PARAGRAPH" Attributes.                                         */
/*--------------------------------------------------------------------------------------*/
dcg_edit_paragraph : dialog {
    label = "EDIT: Paragraph";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_size1;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_CONCATENATION : "CONCATENATION" Attributes.                                 */
/*--------------------------------------------------------------------------------------*/
dcg_edit_concatenation : dialog {
    label = "EDIT: Concatenation";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_size1;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_COLUMN : "COLUMN" Attributes.                                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_column : dialog {
    label = "EDIT: Column";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_size1;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_ROW : "ROW" Attributes.                                                     */
/*--------------------------------------------------------------------------------------*/
dcg_edit_row : dialog {
    label = "EDIT: Row";
    initial_focus = "key";
    dcg_edt_key;
    dcg_edt_size1;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}    

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_BOXED_COLUMN : "BOXED COLUMN" Attributes.                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edit_boxed_column : dialog {
    label = "EDIT: Boxed Column";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_key;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_children;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
}  

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_BOXED_ROW : "BOXED ROW" Attribues.                                          */
/*--------------------------------------------------------------------------------------*/
dcg_edit_boxed_row : dialog {
    label = "EDIT: Boxed Row";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_key;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_children;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
}

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_RADIO_COLUMM : "RADIO COLUMN" Attributes.                                   */
/*--------------------------------------------------------------------------------------*/
dcg_edit_radio_column : dialog {
    label = "EDIT: Radio Column";
    initial_focus = "value";
    dcg_edt_value;
    dcg_edt_key;
    dcg_edt_action;
    spacer;
    dcg_edt_children;
    spacer;
    dcg_edt_size1;
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_RADIO_ROW : "RADIO ROW" Attributes.                                         */
/*--------------------------------------------------------------------------------------*/
dcg_edit_radio_row : dialog {
    label = "EDIT: Radio Row";
    initial_focus = "value";
    dcg_edt_value;
    dcg_edt_key;
    dcg_edt_action;
    spacer;
    dcg_edt_children;
    spacer;
    dcg_edt_size1;
    spacer;
    ok_cancel_help;
}
  
/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_B_R_COLUMN : "BOXED RADIO COLUMN" Attributes.                               */
/*--------------------------------------------------------------------------------------*/
dcg_edit_boxed_radio_column : dialog {
    label = "EDIT: Boxed Radio Column";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_attrib1;
        }
        : column {
            dcg_edt_children;
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
}        

/*--------------------------------------------------------------------------------------*/
/* DCG_EDIT_B_R_ROW : "BOXED RADIO ROW" Attributes.                                     */
/*--------------------------------------------------------------------------------------*/
dcg_edit_boxed_radio_row : dialog {
    label = "EDIT: Boxed Radio Row";
    initial_focus = "accept";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_attrib1;
        }
        : column {
            dcg_edt_children;
            spacer;
            dcg_edt_size1;
        }
    }
    spacer;
    ok_cancel_help;
} 
//======================================================================================//

