;
; *** Listing 13-25 ***
;
; Zeros the high-bit of each byte in a 100-byte array,
; using branched-to partial in-line code.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	100
ByteArray	label	byte
	db	ARRAY_LENGTH dup (80h)
;
; Clears the high bit of each byte in an array.
;
; Input:
;	BX = pointer to the start of the array to clear
;	CX = number of bytes to clear (0 means 0)
;
; Output: none
;
; Registers altered: AX, BX, CX, DX
;
ClearHighBits:
;
; Calculate the offset in the partial in-line code to which
; to jump in order to perform CX modulo 4 repetitions (the
; remaining repetitions will be handled by full passes
; through the loop).
;
	mov	ax,cx
	and	ax,3		;# of repetitions modulo 4
	mov	dx,ax
	shl	ax,1
	add	ax,dx		;(# of reps modulo 4) * 3
				; is the # of bytes from the
				; the end of the partial
				; in-line code to branch to
				; in order to handle the
				; # of repetitions that
				; can't be handled in a full
				; loop
	mov	dx,offset InLineBitClearEnd
	sub	dx,ax		;point back just enough
				; instruction bytes from
				; the end of the in-line
				; code to perform the
				; desired # of repetitions
	shr	cx,1		;divide by 4, since we'll do
	shr	cx,1		; 4 repetitions per loop
	inc	cx		;account for the first,
				; partial pass through the
				; loop
	mov	al,not 80h	;pattern to clear high bits
				; with
	jmp	dx		;finally, branch to perform
				; the desired # of
				; repetitions
;
; Partial in-line code to clear the high bits of 4 bytes per
; pass through the loop.
;
ClearHighBitsLoop:
	rept	4
	and	[bx],al		;clear the high bit of this
				; byte
	inc	bx		;point to the next byte
	endm
InLineBitClearEnd:
	loop	ClearHighBitsLoop
	ret
;
Skip:
	call	ZTimerOn
	mov	bx,offset ByteArray
				;array in which to clear
				; high bits
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
				; (always less than
				; MAXIMUM_ARRAY_LENGTH)
	call	ClearHighBits	;clear the high bits of the
				; bytes
	call	ZTimerOff
