; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; This example runs V86 mode code at IOPL 3. So, STI isn't detected, but IRQs
; must not be enabled -> disable IRQs by setting the PIC masks.

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
%define SWAT            0

TSS1dsc         seg_descriptor  2067h,0,0, 89h,
TSS1            TSS
                times   2000h db 0      ; 1 bit for each port; 64K / 8 = 8K
TSS1sel         dw      0

org_exc13       dd      0               ; offset and selector of original
                dw      0               ;  exception 13 handler
org_tr          dw      0               ; original Task Register contents
mPICmask        db      0               ; original master PIC mask
sPICmask        db      0               ; original slave PIC mask

msg0            db      'Not running at Privilege Level 0.','$'
msg1            db      'Message from exception 13 handler.',0
msg2            db      'Press a key to continue.',0

%ifdef  SWAT
org_arbyte      db      0               ; original access rights byte exc 13
%endif

;32-bit code
main:
                                        ; First, check if running at PL 0
        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jz short .PL0
        mov edx,msg0
        call dosprint
        jmp exit
.PL0:
;
        str [org_tr]                    ; Save original Task Register

        mov cx,1                        ; Allocate 1 descriptor for TSS
        call getdsc
        jc near @exit
        mov [TSS1sel],ax

        mov eax,[code32a]
        add eax,TSS1
        mov [TSS1dsc.base0_15],ax
        shr eax,16
        mov [TSS1dsc.base16_23],al
        mov [TSS1dsc.base24_31],ah

        mov es,[data32sel]
        mov edi,TSS1dsc
        mov bx,[TSS1sel]                ; bx=selector
        call setdsc
        jc near @exit

        cli
        ltr [TSS1sel]
;
        mov bl,13
        call getvect
        mov [org_exc13+4],cx            ; cx:edx=addr of exception handler
        mov [org_exc13],edx

        mov cx,cs                       ; Install V86 monitor
        mov edx,new_exc13
        call setvect
        jc near @exit
%ifdef  SWAT
        sub esp,6
        sidt [esp]
        mov edi,[esp+2]
        add esp,6
        mov al,[gs:edi+13*8+5]          ; Get access rights byte...
        mov [org_arbyte],al             ; ...and save it
        mov al,8eh                      ; int gate, DPL 0, present
        mov [gs:edi+13*8+5],al          ; Set access rights byte
%endif

        in al,21h                       ; Save PIC masks
        mov [mPICmask],al
        in al,0a1h
        mov [sPICmask],al
        mov al,0ffh                     ; Mask all IRQs
        out 21h,al
        out 0a1h,al

        push ds
        push es
        push fs
        push gs
        mov [TSS1.ss0],ss               ; Save protected mode ss:esp in Task
        mov [TSS1.esp0],esp             ;  State Segment -> V86 monitor uses 
                                        ;  current stack
                                        ; Build stack frame for entering V86 
        push dword [v86r_gs]            ;  mode: gs,
        push dword [v86r_fs]            ;  fs,
        push dword [v86r_ds]            ;  ds,
        push dword [v86r_es]            ;  es,
        push dword v86code              ;  ss,
        push dword v86stackbase         ;  esp,
        pushfd                          ;  eflags,
        or dword [esp],20000h           ; Set virtual 8086 mode flag
        push dword v86code              ;  cs,
        push dword v86start             ;  eip
        iretd                           ; VM bit in eflags on stack is set ->
retfromV86:                             ;  get eip, cs, eflags, esp, ss, es,
        pop gs                          ;  ds, fs, gs from stack -> V86 mode
        pop fs
        pop es
        pop ds

        mov bl,13
        mov cx,[org_exc13+4]            ; cx:edx=addr of exception handler
        mov edx,[org_exc13]
        call setvect
%ifdef  SWAT
        sub esp,6
        sidt [esp]
        mov ebx,[esp+2]
        add esp,6
        mov al,[org_arbyte]             ; Get original access rights byte...
        mov [gs:ebx+13*8+5],al          ; ...and restore it
%endif

        mov al,[mPICmask]               ; Restore original PIC masks
        out 21h,al
        mov al,[sPICmask]
        out 0a1h,al

@exit:
        sub esp,6
        sgdt [esp]
        mov eax,[esp+2]
        add esp,6
        movzx ebx,word [org_tr]
        and ebx,~ 3                     ; ebx=offset of TSS dsc in GDT
        and byte [gs:eax+ebx+5],~ 2     ; Clear Busy bit
        ltr [org_tr]                    ; Restore original Task Register
        sti

        mov esi,msg2
        @rlp edi,0b8000h+2*160
        mov bl,1fh
        call putstr
        mov byte [v86r_ah],0            ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
new_exc13:                              ; General protection
        test byte [esp+14],2            ; exc in V86 -> gs,fs,ds,es,ss,esp,
        jnz short V86monitor            ;  eflags,cs,eip,error code on stack
        jmp far [org_exc13]             ; Jump to 'normal' handler
V86monitor:                             ; Must remove error code from stack
        add esp,4                       ;  before IRETD instruction
        pushad                          ; eax,ecx,edx,ebx,esp,ebp,esi,edi =
        mov ds,[cs:zerosel]             ;  32 bytes pushed on stack
        movzx ebx,word [esp+36]         ; ebx=V86 cs
        shl ebx,4                       ; ebx=linear address of cs
        add ebx,[esp+32]                ; ebx=linear address of instruction
        inc word [esp+32]               ;  that caused exception
        mov al,[ebx]                    ; eip on stack points 1 byte past 
        mov dl,3                        ;  instruction that caused exception
        cmp al,0cch                     ; Is it a 1 byte INT 3 instruction?
        je short emu_int
        mov dl,4
        cmp al,0ceh                     ; Is it a 1 byte INTO instruction?
        je short emu_int
        cmp al,0cdh                     ; Is it a 2 byte INT instruction?
        je short .INTopcode
        popad
        int 15                          ; Indicate unhandled error while V86
.INTopcode:
        inc word [esp+32]               ; eip on stack 1 byte past int number
        mov dl,[ebx+1]                  ; dl=int number to call
        cmp dl,RMCALL_VECT              ; Exit V86 mode?
        jne short emu_int
        add esp,68                      ; Remove 9+8 dwords from the stack ->
        jmp retfromV86                  ;  original PM esp
emu_int:                                ; Emulate INT instruction
        mov ds,[cs:zerosel]
        movzx ebx,dl
        shl ebx,2                       ; ebx=address of real mode int vector
        movzx edx,word [esp+48]         ; edx=V86 ss
        shl edx,4                       ; edx=linear address of ss 
        sub word [esp+44],6             ; Reserve 6 bytes on V86 stack for
        add edx,[esp+44]                ;  flags + return address after int 
        mov ax,[esp+40]                 ; edx=linear address top of V86 stack
        mov [edx+4],ax                  ; ax=V86 flags
        mov ax,[esp+36]                 ; ax=V86 cs
        mov [edx+2],ax
        mov ax,[esp+32]                 ; ax=V86 ip
        mov [edx],ax                    ; Return to V86_int after int
        and byte [esp+41],~ 3           ; Clear IF and TF (trap flag)
        mov eax,[ebx]
        mov [esp+32],ax                 ; Put ip of int handler on stack
        shr eax,16
        mov [esp+36],ax                 ; Put cs of int handler on stack
        popad                           ; VM bit in eflags on stack is set ->
        iretd                           ;  after iretd -> back in V86 mode

segment v86code public align=16 use16

;16-bit data
v86stack        resb    100             ; V86 mode stack
v86stackbase:

v86msg          db      'Message from Virtual 8086 mode.'
v86msglen       equ     $-v86msg
v86msg2         db      'V86 message printed by emulated int 10h.'
v86msg2len      equ     $-v86msg2

;16-bit code
v86start:
        mov ax,cs
        mov ds,ax
        mov si,v86msg
        mov ax,0b800h
        mov es,ax
        mov di,0
        mov cx,v86msglen
        mov ah,1fh
.putchar:                               ; Print first message
        lodsb
        stosw
        loop .putchar

        mov ah,13h                      ; ah=13h -> Write string
        mov al,0                        ; ah=0 -> str chars only, attr in bl
        mov bh,0                        ; bh=video page number
        mov bl,1fh                      ; bl=attribute if al bit 1=0
        mov cx,v86msg2len               ; cx=length of string
        mov dh,1                        ; dh=row coordinate
        mov dl,0                        ; dl=column coordinate
        mov di,seg v86msg2
        mov es,di
        mov bp,v86msg2                  ; es:bp=pointer to string
        int 10h                         ; Emulate INT instruction

        int RMCALL_VECT                 ; int with DPL < 3 or not in IDT ->
                                        ;  exc 13. V86 monitor checks for int
                                        ;  RMCALL_VECT
