; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; This program shows 2 features of the 386+ that are connected to switching
; between protected mode and real mode.
; 1.) When switching from protected mode to real mode the invisible part of
;     segment registers stays current. This applies to segments greater than
;     64KB ("flat real mode"), but it applies to segments smaller than 64KB
;     too.
;     The default bit also stays current. So _e_sp is used by stack using
;     instructions when the default bit was set in the stack's descriptor.
;     As long as the segment registers aren't reloaded the base of the
;     protected mode segments stays active in real mode.
; 2.) When switching from real mode to protected mode the base of the segment
;     registers stays current.
;
; Since this program disables paging in order to switch to real mode, it
; could cause a page fault under a VCPI server that maps the linear addresses
; below 1MB not to the same physical addresses (no identity mapping). I
; haven't seen VCPI servers that don't identity map the memory below 1MB, but
; to make this program work under such a VCPI server:
; 1.) call map_phys_addr to map some physical address below 1MB
; 2.) copy the piece of code that must execute in RM to that memory

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
toRM            dd      0               ; 32-bit offset
                dw      0               ; selector
oidtr           dw      0,0,0
oint13          dd      0               ; original interrupt 13 vector
ostack:
oesp            dd      0
oss             dw      0
memptr          dd      0
testvar1        dd      0               ; 11111111h->base of PM ds active
testvar2        dd      0               ; 22222222h->limit of PM ds active
testvar3        dd      0               ; 33333333h->default bit PM ss active
testvar1msg     db      'testvar1(hex)=',0
testvar2msg     db      'testvar2(hex)=',0
testvar3msg     db      'testvar3(hex)=',0
PLmsg           db      'Not running at Privilege Level 0.','$'

;32-bit code
main:
                                        ; First, check if running at PL 0
        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jz short .PL0
        mov edx,PLmsg
        call dosprint
        jmp @exit
.PL0:
;
        mov ax,[code16sel]
        mov [toRM+4],ax
        mov dword [toRM],RMstart

        mov ebx,toPM
        add ebx,[code16a]
        mov [gs:ebx+2],cs
        mov ax,backinPM
        mov [gs:ebx],ax

        mov eax,64*1024+8               ; Be sure offset is greater than 64K
        call getmem                     ; +8 -> 2 dwords for test variables
        jc near @exit
        mov [memptr],eax
        add dword [memptr],64*1024      ; testvar2 at memptr

        cli
        sidt [oidtr]                    ; Save original IDTR
        mov eax,[gs:13*4]               ; Save original interrupt 13 vector
        mov [oint13],eax
        mov word [gs:13*4],RMexc13
        mov word [gs:13*4+2],code16     ; Install RM exception 13 handler

        push ds
        push es
        push fs
        push gs
        mov [oesp],esp
        mov [oss],ss

        jmp far [toRM]

backinPM:
        lss esp,[cs:ostack]
        pop gs
        pop fs
        pop es
        pop ds
        mov eax,[oint13]                ; Restore original int 13 vector
        mov [gs:13*4],eax
        lidt [oidtr]                    ; Restore original IDTR
        sti

        mov es,[data16sel]
        cmp byte [es:exc13],0
        jnz @exit                       ; exception 13 in RM caused exit

        mov edi,[memptr]
        mov eax,[edi]
        mov [testvar2],eax
        mov eax,[edi+4]
        mov [testvar3],eax

        mov esi,testvar1msg
        mov es,[zerosel]
        mov edi,0b8000h+160
        mov bl,1fh
        call putstr
        mov eax,[testvar1]
        call putnum

        mov esi,testvar2msg
        mov edi,0b8000h+2*160
        call putstr
        mov eax,[testvar2]
        call putnum

        mov esi,testvar3msg
        mov edi,0b8000h+3*160
        call putstr
        mov eax,[testvar3]
        call putnum

@exit:
        jmp exit                        ; Return to real/V86 mode

;
; Put number in eax to es:edi in ASCII hexadecimal
; In:
;   eax = number
;   bl = character attribute
; Out:
;   edi = 1 byte past last written character
;
putnum:
        push eax
        push ebx
        push ecx
        push edx
        mov edx,eax
        mov ah,bl
        mov ebx,hextbl
        mov ecx,8
.next_digit:
        rol edx,4
        mov al,dl
        and al,0fh
        xlatb
        stosw
        loop .next_digit
        pop edx
        pop ecx
        pop ebx
        pop eax
        ret

segment code16

;16-bit data
ocr0            dd      0               ; Saved CR0 contents
RMidtr          dw      3ffh,0,0
toPM            dw      0               ; 16-bit offset
                dw      0               ; selector
RMexc13msg      db      'Exception 13 in real mode.'
RMexc13msglen   equ     $-RMexc13msg
exc13           db      0               ; If non-zero -> exc13 caused exit

;16-bit code
RMstart:
        lidt [cs:RMidtr]                ; necessary so exc 13 calls RMexc13
        mov eax,cr0
        mov gs,[cs:data16sel wrt code16]
        mov [gs:ocr0],eax
        and eax,7ffffffeh               ; Clear Paging and Protection Enable
        mov cr0,eax
                                        ; in RM with cs still the PM value
        mov dword [testvar1],11111111h  ; ds still has the PM value

        mov ax,0
        mov ds,ax
        mov edi,[cs:memptr wrt code16]
        add edi,[cs:code32a wrt code16]
        mov dword [ds:edi],22222222h    ; testvar2=22222222h

        mov edi,100h                    ; at startup es=pspsel (=256 bytes)
;       mov ax,[es:edi]                 ; exception 13

        mov ax,0
        mov ss,ax
        mov esp,[cs:memptr wrt code16]  ; at startup ss=data32sel (default=1)
        add esp,4+4                     ; dword value is pushed at esp-4
        add esp,[cs:code32a wrt code16]
        push dword 33333333h            ; testvar3=33333333h

        jmp code16:$+5                  ; JMP intersegment (sets cs)

        mov eax,[cs:ocr0]
        mov cr0,eax                     ; in PM while cs has a RM value
        jmp far [cs:toPM]               ; Return to 32-bit PM

;
RMexc13:
        jmp code16:$+5                  ; Needed on my 386 for "mov cs:...",
                                        ;  NOT on my Pentium
        mov byte [cs:exc13],1           ; Indicate that exc13 has been raised
        mov eax,[cs:ocr0]
        mov cr0,eax                     ; Restore original CR0 value
                                        ; in PM again
        mov ds,[cs:data16sel wrt code16]
        mov si,RMexc13msg
        mov es,[cs:zerosel wrt code16]
        mov edi,0b8000h+160
        mov cx,RMexc13msglen
        mov ah,1fh
.putchar:
        lodsb
        a32 stosw
        loop .putchar
        jmp far [cs:toPM]               ; Return to 32-bit PM
