 title Mystic.Inc by ASN (21/07/1998) - Include file for writing screen savers

; This file MUST be INCLUDED in the screen saver module

 .xlist                                ; suppress listing of this stuff

;--------------------------------- EQUATES ----------------------------------;
 TICKS_PER_SECOND  equ     18          ; timer ticks 18 times/sec.

 TEXT_40x25_2    equ  00h
 TEXT_40x25_16   equ  01h
 TEXT_80x25_2    equ  02h
 TEXT_80x25_16   equ  03h
 CGA_320x200_4   equ  04h
 CGA_640x200_2   equ  06h
 VGA_640x480_2   equ  11h
 VGA_640x480_16  equ  12h
 VGA_320x200_256 equ  13h

;--------------------------------- PUBLICS ----------------------------------; 
 public SS_Main_Body_Code
 public SS_Initialize
 public SS_Start_Up_Code
 public SS_Clean_Up_Code
 public SS_API_Handler
 public SS_Time_Delay
 public SS_Resident_Code_End
 public SS_Message
 public SS_Valid_Mode_List
 public SS_Module_Name
 public SS_Author_Name

;----------------------------------------------------------------------------;
; Macro   : Module_Name_Is                                                          ;
; Purpose : sets screen saver name                                           ;
; Args.   : name : screen saver name in single/double quotes                 ;
; Regs mod: none                                                             ;
; Updated : 21/07/1998                                                       ;
;----------------------------------------------------------------------------;
 Module_Name_Is macro name
 ifb <name>
     SS_Module_Name db 'No_Name', 0
 else
     SS_Module_Name db name, 0
 endif
                      endm

;----------------------------------------------------------------------------;
; Macro   : Authors_Name_Is                                                  ;
; Purpose : sets screen saver author's name                                  ;
; Args.   : name : author's in single/double quotes                          ;
; Regs mod: none                                                             ;
; Updated : 21/07/1998                                                       ;
;----------------------------------------------------------------------------;
 Authors_Name_Is macro name
 ifb <name>
     SS_Author_Name db 'Anonymous', 0
 else
     SS_Author_Name db name, 0
 endif
                      endm

;----------------------------------------------------------------------------;
; Macro   : Time_Delay_Is                                                    ;
; Purpose : sets screen saver time delay                                     ;
; Args.   : delay : absolute delay in seconds                                ;
; Regs mod: none                                                             ;
; Updated : 21/07/1998                                                       ;
;----------------------------------------------------------------------------;
 Time_Delay_Is macro delay
 DEFAULT_TIME_DELAY = (60 * TICKS_PER_SECOND)

 ifb <delay>
     SS_TimeDelay dw DEFAULT_TIME_DELAY         ; set default delay (60s)
 else               
     TIME_DELAY = (delay * TICKS_PER_SECOND)
     if TIME_DELAY gt 3640
         %out Time_Delay_Is : delay value may not exceed 3640s.
         %out Time_Delay_Is : reverting to default 60s delay.
         SS_Time_Delay dw DEFAULT_TIME_DELAY     ; set default delay (60s)
     else
         SS_Time_Delay dw TIME_DELAY  ; set specified delay
     endif
 endif               
                endm

;----------------------------------------------------------------------------;
; Macro   : Valid_Modes_Are                                                  ;
; Purpose : determines in what modes screen-saver will be activated          ;
; Args.   : m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15 ;
; Regs mod: none                                                             ;
; Updated : 21/07/1998                                                       ;
;----------------------------------------------------------------------------;
 Valid_Modes_Are macro m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15
 VALID_MODES_HI = 0
 VALID_MODES_LO = 0

 irp mode, <m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15>
     ifnb <mode>
         if mode gt 15
             VALID_MODES_HI = ((VALID_MODES_HI) or (1 shl (mode mod 16)))
         else
             VALID_MODES_LO = ((VALID_MODES_LO) or (1 shl mode))
         endif
     endif
 endm

     SS_Valid_Mode_List label dword
         dw VALID_MODES_LO
         dw VALID_MODES_HI
                 endm

;----------------------------------------------------------------------------;
 .list                            ; enable listing once more

;x------------------------------ Mystic.Inc --------------------------------x;
