;// MMx Mandelbrot (first real application test)
ideal
p586
p587
locals __

%nolist
smart
warn icg
nowarn  mcp
warn pro
multerrs

include "mmx.ash"
%list

STACKSIZE       equ     4096

INTEGER         equ     4
PREC            equ     ((16-1)-INTEGER)

ResX            equ     320
ResY            equ     200

RMIN            equ     (-220 shl PREC)/100
RMAX            equ     (110 shl PREC)/100
IMIN            equ     (-120 shl PREC)/100
IMAX            equ     (120 shl PREC)/100

DELTAR          equ     ((RMAX-RMIN)/ResX)
DELTAI          equ     ((IMAX-IMIN)/ResY)


segment         _DATA use16 para public 'DATA'

fatal_error     db      "Fatal memory allocation error.",13,10,'$'
nommx           db      "Sorry, you NEED an MMx CPU to try this out",13,10,'$'
align qword
_mm2            MMxMem  < ?, < IMIN, RMIN > >
_mm3            MMxMem  < ?, < DELTAI, RMIN > >
_mm4            MMxMem  < ?, < 0, DELTAR > >
negmask         MMxMem  < ?, ?, < 1, 1, -1, 1 > >
oddword         MMxMem  < ?, ?, < -1, 0, -1, 0 > >
evenword        MMxMem  < ?, ?, < 0, -1, 0, -1 > >
check           MMxMem  < ?, < 255, (4 SHL PREC)-1 > >
align word

ends            _DATA


segment         _TEXT use16 para public 'CODE'
		assume cs:_TEXT, ds:_DATA

start:          mov   ax,es
		mov   bx,ss
		add   bx,STACKSIZE/16
		sub   bx,ax
		mov   ah,4ah
		int   21h
		jnc   short __ok
		mov   dx,offset fatal_error
__print:        mov   ah,9
		int   21h
		mov   ax,4cffh
		int   21h

__ok:           mov   ax,_DATA
		mov   ds,ax
		mov   sp,STACKSIZE
		mov   bp,sp

;// check for MMX subsystem (why???)
		pushfd
		pop   eax
		mov   ebx,eax
		xor   eax,1000000000000000000000b
		push  eax
		popfd
		pushfd
		pop   eax
		cmp   eax,ebx
		jz    short __bailout
		mov   eax,1
		cpuid
		test  edx,100000000000000000000000b
		jnz   short __mmxok
__bailout:      mov   dx,offset nommx
		jmp   short __print

__mmxok:        mov   ax,13h
		int   10h
		mov   ax,0a000h
		mov   es,ax

		emms

		xor   edx,edx
		movq  mm2,[mmword _mm2] ;//      rMin      iMin
		movq  mm3,[mmword _mm3] ;//      0         iInc
		packssdw mm2,mm2        ;// rMin iMin rMin iMin
		movq  mm4,[mmword _mm4] ;//      rInc      iMin
		packssdw mm3,mm3        ;// rMin iInc rMin iInc
		packssdw mm4,mm4        ;// rInc 0    rInc 0

_loopy:         xor   cx,cx

_loopx:         pxor  mm5,mm5
		movq  mm0,mm2
		mov   eax,1

_iter:          movq  mm1,mm0                   ;//  rel  imag  rel  imag
		pmullw mm1,[mmword negmask]     ;//  rel -imag  rel  imag
		movq  mm6,mm0
		pmaddwd mm1,mm0
		psrlq mm0,16                    ;//  0    rel   imag  rel
		pand  mm0,[mmword oddword]      ;//  0    rel   0     rel
		psrad mm1,PREC
		punpckldq mm5,mm1               ;//  check       curcount
		pmaddwd mm0,mm6                 ;//  0+rel*imag 0+rel*imag
		pcmpgtd mm5,[mmword check]
		psrlq mm1,32                    ;//             0 res.rel
		packssdw mm5,mm5
		psrad mm0,PREC-1
		movd  ebx,mm5
		cmp   ebx,0
		jne   short _doneiter
		inc   ax
		punpckldq mm0,mm1               ;//     res.rel  res.imag
		movd  mm5,eax
		packssdw mm0,mm0        ;// res.rel res.imag res.rel res.imag
		paddsw mm0,mm2          ;// z^2+c
		jmp   short _iter
_doneiter:      lea   edi,[edx*4+edx]
		paddsw mm2,mm4          ;// add rInc
		shl   di,6
		add   di,cx
		inc   cx
		mov   [es:di],al
		cmp   cx,ResX
		jne   short _loopx
		inc   dx
		pand  mm2,[mmword oddword] ;// rel 0 rel 0
		cmp   dx,ResY
		paddsw mm2,mm3          ;// add iInc
		jne   short _loopy

		emms
		mov   ax,0
		int   16h
		mov   ax,3
		int   10h

		mov   ax,4c00h
		int   21h

ends            _TEXT

segment         _STACK stack 'STACK'
ends            _STACK

end start
