
	PAGE	60,132
;
; CKCOMPAQ : A program to check for the COMPAQ copyright notice in the BIOS ROM.
;
;	Tom Brengle (BRENGLE%LLL@LLL.MFE)
;
;	Lawrence Livermore National Laboratory
;	P. O. Box 5511, L-630
;	Livermore, California  94550
;
; CKCOMPAQ checks for COMPAQ Corp's copyright notice in the BIOS ROM.  If it
; finds the correct notice, the program sets the ERRORLEVEL to zero and exits.
; Otherwise, it sets the ERRORLEVEL to one and exits.  This program is useful
; for controlling the installation of hardware-dependent software at boot-up
; time through the use of IF ERRORLEVEL commands in the AUTOEXEC.BAT file.
;
; To build CKCOMPAQ :
;
;	1.  Assemble CKCOMPAQ.
;
;		MASM CKCOMPAQ;
;
;	2.  Link CKCOMPAQ;
;
;		LINK CKCOMPAQ;
;
;	3.  Convert CKCOMPAQ.EXE to CKCOMPAQ.COM;
;
;		EXE2BIN CKCOMPAQ.EXE CKCOMPAQ.COM
;
;
ROM_BIOS_Code	segment at 0F000h	; Locate the ROM BIOS code segment.
	org	0A000h
ROM_Notice	db	69d dup (?)
ROM_BIOS_Code	ends

code_seg	segment
	assume	cs:code_seg
	org	100h
Begin:	jmp	CkCOMPAQ

COMPAQ_Notice	db	'(C) Copyright COMPAQ Computer Corporation, 1982, All rights reserved.',0

CkCOMPAQ	proc	near
	assume	ds:ROM_BIOS_Code	; Set up ROM BIOS data segment.
	mov	bx,ROM_BIOS_Code
	mov	ds,bx

	mov	si,offset COMPAQ_Notice ; Set up pointers to the two strings.
	mov	di,offset ROM_Notice

Loop:	mov	al,cs:[si]		; Get the next char of the COMPAQ notice.
	cmp	al,0			; Is it the trailing null?
	je	COMPAQ_OK		; Yes, then the strings match.
	cmp	al,ds:[di]		; Otherwise, check it against the next char of the ROM notice.
	jne	Not_COMPAQ		; If not the same, the strings are different.
	inc	si			; Increment pointers...
	inc	di
	jmp	Loop			; ... and loop back for next char.

Not_COMPAQ:				; Here if strings don't match.
	mov	al,1			; Set the error level to one.
	mov	ah,4Ch			; Exit to DOS.
	int	21h

COMPAQ_OK:				; Here if strings match.
	mov	al,0			; Set the error level to zero.
	mov	ah,4Ch			; Exit to DOS.
	int	21h

CkCOMPAQ	endp
code_seg	ends

	end	Begin
