: MAKEIT provides flexibility in the use of the Microsoft MAKE utility.
:
: When invoked without parameters, as in:
:
:	MAKEIT
:
: the current directory is searched for a file named MAKEFILE, which, if found
: is assumed to contain the dependency list for MAKE, and control is passed to
: MAKE.  If MAKEFILE is not found in the current directory, MAKEIT terminates
: with an error message.
:
: When invoked with one parameter, as in:
:
:	MAKEIT MAKELIST
:
: that parameter (in this case, MAKELIST) is assumed to be the name of the
: dependency list file, and a search for it is made, with results as in the
: previous invocation.
:
: Regardless of the invocation, while MAKE is executing, all standard output
: is redirected to a file named MAKE.OUT in the current directory.  When MAKE
: is finished, MAKE.OUT is then written to standard output (using MORE) for
: review.  In this way, a record of the session is also written to disk.
:
ECHO OFF
CLS
TIM
DAT
IF "%1"=="" GOTO TEST2
:
IF EXIST %1 GOTO FOUND1
:
ECHO MAKEIT: %1 NOT FOUND
ECHO 
GOTO END
:
:FOUND1
ECHO MAKING %1 ...
TM START /C1 /N /LOG
MAKE %1 > MAKE.OUT
TM STOP /C1 /N /L /LOG >> MAKE.OUT
TM /L /LOG >> MAKE.OUT
ECHO 
GOTO CAT
:
:TEST2
IF EXIST MAKEFILE GOTO FOUND2
:
ECHO MAKEIT: MAKEFILE NOT FOUND
ECHO 
GOTO END
:
:FOUND2
ECHO MAKING MAKEFILE ...
TM START /C1 /N /LOG
MAKE MAKEFILE > MAKE.OUT
TM STOP /C1 /N /L /LOG >> MAKE.OUT
TM /L /LOG >> MAKE.OUT
ECHO 
:
:CAT
MORE MAKE.OUT
:
:END
