;-------------------------------
;   HEXDISPLAY From IAN MOOTE

;This routine is mainly for debugging purposes.  It is to be added to programs
;       which need to display register contents in hexidecimal.
;
;ENTRY: .DX = The hex value to be displayed.
;
; EXIT: .DX and .AL destroyed.
;       Four calls to INT21h Function 02h.
;

HEXDISPLAY:
        ;Preserve contents of DX four times for later processing.
                PUSH DX
                PUSH DX
                PUSH DX
                PUSH DX

        ;Display a leading space.
                MOV DL,20h
                MOV AH,02h
                INT 21h

        ;Process for display.
                POP DX
                SHR DX,0Ch      ;Shift the first nibble to the extreme right.
                CALL HEXDISPLAY0
                POP DX          ;Restore .DX.
                SHR DX,08h      ;Shift the second nibble to the extreme right.
                CALL HEXDISPLAY0
                POP DX          ;Restore .DX.
                SHR DX,04h      ;Shift the third nibble to the extreme right.
                CALL HEXDISPLAY0
                POP DX          ;Restore .DX; the last nibble is in the correct
                                ;       position.

HEXDISPLAY0:
                MOV AH,02h      ;Set up to display the character.
                AND DL,0Fh      ;Zero all bits but the least significant nibble.
                ADD DL,30h      ;Convert to ASCII.
                CMP DL,3Ah      ;Check to see if nibble is 0-9.
                IF GE ADD DL,07h        ;Adjust for nibble value between A-F.
                INT 21h         ;DOS interrupt; Display byte to STDOUT.
                RET


