
019/019 25 Jul 90 12:48:36
From:   George Adam Stanislav
To:     All
Subj:   CLS in CON
Attr:   
------------------------------------------------
Well, folks, I finally got it all working right. I promissed I'd share my 
discoveries, so here goes:

COMMAND.COM of DOS 4 no longer relies on the technique Craig told us about (and 
Craig himself admitted it may not work with DOS 4). Instead, DOS 4 uses the 
multiplex interrupt, int 2Fh, function 1Ah to deal with ANSI.SYS. A quick 
browse through Ralf Brown's latest interrupt list shows that this interrupt 
whenever call with AL=0 is the check if a funtion is installed.

Commercial break: :-)

The latest interrupt list directory entry is:

     INTER390 ZIP    233751 07-15-90   1:48p

It is freqable from here (HST 9600 bps) and elsewhere.

We now return to regularly scheduled program:

OK, now COMMAND.COM calls int 2Fh with AX=1A00h to determine whether ANSI is 
there. If so, it will issue an esc[2J command, else it will do further checking 
but will eventually use BIOS to clear the screen.

That I posted last night. However, grabbing int 2Fh, when AX=1A00h, was not 
good enough. As soon as AVATAR.SYS was loaded, the system froze tight (big red 
button time). After studying the interrupt list mentioned above, I modified the 
code to return Al=FFh and no carry when int 2Fh is called with AX=1A00h, and to 
return AX=1 and carry when called with AH=1Ah, AL <> 00h. This finally worked: 
no lockups, CLS confined to current Avatar window <whew!>. But there still was 
a catch: When I disabled AVATAR (it can be done via IOCTL), CLS would still 
send esc[2J. This would be fine with ANSI.SYS loaded, but not without. When 
disabled, AVATAR.SYS simply restores the old CON driver which if it happens to 
be the default DOS CON driver just dumps everything to DOS TTY write.

Finally, I modified my int_2Fh procedure not to do anything if AVATAR.SYS is 
disabled, but to work with function 1Ah if enabled. Here is the actual code 
from AVATAR.ASM:

        int_2Fh         proc    FAR

                pushf
                pushf
                cmp     ah, 1Ah
                jne     int_2Fh_pass
                mov     cs:int_2Fh_flag, -1
                mov     cs:int_2Fh_AL, al

        int_2Fh_pass:
                popf
                call    dword ptr cs:old_int_2Fh
                pushf
                cmp     cs:int_2Fh_flag, 0
                jne     int_2Fh_AVT_out

        int_2Fh_OUT:
                popf
                ret     2

        int_2Fh_AVT_out:
                mov     cs:int_2Fh_flag, 0

                ; Check if I am the active CON driver
                cmp     int_29h_active, 0
                je      int_2Fh_OUT             ; not active

                ; See if this was a presence check
                cmp     int_2Fh_AL, 0
                jne     int_2Fh_carry           ; no, something else

                ; Yes, tell'em we're here
                mov     al, 0FFh
                popf
                clc
                ret     2

        int_2Fh_carry:
                mov     ax, 1
                popf
                stc
                ret     2

        int_2Fh         endp

That's all there is to it. Quite simple once all the mysteries are unveiled. 
The unveiling itself is the hard part, but very rewarding too. :-)

                                          Adam

--- FD 1.99c
 * Origin: 80XXX Moderator (1:129/39)
